/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.ics.portal.dto;

public class CatalogPageInfo {
    private static final int DEFAULT_PAGEINDEX = 1;
    private static final int DEFAULT_PAGESIZE = 10;
    private static final int MAX_PAGESIZE = 10000;
    private int start;
    private int end;
    private int totalCatalogNum;
    private int totalPidsNum;
    private String htmlPieces;

    public CatalogPageInfo(int pageIndex, int pageSize) {
        int index = pageIndex <= 0 ? 1 : pageIndex;
        int size = pageSize <= 0 ? 10 : pageSize;
        size = Math.min(size, 10000);
        this.start = (index - 1) * size;
        this.end = Math.addExact(this.start, size);
        this.htmlPieces = "";
    }

    public void addTotalCatalogNum(int catalogNum) {
        this.totalCatalogNum += catalogNum;
    }

    public void addTotalPidsNum(int pidsNum) {
        this.totalPidsNum += pidsNum;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getTotalCatalogNum() {
        return this.totalCatalogNum;
    }

    public int getTotalPidsNum() {
        return this.totalPidsNum;
    }

    public String getHtmlPieces() {
        return this.htmlPieces;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setTotalCatalogNum(int totalCatalogNum) {
        this.totalCatalogNum = totalCatalogNum;
    }

    public void setTotalPidsNum(int totalPidsNum) {
        this.totalPidsNum = totalPidsNum;
    }

    public void setHtmlPieces(String htmlPieces) {
        this.htmlPieces = htmlPieces;
    }

    public CatalogPageInfo() {
    }
}

