/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.ics.portal.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavTreeDto;
import com.huawei.support.icslite.business.docnav.serviceimpl.IcsDocnavBusinessServiceHandler;
import com.huawei.support.icslite.business.ics.portal.constant.IcsPortalConstants;
import com.huawei.support.icslite.business.ics.portal.dto.CatalogPageInfo;
import com.huawei.support.icslite.business.ics.portal.dto.IcsPortalCategoryDto;
import com.huawei.support.icslite.business.ics.portal.dto.IcsPortalDto;
import com.huawei.support.icslite.business.ics.portal.dto.IcsPortalNaviDto;
import com.huawei.support.icslite.business.ics.portal.dto.IcsPortalPidDto;
import com.huawei.support.icslite.business.ics.portal.service.IcsPortalBusiness;
import com.huawei.wsf.core.HWEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsPortalBusinessHandler
implements IcsPortalBusiness {
    private static final int PID_SHOW_SIZE_10 = 10;
    private static final int BUF_SIZE_1000 = 1000;
    private static final int BUF_SIZE_200 = 200;
    private static final int BUF_SIZE_100 = 100;
    private static final String PRINT_SAVE_PORTAL_TYPE = "portal";
    private static final TypeReference<List<String>> LIST_STRING_REFERENCE = new TypeReference<List<String>>(){};
    private String pidItemClass = "pid-item";
    private String pidItemHideClass = "pid-item hidemore";
    private String pidNameIsBlank = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    private IcsPortalBusinessHandler() {
    }

    public static IcsPortalBusinessHandler getInstance() {
        return IcsPortalBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public CatalogPageInfo getCatalogPageInfo(IcsPortalDto icsPortalDto) {
        int pageIndex = icsPortalDto.getPageIndex();
        int pageSize = icsPortalDto.getPageSize();
        CatalogPageInfo pageInfo = new CatalogPageInfo(pageIndex, pageSize);
        String docId = icsPortalDto.getDocId();
        String tabId = icsPortalDto.getTabId();
        String navItemPath = icsPortalDto.getNavItemPath();
        List<IcsDocnavTreeDto> icsDocnavTreeDtos = IcsDocnavBusinessServiceHandler.getInstance().getNaviPid(docId, tabId, navItemPath);
        if (CollectionUtils.isEmpty(icsDocnavTreeDtos)) {
            return pageInfo;
        }
        LinkedHashMap<String, Object> mapFilter = new LinkedHashMap<String, Object>(0);
        String filterParam = icsPortalDto.getFilters();
        if (StringUtils.isNotBlank((CharSequence)filterParam)) {
            mapFilter.putAll(JsonUtils.stringToMap((String)filterParam));
        }
        ArrayList<IcsDocnavTreeDto> resultList = new ArrayList<IcsDocnavTreeDto>(100);
        icsDocnavTreeDtos.stream().filter(icsDocnavTreeDto -> this.filterCatalog((IcsDocnavTreeDto)icsDocnavTreeDto, (Map<String, Object>)mapFilter, (List<IcsDocnavTreeDto>)resultList, pageInfo)).collect(Collectors.toList());
        pageInfo.setHtmlPieces(this.getPidListHtml(docId, tabId, this.getQmsParam(docId, tabId, mapFilter), resultList));
        return pageInfo;
    }

    @Override
    public List<IcsPortalNaviDto> getPortalTreeData(String docId) {
        List<IcsPortalNaviDto> portalNaviDtoList = new ArrayList<IcsPortalNaviDto>();
        List docNavDoList = IcsDocnavBusinessServiceHandler.getInstance().getDocnavDoList(docId).stream().filter(icsDocNavDto -> StringUtils.isNotBlank((CharSequence)icsDocNavDto.getDocnavName())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(docNavDoList)) {
            return portalNaviDtoList;
        }
        portalNaviDtoList = docNavDoList.stream().map(icsDocnavDto -> {
            IcsPortalNaviDto portalNaviDto = new IcsPortalNaviDto();
            portalNaviDto.setDocNaviId(icsDocnavDto.getDocnavId());
            portalNaviDto.setName(icsDocnavDto.getDocnavName());
            portalNaviDto.setPrintSaveType(PRINT_SAVE_PORTAL_TYPE);
            portalNaviDto.setChildren(this.getCategoryList(docId, portalNaviDto.getDocNaviId()));
            return portalNaviDto;
        }).collect(Collectors.toList());
        return portalNaviDtoList;
    }

    private List<IcsPortalCategoryDto> getCategoryList(String docId, String tabId) {
        List icsDocNavTreeDtoList = IcsDocnavBusinessServiceHandler.getInstance().getNaviPid(docId, tabId, "").stream().filter(icsDocNavTreeDto -> StringUtils.equals((CharSequence)icsDocNavTreeDto.getType(), (CharSequence)"docCategory") && CollectionUtils.isNotEmpty(icsDocNavTreeDto.getIcsPidSet())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(icsDocNavTreeDtoList)) {
            return new ArrayList<IcsPortalCategoryDto>();
        }
        return icsDocNavTreeDtoList.stream().map(icsDocNavTreeDto -> {
            IcsPortalCategoryDto categoryDto = new IcsPortalCategoryDto();
            categoryDto.setName(icsDocNavTreeDto.getName());
            categoryDto.setPrintSaveType(PRINT_SAVE_PORTAL_TYPE);
            categoryDto.setChildren(this.getPidDtoList((IcsDocnavTreeDto)icsDocNavTreeDto));
            return categoryDto;
        }).collect(Collectors.toList());
    }

    private List<IcsPortalPidDto> getPidDtoList(IcsDocnavTreeDto icsDocnavTreeDto) {
        List pidDoList = icsDocnavTreeDto.getIcsPidSet().stream().filter(item -> "doc".equals(item.getType())).map(IcsDocnavTreeDto::getIcsPidDo).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pidDoList)) {
            return new ArrayList<IcsPortalPidDto>();
        }
        return pidDoList.stream().map(pidDo -> {
            IcsPortalPidDto portalPidDto = new IcsPortalPidDto();
            portalPidDto.setPidDocId(pidDo.getDocId());
            portalPidDto.setPidId(pidDo.getPidId());
            portalPidDto.setName(pidDo.getPidName());
            portalPidDto.setPrintSaveType(PRINT_SAVE_PORTAL_TYPE);
            return portalPidDto;
        }).collect(Collectors.toList());
    }

    private boolean filterCatalog(IcsDocnavTreeDto icsDocnavTreeDto, Map<String, Object> filterMap, List<IcsDocnavTreeDto> resultList, CatalogPageInfo pageInfo) {
        if (!StringUtils.equals((CharSequence)icsDocnavTreeDto.getType(), (CharSequence)"docCategory")) {
            return false;
        }
        Set<IcsDocnavTreeDto> icsDocnavTreeDtos = icsDocnavTreeDto.getIcsPidSet();
        List resultSet = icsDocnavTreeDtos.stream().filter(icsDocNavTreeDTO -> this.filterTreeDto(filterMap, (IcsDocnavTreeDto)icsDocNavTreeDTO)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(resultSet)) {
            return false;
        }
        pageInfo.addTotalCatalogNum(1);
        pageInfo.addTotalPidsNum(resultSet.size());
        if (pageInfo.getTotalCatalogNum() > pageInfo.getStart() && pageInfo.getTotalCatalogNum() <= pageInfo.getEnd()) {
            IcsDocnavTreeDto newIcsDocnavTreeDto = new IcsDocnavTreeDto();
            newIcsDocnavTreeDto.setName(icsDocnavTreeDto.getName());
            newIcsDocnavTreeDto.setType(icsDocnavTreeDto.getType());
            newIcsDocnavTreeDto.setNavItemPath(icsDocnavTreeDto.getNavItemPath());
            for (IcsDocnavTreeDto item : resultSet) {
                newIcsDocnavTreeDto.addIcsPid(item);
            }
            resultList.add(newIcsDocnavTreeDto);
        }
        return true;
    }

    private boolean filterTreeDto(Map<String, Object> filterMap, IcsDocnavTreeDto icsDocNavTreeDto) {
        Map tagsMap;
        if (MapUtils.isEmpty(filterMap)) {
            return true;
        }
        IcsPidDo icsPidDto = icsDocNavTreeDto.getIcsPidDo();
        String tagsJson = icsPidDto.getTagsJson();
        Map map = tagsMap = JsonUtils.isValid((String)tagsJson) ? JsonUtils.stringToMap((String)tagsJson) : new HashMap();
        if (MapUtils.isEmpty((Map)tagsMap)) {
            return false;
        }
        for (Map.Entry<String, Object> it : filterMap.entrySet()) {
            Object mapVal;
            List values = new ArrayList();
            if (!tagsMap.containsKey(it.getKey())) {
                return false;
            }
            if (tagsMap.get(it.getKey()) instanceof List && (mapVal = tagsMap.get(it.getKey())) instanceof List) {
                values = (List)new ObjectMapper().convertValue(mapVal, LIST_STRING_REFERENCE);
            }
            if (!CollectionUtils.isEmpty(values) && values.contains(it.getValue())) continue;
            return false;
        }
        return true;
    }

    private String getPidListHtml(String docId, String tabId, String qms, List<IcsDocnavTreeDto> icsDocnavTreeDtos) {
        if (CollectionUtils.isEmpty(icsDocnavTreeDtos)) {
            return "";
        }
        int showMaxNum = 10;
        StringBuilder allStringBuilder = new StringBuilder(1000);
        for (IcsDocnavTreeDto icsDocnavTreeDto : icsDocnavTreeDtos) {
            Set<IcsDocnavTreeDto> resultSet = icsDocnavTreeDto.getIcsPidSet();
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("<li class='catalog-item'>");
            stringBuilder.append(String.format(Locale.ENGLISH, "<div class='catalog-info'>\t\t<h3 class='catalog-info-h3'>\t\t\t<span class='catalog-info-title' title='%s'>%s</span>\t\t\t<span class='pid-list-count'>(%d)</span>\t\t</h3>\t</div>", HWEncoder.encodeForHTMLAttribute((String)icsDocnavTreeDto.getName()), HWEncoder.encodeForHTML((String)icsDocnavTreeDto.getName()), resultSet.size()));
            stringBuilder.append("<div class='pid-list'>");
            int count = 0;
            for (IcsDocnavTreeDto item : resultSet) {
                if (!"doc".equals(item.getType())) continue;
                IcsPidDo icsPidDo = item.getIcsPidDo();
                String currentDocid = icsPidDo.getDocId();
                String itemPidId = icsPidDo.getPidId();
                String itemPath = this.getPath(tabId, icsDocnavTreeDto.getNavItemPath());
                String viewUrl = this.getViewUrl(docId, currentDocid, itemPidId, itemPath, qms);
                String pidClass = this.pidItemClass;
                if (count++ >= showMaxNum) {
                    pidClass = this.pidItemHideClass;
                }
                String issueDate = ((String)StringUtils.defaultIfBlank((CharSequence)icsPidDo.getIssueDate(), (CharSequence)"")).split(" ")[0];
                stringBuilder.append(String.format(Locale.ENGLISH, "<div class='%s'>\t\t\t<span class='icon'></span>\t\t\t<h3>\t\t\t\t<a href='%s' title='%s' target='_blank' rel='noopener noreferrer'>%s</a>\t\t\t\t<div class='pid-item-issuedate'>\t\t\t\t\t<span class='issuedate-icon'></span>\t\t\t\t\t<span class='issuedate-text'>%s</span>\t\t\t\t</div>\t\t\t</h3>\t\t</div>", pidClass, viewUrl, HWEncoder.encodeForHTMLAttribute((String)icsPidDo.getPidName()), StringUtils.defaultIfBlank((CharSequence)HWEncoder.encodeForHTML((String)icsPidDo.getPidName()), (CharSequence)this.pidNameIsBlank), HWEncoder.encodeForHTML((String)issueDate)));
            }
            stringBuilder.append("</div>");
            if (count > showMaxNum) {
                stringBuilder.append(IcsPortalConstants.ATALOG_TEMPLATE_PIDLIST_MORE);
            }
            stringBuilder.append("</li>");
            allStringBuilder.append((CharSequence)stringBuilder);
        }
        return allStringBuilder.toString();
    }

    private String getViewUrl(String docId, String currentDocid, String itemPidId, String itemPath, String qms) {
        String viewUrl = StringUtils.equals((CharSequence)docId, (CharSequence)currentDocid) ? String.format(Locale.ENGLISH, IcsPortalConstants.PID_VIEW_URL_TEMPLATE, currentDocid, itemPidId, itemPath, qms) : String.format(Locale.ENGLISH, IcsPortalConstants.PID_VIEW_URL_TEMPLATE_REDOCID, docId, currentDocid, itemPidId, itemPath, qms);
        return viewUrl;
    }

    private String getPath(String tabId, String navItemPath) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tabId, navItemPath})) {
            return "";
        }
        return String.format(Locale.ENGLISH, "&path=%s-%s", tabId, navItemPath);
    }

    private String getQmsParam(String docId, String tabId, Map<String, Object> mapFilter) {
        if (MapUtils.isEmpty(mapFilter)) {
            return "";
        }
        IcsDocnavDo icsDocnavDo = IcsDocnavBusinessServiceHandler.getInstance().getbyDocNavId(docId, tabId);
        if (icsDocnavDo == null) {
            return "";
        }
        String filterJson = icsDocnavDo.getFilterJson();
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            return "";
        }
        JSONArray jsonArray = JSON.parseArray((String)filterJson);
        if (jsonArray == null) {
            return "";
        }
        int size = jsonArray.size();
        HashMap<String, String> filterStringMap = new HashMap<String, String>();
        for (int index = 0; index < size; ++index) {
            JSONObject jsonObject = jsonArray.getJSONObject(index);
            String metanameId = jsonObject.getString("metanameid");
            if (!mapFilter.containsKey(metanameId)) continue;
            StringBuilder stringBuffer = new StringBuilder(100);
            String topicFilter = jsonObject.getString("topicfilter");
            String nometanamePolicy = jsonObject.getString("nometanamepolicy");
            stringBuffer.append(metanameId).append(":").append(mapFilter.get(metanameId)).append(":").append(StringUtils.isBlank((CharSequence)topicFilter) ? "false" : topicFilter).append(":").append(StringUtils.isBlank((CharSequence)nometanamePolicy) ? "disappear" : nometanamePolicy);
            filterStringMap.put(metanameId, stringBuffer.toString());
        }
        ArrayList qmsLst = new ArrayList();
        if (!filterStringMap.isEmpty()) {
            mapFilter.forEach((key, value) -> qmsLst.add(filterStringMap.get(key)));
        }
        return "&qms=" + StringUtils.join(qmsLst, (String)",");
    }

    private static class IcsPortalBusinessHandlerHolder {
        private static final IcsPortalBusinessHandler INSTANCE = new IcsPortalBusinessHandler();

        private IcsPortalBusinessHandlerHolder() {
        }
    }
}

