/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.ics.topic.service.impl;

import com.huawei.support.icslite.business.docnav.dto.IcsDocnavDto;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavPathDto;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavTreeDto;
import com.huawei.support.icslite.business.docnav.serviceimpl.IcsDocnavBusinessServiceHandler;
import com.huawei.support.icslite.business.ics.topic.service.IcsTopicBusiness;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsTopicBusinessHandler
implements IcsTopicBusiness {
    private static final int DOC_TAB_MAX_NUM = 6;
    private static final String UNDER_LINE = "_";

    private IcsTopicBusinessHandler() {
    }

    public static IcsTopicBusinessHandler getInstance() {
        return IcsTopicBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public List<IcsDocnavTreeDto> getNaviItems(String docId, String tabId, String navitemPath) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tabId, navitemPath})) {
            return Collections.emptyList();
        }
        return IcsDocnavBusinessServiceHandler.getInstance().getNaviPid(docId, tabId, navitemPath);
    }

    @Override
    public List<IcsDocnavPathDto> getParentsNaviItems(String docId, String tabId, String navitemPath) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tabId, navitemPath})) {
            return Collections.emptyList();
        }
        return IcsDocnavBusinessServiceHandler.getInstance().getParentsNavi(docId, tabId, navitemPath);
    }

    @Override
    public List<IcsDocnavPathDto> getBrotherNaviItems(String docId, String tabId, String navitemPath) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tabId, navitemPath})) {
            return Collections.emptyList();
        }
        return IcsDocnavBusinessServiceHandler.getInstance().getBrotherNavi(docId, tabId, navitemPath);
    }

    @Override
    public Map<String, List<IcsDocnavTreeDto>> getAllPid(String docId) {
        LinkedHashMap<String, List<IcsDocnavTreeDto>> docNavPidMap = new LinkedHashMap<String, List<IcsDocnavTreeDto>>();
        List<IcsDocnavDto> docNavDtoList = IcsDocnavBusinessServiceHandler.getInstance().getDocnavDoList(docId);
        if (CollectionUtils.isEmpty(docNavDtoList)) {
            return docNavPidMap;
        }
        docNavDtoList = docNavDtoList.size() > 6 ? docNavDtoList.subList(0, 6) : docNavDtoList;
        for (IcsDocnavDto docNavDto : docNavDtoList) {
            String docNavId = docNavDto.getDocnavId();
            List<IcsDocnavTreeDto> naviPid = IcsDocnavBusinessServiceHandler.getInstance().getNaviPid(docId, docNavId, "");
            docNavPidMap.put(docNavId + UNDER_LINE + docNavDto.getDocnavName(), naviPid);
        }
        return docNavPidMap;
    }

    private static class IcsTopicBusinessHandlerHolder {
        private static final IcsTopicBusinessHandler INSTANCE = new IcsTopicBusinessHandler();

        private IcsTopicBusinessHandlerHolder() {
        }
    }
}

