/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.index.common;

import com.google.common.eventbus.AsyncEventBus;
import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.commonsearch.index.entity.IndexConfigDo;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.service.SearchManagerBase;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.business.index.common.IndexProgressHelper;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;

public abstract class AbstractIndexService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(AbstractIndexService.class);
    private static final Object OBJECT_LOCK = new Object();
    private static final long INCREATE_MILLTIME = 3000L;
    protected ThreadPoolExecutor indexTaskExecutor = ThreadPoolFactory.getThreadPool((String)"indexTaskExecutor", (int)1, (int)600, (int)1, (int)300);
    protected AsyncEventBus eventBus = EventBusUtils.INSTANCE.getEventBus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasIdleThreads() {
        Object object = OBJECT_LOCK;
        synchronized (object) {
            return this.indexTaskExecutor.getActiveCount() == this.indexTaskExecutor.getMaximumPoolSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Runnable runnable) {
        Object object = OBJECT_LOCK;
        synchronized (object) {
            this.indexTaskExecutor.execute(runnable);
        }
    }

    protected void deleteLocalIndexOfNoUse(File subFile, String[] searchStrings) {
        Object[] pathList = subFile.listFiles();
        if (ArrayUtils.isEmpty((Object[])pathList) || ArrayUtils.isEmpty((Object[])searchStrings)) {
            return;
        }
        String indexRootPath = IcsLiteStorageInstance.getInstance().getIndexPath();
        for (Object pathFile : pathList) {
            String fileName = ((File)pathFile).getName();
            if (!StringUtils.startsWithAny((CharSequence)fileName, (CharSequence[])searchStrings)) continue;
            IcsFileUtils.delFileOrDir((File)pathFile, (String)indexRootPath);
        }
    }

    protected boolean isNeedUpdate(SearchManagerBase searchManagerBase, String indexDir, String libLang) {
        Document document = this.getIndexBaseInfo(searchManagerBase, indexDir, libLang);
        if (document == null) {
            return true;
        }
        String indexLang = document.get("indexLang");
        String indexVersion = document.get("version");
        return !StringUtils.equals((CharSequence)indexLang, (CharSequence)ConfigServiceHandler.getInstance().get("system.lang")) || !StringUtils.equals((CharSequence)indexVersion, (CharSequence)this.getIndexVersion(indexLang));
    }

    protected boolean isNeedUpdateBySubVersion(SearchManagerBase searchManagerBase, String indexDir, String libLang) {
        Document document = this.getIndexBaseInfo(searchManagerBase, indexDir, libLang);
        if (document == null) {
            return true;
        }
        String indexLang = document.get("indexLang");
        String subVersion = document.get("subversion");
        return StringUtils.compare((String)subVersion, (String)this.getIndexSubVersion(indexLang)) < 0;
    }

    private String getIndexVersion(String lang) {
        return StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)"zh") ? "4.0" : "4.0";
    }

    private String getIndexSubVersion(String lang) {
        return StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)"zh") ? "3.1" : "2.1";
    }

    private Document getIndexBaseInfo(SearchManagerBase searchManagerBase, String indexDir, String libLang) {
        Document document = null;
        try {
            document = IndexProgressHelper.queryIndexInfo(searchManagerBase, indexDir, ConfigServiceHandler.getInstance().get("system.lang"), "2022", "indexinfo_id");
            if (document == null) {
                document = IndexProgressHelper.queryIndexInfo(searchManagerBase, indexDir, libLang, "2022", "indexinfo_id");
            }
        }
        catch (SearchException | IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "GetIndexBaseInfo, Query index info error.", e);
        }
        return document;
    }

    protected boolean isLastestIndex(String indexCreateTime, long libLoadTime) {
        Date indexCreateDate = this.parseDatetime(indexCreateTime);
        if (indexCreateDate == null) {
            return true;
        }
        Date libLoadDate = new Date(libLoadTime);
        return indexCreateDate.compareTo(libLoadDate) >= 0;
    }

    protected String getIndexCreateTime(long libLoadTime) {
        long createTime = System.currentTimeMillis();
        createTime = createTime <= libLoadTime ? libLoadTime + 3000L : createTime + 3000L;
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(createTime);
    }

    protected IndexConfigDo getIndexConfigDo() {
        ConfigServiceHandler configService = ConfigServiceHandler.getInstance();
        String experienceMode = configService.get("system.experience.mode");
        String cpuThreshold = configService.get("index.process.cpu.threshold");
        if (StringUtils.equalsAny((CharSequence)experienceMode, (CharSequence[])new CharSequence[]{"0", "1"})) {
            cpuThreshold = configService.get("index.process.cpu.threshold.default");
        }
        return new IndexConfigDo(experienceMode, Integer.parseInt(configService.get("index.process.cpu.sleep.time")), Integer.parseInt(cpuThreshold));
    }

    private Date parseDatetime(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateStr);
        }
        catch (ParseException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "parseDatetime error.", (Throwable)e);
        }
        return date;
    }
}

