/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.index.common;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.commonsearch.searchdb.constant.HdxIndexConstants;
import com.huawei.support.icslite.business.index.constant.IcsIndexConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class IndexDirUtils {
    private IndexDirUtils() {
    }

    public static String getIcsIndexRootDir(String docId) {
        return IcsLiteStorageInstance.getInstance().getIndexPath() + String.format(Locale.ENGLISH, IcsIndexConstants.ICS_INDEXDIR_ROOT_FORMAT, docId);
    }

    public static String getIcsIndexLibDir(String docId) {
        return IcsLiteStorageInstance.getInstance().getIndexPath() + String.format(Locale.ENGLISH, IcsIndexConstants.ICS_INDEXLIB_DIR_FORMAT, docId);
    }

    public static String getIcsIndexLibRelativeDir(String docId) {
        return String.format(Locale.ENGLISH, IcsIndexConstants.ICS_INDEXLIB_DIR_FORMAT, docId);
    }

    public static String getIcsIndexAbsoluteDir(String docId, String appVersion) {
        return IcsLiteStorageInstance.getInstance().getIndexPath() + IndexDirUtils.getIcsIndexRelativeDir(docId, appVersion);
    }

    public static String getIcsIndexRelativeDir(String docId, String appVersion) {
        String newAppVersion = StringUtils.isBlank((CharSequence)appVersion) ? appVersion : "_" + appVersion;
        return String.format(Locale.ENGLISH, IcsIndexConstants.ICS_TARGET_INDEXDIR_FORMAT, docId, newAppVersion, docId);
    }

    public static String getHdxIndexRelativeDir(String docId, String appVersion) {
        String newAppVersion = StringUtils.isBlank((CharSequence)appVersion) ? appVersion : "_" + appVersion;
        return String.format(Locale.ENGLISH, HdxIndexConstants.HDX_INDEXDIR_FORMAT, docId, newAppVersion, docId);
    }

    public static String getIndexDirExt() {
        return IcsCommonServiceHandler.getInstance().getAppVersion() + "_" + System.currentTimeMillis();
    }
}

