/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.index.common;

import com.huawei.support.icscbb.commonsearch.lucene.search.dto.ParamBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchField;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.query.QueryBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.service.SearchManagerBase;
import com.huawei.support.icscbb.commonsearch.search.entity.LibSearchParam;
import com.huawei.support.icscbb.commonsearch.search.query.LibQuery;
import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.business.libmanage.service.LibManageService;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.customsort.service.impl.CustomSortServiceHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;

public abstract class IndexProgressHelper {
    protected static final String INDEX_PROGRESS_FINISH = "100";
    protected static final List<String> EXCLUDE_JAR_LIST = IndexProgressHelper.getExcludeJarList();
    protected static final int INDEX_PROGRESS_QUERY_SLEEP = 1000;
    protected static final float ICSINDEX_BOOST = 1.0f;
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IndexProgressHelper.class);
    private static final int MAX_RETRY_TIME = 1800000;
    private static final String MAX_INDEX_PROGRESS_UPDATE_TIME = "30";
    private static final long MILLS_OF_ONE_MINUTES = 60000L;
    private static final String INDEX_PROCESS_TIMEOUT = "260";
    protected String lastIndexProgress;
    protected long lastIndexModifyTime;
    private Future<?> future;
    private volatile boolean isInterrupt = false;

    private static List<String> getExcludeJarList() {
        return Collections.unmodifiableList(Arrays.asList("common-adapter-encryption", "icscbb-cms-verify", "bcpg-jdk15on", "bcpkix-jdk15on", "icslite-db", "hibernate-validator", "spring", "derby"));
    }

    public static Document queryIndexInfo(SearchManagerBase searchManagerBase, String indexDir, String lang, String searchText, String searchField) throws IOException, SearchException {
        LibSearchParam searchParam = new LibSearchParam();
        searchParam.setLang(lang);
        searchParam.setSearchText(searchText);
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        fields.add(new SearchField(searchField, 1.0f, false));
        searchParam.setSearchFields(fields);
        ArrayList<String> indexDirs = new ArrayList<String>();
        indexDirs.add(indexDir);
        List documents = searchManagerBase.searchDocuments((ParamBase)searchParam, (QueryBase)new LibQuery(), indexDirs);
        if (CollectionUtils.isEmpty((Collection)documents)) {
            return null;
        }
        return (Document)documents.get(0);
    }

    protected void asyncUpdateIndexProgress(SearchManagerBase searchManagerBase, String indexDir, String lang) {
        ThreadPoolExecutor commonThreadPool = ThreadPoolFactory.getThreadPool((String)"common", (int)2, (int)300, (int)10, (int)100);
        this.future = commonThreadPool.submit(() -> {
            try {
                this.threadProc(searchManagerBase, indexDir, lang);
            }
            catch (InterruptedException e) {
                CodeCCUtils.INSTANCE.warnLog(LOGGER, "[index]TimeUnit happen interrupt. Index already finish.");
            }
        });
    }

    private void threadProc(SearchManagerBase searchManagerBase, String indexDir, String lang) throws InterruptedException {
        int retryTime = 0;
        while (retryTime <= 1800000 && !this.isInterrupt()) {
            TimeUnit.MILLISECONDS.sleep(1000L);
            try {
                if (!this.updateIndexProgress(searchManagerBase, indexDir, lang)) continue;
                break;
            }
            catch (SearchException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]ThreadProc error.", (Throwable)e);
                retryTime += 1000;
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.debugLog(LOGGER, "[index]ThreadProc, index maybe waiting.");
                retryTime += 1000;
            }
        }
    }

    protected boolean updateIndexProgress(SearchManagerBase searchManagerBase, String indexDir, String lang) throws SearchException, IOException {
        Document document = IndexProgressHelper.queryIndexInfo(searchManagerBase, indexDir, lang, "2022", "indexinfo_id");
        if (document == null) {
            return true;
        }
        Object[] progressValues = document.getValues("progress");
        if (ArrayUtils.isEmpty((Object[])progressValues)) {
            return true;
        }
        Object rate = progressValues[0];
        this.checkProcessStatus((String)rate);
        this.updateProgress((String)StringUtils.defaultIfBlank((CharSequence)rate, (CharSequence)"0"));
        return StringUtils.equals((CharSequence)rate, (CharSequence)INDEX_PROGRESS_FINISH);
    }

    protected void pushIndexProgressMessage(String docId, String progress) {
        LibManageService libManageService = (LibManageService)SpringContextUtil.getBean((String)"libManageService");
        libManageService.setIndexProgress(docId, progress);
        CustomSortServiceHandler.getInstance().updateIndexProgress(docId, progress + "%");
    }

    public String getTaskStatusByTaskType(String taskType) {
        return StringUtils.equals((CharSequence)taskType, (CharSequence)"create") ? "10001" : "10004";
    }

    public List<String> getProcessJvmOpts() {
        String jvmXmx;
        ArrayList<String> jvmOpts = new ArrayList<String>();
        String jvmXms = ConfigServiceHandler.getInstance().get("index.process.env.jvm.xms");
        if (StringUtils.isNotBlank((CharSequence)jvmXms)) {
            jvmOpts.add(jvmXms);
        }
        if (StringUtils.isNotBlank((CharSequence)(jvmXmx = ConfigServiceHandler.getInstance().get("index.process.env.jvm.xmx")))) {
            jvmOpts.add(jvmXmx);
        }
        return jvmOpts;
    }

    protected abstract void updateProgress(String var1);

    protected abstract void exitProcess();

    public void cancelTask() {
        this.isInterrupt = true;
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public boolean isInterrupt() {
        return this.isInterrupt;
    }

    private void checkProcessStatus(String curIndexProgress) {
        if (StringUtils.equals((CharSequence)curIndexProgress, (CharSequence)this.lastIndexProgress)) {
            long maxUpdateTime;
            long duration = System.currentTimeMillis() - this.lastIndexModifyTime;
            if (duration > (maxUpdateTime = Long.parseLong(ConfigServiceHandler.getInstance().getOrSetDefault("index.process.update.timeout", MAX_INDEX_PROGRESS_UPDATE_TIME)) * 60000L)) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Index progress update more than 5 minutes, exit process.");
                this.exitProcess();
            }
            return;
        }
        this.lastIndexProgress = curIndexProgress;
        this.lastIndexModifyTime = System.currentTimeMillis();
    }

    protected long getProcessTimeOut() {
        return Long.parseLong(ConfigServiceHandler.getInstance().getOrSetDefault("index.process.timeout", INDEX_PROCESS_TIMEOUT));
    }
}

