/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.index.dao;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.commonsearch.index.entity.HdxLibDo;
import com.huawei.support.icscbb.commonsearch.lucene.search.service.SearchManagerBase;
import com.huawei.support.icscbb.commonsearch.searchdb.dto.HdxIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.service.impl.HdxIndexServiceHandler;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icslite.business.index.common.AbstractIndexService;
import com.huawei.support.icslite.business.index.common.IndexDirUtils;
import com.huawei.support.icslite.business.index.dto.mapper.HdxIndexDoConverter;
import com.huawei.support.icslite.business.index.task.HdxIndexFileTask;
import com.huawei.support.icslite.business.search.dao.HdxSearchBusinessDaoHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class HdxIndexBusinessDaoHandler
extends AbstractIndexService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxIndexBusinessDaoHandler.class);
    private static final int PAGE_SIZE = 1000;
    private final IcsLiteStorageAdapter icsLiteStorageAdapter = IcsLiteStorageInstance.getInstance();

    private HdxIndexBusinessDaoHandler() {
    }

    public static HdxIndexBusinessDaoHandler getInstance() {
        return HdxIndexBusinessDaoHandlerHolder.INSTANCE;
    }

    public void create(HdxIndexDo hdxIndexDo, Map<String, HdxLibDo> baseLibInfo, String taskType) {
        CodeCCUtils.INSTANCE.debugLog(LOGGER, "[hdx-index]create index, docId:" + hdxIndexDo.getDocId());
        String indexRootDir = this.icsLiteStorageAdapter.getIndexPath();
        if (StringUtils.isBlank((CharSequence)indexRootDir)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "index root dir is null, from ics lite storage adapter");
            return;
        }
        String absIndexDir = indexRootDir + hdxIndexDo.getIndexDir();
        if (StringUtils.equals((CharSequence)taskType, (CharSequence)"recreate")) {
            absIndexDir = indexRootDir + IndexDirUtils.getHdxIndexRelativeDir(hdxIndexDo.getDocId(), IndexDirUtils.getIndexDirExt());
        }
        HdxLibDo hdxLibInfo = HdxIndexDoConverter.INSTANCE.domain2dto(hdxIndexDo);
        hdxLibInfo.setIndexLang(ConfigServiceHandler.getInstance().get("system.lang"));
        hdxLibInfo.setIndexDir(absIndexDir);
        hdxLibInfo.setHdxLibInfoMap(baseLibInfo);
        hdxLibInfo.setTaskType(taskType);
        hdxLibInfo.setIndexConfigDo(this.getIndexConfigDo());
        HdxIndexFileTask hdxIndexFileTask = new HdxIndexFileTask().setHdxIndexTaskInfo(hdxLibInfo).setEventBus(this.eventBus).setJavaHome(this.icsLiteStorageAdapter.getJavaHomePath());
        this.eventBus.register((Object)hdxIndexFileTask);
        this.execute(hdxIndexFileTask);
    }

    public boolean addIndex(String docId) {
        HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
        if (hdxContentDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]doc is not exist.docid:" + docId);
            return false;
        }
        HdxIndexDo selectIndex = HdxIndexServiceHandler.getInstance().selectIndex(docId);
        if (selectIndex != null) {
            this.interrupt(docId);
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]index already exist.docId:{0}", new Object[]{docId});
            return true;
        }
        HdxIndexDo hdxIndexDo = HdxIndexDoConverter.INSTANCE.domain2dto(hdxContentDo);
        hdxIndexDo.setIndexDir(IndexDirUtils.getHdxIndexRelativeDir(docId, ""));
        hdxIndexDo.setCreateTime(this.getIndexCreateTime(hdxContentDo.getLoadTime()));
        hdxIndexDo.setState("10003");
        hdxIndexDo.setRate("0");
        HdxIndexServiceHandler.getInstance().addIndex(hdxIndexDo);
        return true;
    }

    public int deleteIndex(String docId) {
        String indexRootDir;
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]delete index, docid:" + docId);
        HdxIndexDo hdxIndexDo = HdxIndexServiceHandler.getInstance().selectIndex(docId);
        if (hdxIndexDo == null) {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "[hdx-index]index not exist, docId:" + docId);
            return 0;
        }
        if (StringUtils.equals((CharSequence)hdxIndexDo.getState(), (CharSequence)"10001")) {
            this.interrupt(docId);
        }
        if (StringUtils.isBlank((CharSequence)(indexRootDir = this.icsLiteStorageAdapter.getIndexPath()))) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "index root dir is null, from ics lite storage adapter");
        } else {
            this.deleteLocalIndex(hdxIndexDo, indexRootDir);
        }
        return HdxIndexServiceHandler.getInstance().deleteIndex(docId);
    }

    private void deleteLocalIndex(HdxIndexDo hdxIndexDo, String indexRootDir) {
        File file;
        if (!HdxSearchBusinessDaoHandler.INSTANCE.deleteIndexReaderCache(hdxIndexDo.getDocId())) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Delete search indexReader cache fail.");
        }
        if ((file = FileUtils.getFile((String[])new String[]{indexRootDir + hdxIndexDo.getIndexDir()})).exists() && !IcsFileUtils.delFileOrDir((File)file, (String)indexRootDir)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]delete index dir exist fail, maybe affect index recreate. docId:{0}", new Object[]{hdxIndexDo.getDocId()});
        }
    }

    private void interrupt(String docId) {
        this.eventBus.post((Object)docId);
    }

    public void createIndexTb() {
        HdxIndexServiceHandler.getInstance().createIndexTb();
    }

    public HdxIndexDo selectIndex(String docId) {
        return HdxIndexServiceHandler.getInstance().selectIndex(docId);
    }

    public Set<String> verify(Set<String> docIds) {
        String indexRootDir;
        if (CollectionUtils.isEmpty(docIds)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "not exist loaded lib.");
            return SetUtils.emptySet();
        }
        List existDocIds = HdxIndexServiceHandler.getInstance().selectDocIds(new ArrayList<String>(docIds));
        if (CollectionUtils.isNotEmpty((Collection)existDocIds)) {
            existDocIds.stream().filter(docId -> !docIds.contains(docId)).forEach(this::deleteIndex);
        }
        if (StringUtils.isBlank((CharSequence)(indexRootDir = this.icsLiteStorageAdapter.getIndexPath() + File.separator + "hdx"))) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "index root dir is null, from ics lite storage adapter");
            return SetUtils.emptySet();
        }
        File file = FileUtils.getFile((String[])new String[]{indexRootDir});
        File[] files = file.listFiles();
        if (!file.exists() || !file.isDirectory() || files == null) {
            return SetUtils.emptySet();
        }
        HashSet<String> tempLoadedDocIds = new HashSet<String>(docIds);
        for (File subFile : files) {
            String fileName = subFile.getName();
            if (!StringUtils.startsWithIgnoreCase((CharSequence)fileName, (CharSequence)"hdx")) continue;
            if (!docIds.contains(fileName)) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]clear dirty data docid:" + fileName);
                this.deleteLocalIndexOfNoUse(subFile, new String[]{"index", "searchFilter.html"});
                continue;
            }
            tempLoadedDocIds.remove(fileName);
        }
        return tempLoadedDocIds;
    }

    public Map<String, String> selectIndexProgress() {
        int count = HdxIndexServiceHandler.getInstance().queryTotalNums();
        HashMap<String, String> indexProgressMap = new HashMap<String, String>();
        if (count == 0) {
            return indexProgressMap;
        }
        if (count <= 1000) {
            List hdxIndexDos = HdxIndexServiceHandler.getInstance().selectByPage(0, count);
            this.getIndexProgress(hdxIndexDos, indexProgressMap);
        } else {
            int start = 0;
            int len = 1000;
            while (start <= count) {
                List hdxIndexDos = HdxIndexServiceHandler.getInstance().selectByPage(start, len);
                this.getIndexProgress(hdxIndexDos, indexProgressMap);
                start = len;
                len = start + 1000 >= count ? count : start + 1000;
            }
        }
        return indexProgressMap;
    }

    private void getIndexProgress(List<HdxIndexDo> hdxIndexDos, Map<String, String> indexProgressMap) {
        if (CollectionUtils.isEmpty(hdxIndexDos)) {
            return;
        }
        hdxIndexDos.forEach(hdxIndexDo -> {
            String processRate = hdxIndexDo.getRate();
            if (StringUtils.isBlank((CharSequence)processRate) && StringUtils.equalsAny((CharSequence)hdxIndexDo.getState(), (CharSequence[])new CharSequence[]{"10000", "10004"})) {
                processRate = "100";
            }
            indexProgressMap.put(hdxIndexDo.getDocId(), processRate);
        });
    }

    @Override
    public boolean isNeedUpdate(SearchManagerBase searchManagerBase, String indexDir, String libLang) {
        return super.isNeedUpdate(searchManagerBase, indexDir, libLang);
    }

    @Override
    public boolean isNeedUpdateBySubVersion(SearchManagerBase searchManagerBase, String indexDir, String libLang) {
        return super.isNeedUpdateBySubVersion(searchManagerBase, indexDir, libLang);
    }

    @Override
    public boolean isLastestIndex(String indexCreateTime, long libLoadTime) {
        return super.isLastestIndex(indexCreateTime, libLoadTime);
    }

    @Override
    public boolean hasIdleThreads() {
        return super.hasIdleThreads();
    }

    private static class HdxIndexBusinessDaoHandlerHolder {
        private static final HdxIndexBusinessDaoHandler INSTANCE = new HdxIndexBusinessDaoHandler();

        private HdxIndexBusinessDaoHandlerHolder() {
        }
    }
}

