/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.index.process.helper;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class ProcessHelper {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ProcessHelper.class);

    private ProcessHelper() {
    }

    public static void writeArg(Process process, String content) {
        try (OutputStream outputStream = process.getOutputStream();
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            bw.write(content);
            bw.flush();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Process write error", (Throwable)e);
        }
    }

    public static String readParentProcessArgs() {
        StringBuilder strBuffer = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(System.in, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line = reader.readLine();
            while (StringUtils.isNotBlank((CharSequence)line)) {
                strBuffer.append(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get process args error.", (Throwable)e);
        }
        return strBuffer.toString();
    }
}

