/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.index.serviceimpl;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.commonsearch.index.entity.HdxLibDo;
import com.huawei.support.icscbb.commonsearch.lucene.search.service.SearchManagerBase;
import com.huawei.support.icscbb.commonsearch.searchdb.dto.HdxIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.service.impl.HdxIndexServiceHandler;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.index.dao.HdxIndexBusinessDaoHandler;
import com.huawei.support.icslite.business.index.dto.mapper.HdxLibInfoConverter;
import com.huawei.support.icslite.business.index.service.HdxIndexBusiness;
import com.huawei.support.icslite.business.index.task.manager.IndexTask;
import com.huawei.support.icslite.business.index.task.manager.IndexTaskManager;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class HdxIndexBusinessHandler
implements HdxIndexBusiness {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxIndexBusinessHandler.class);
    private static final Object LOCK_OBJECT = new Object();
    private final IcsLiteStorageAdapter icsLiteStorageAdapter = IcsLiteStorageInstance.getInstance();

    private HdxIndexBusinessHandler() {
    }

    public static HdxIndexBusinessHandler getInstance() {
        return HdxIndexBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public boolean create(String docId) {
        return this.addTask(docId);
    }

    @Override
    public void recreate(List<String> docIds) {
        if (CollectionUtils.isEmpty(docIds)) {
            return;
        }
        docIds.forEach(docId -> this.addTaskToSet((String)docId, "recreate"));
    }

    @Override
    public void createIndexTb() {
        HdxIndexBusinessDaoHandler.getInstance().createIndexTb();
    }

    private boolean addTask(String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            return false;
        }
        this.addTaskToSet(docId, "create");
        return true;
    }

    @Override
    public boolean startCreateIndex(String docId, String taskType) {
        HdxIndexDo hdxIndexDo;
        HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
        if (hdxContentDo == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Doc is not exist, will delete index task, docId:{0}", new Object[]{docId});
            HdxIndexServiceHandler.getInstance().deleteIndex(docId);
            return false;
        }
        if (StringUtils.equals((CharSequence)taskType, (CharSequence)"recreate") && StringUtils.isBlank((CharSequence)IcsCommonServiceHandler.getInstance().getAppVersion())) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Not get app version, can't recreate index, docId:{0}", new Object[]{docId});
            return false;
        }
        HashMap<String, HdxLibDo> hdxDocDos = new HashMap<String, HdxLibDo>();
        if (StringUtils.equals((CharSequence)hdxContentDo.getLibType(), (CharSequence)"1")) {
            HdxContentDo baseContentDo = HdxContentPoolServiceHandler.getInstance().getBaseByMend(docId);
            hdxDocDos.put(baseContentDo.getLibId() + baseContentDo.getLibV(), HdxLibInfoConverter.INSTANCE.domain2dto(baseContentDo));
        }
        if ((hdxIndexDo = HdxIndexServiceHandler.getInstance().selectIndex(docId)) == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Index record is not exist. docId:" + docId);
            return false;
        }
        hdxIndexDo.setPath(hdxContentDo.getPath());
        hdxIndexDo.setLibName(hdxContentDo.getLibName());
        HdxIndexBusinessDaoHandler.getInstance().create(hdxIndexDo, hdxDocDos, taskType);
        return true;
    }

    @Override
    public Map<String, String> selectIndexProgress() {
        return HdxIndexBusinessDaoHandler.getInstance().selectIndexProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTaskToSet(String docId, String taskType) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]Add index task. docId[{0}]-taskType[{1}]", new Object[]{docId, taskType});
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "docid is null:" + docId);
            return;
        }
        Object object = LOCK_OBJECT;
        synchronized (object) {
            if (StringUtils.equals((CharSequence)taskType, (CharSequence)"create") && !HdxIndexBusinessDaoHandler.getInstance().addIndex(docId)) {
                return;
            }
        }
        IndexTask indexTask = new IndexTask(docId, 0, 0, "hdx", taskType);
        IndexTaskManager.getInstance().add(indexTask);
    }

    @Override
    public int delete(String docId) {
        IndexTaskManager.getInstance().remove(docId);
        return HdxIndexBusinessDaoHandler.getInstance().deleteIndex(docId);
    }

    public void scheduleCleanDirtyIndex() {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "scheduleCleanDirtyIndex.");
        Set loadDocIds = HdxContentPoolServiceHandler.getInstance().getAllDocId();
        HdxIndexBusinessDaoHandler.getInstance().verify(loadDocIds);
    }

    @Override
    public void verify() {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "start verify index of loaded lib.");
        Set loadDocIds = HdxContentPoolServiceHandler.getInstance().getAllDocId();
        if (StringUtils.equals((CharSequence)ConfigServiceHandler.getInstance().get("index.recreate.flag"), (CharSequence)"1")) {
            this.recreate(new ArrayList<String>(loadDocIds));
            ConfigServiceHandler.getInstance().set("index.recreate.flag", "0");
            return;
        }
        Set<String> docIdSet = HdxIndexBusinessDaoHandler.getInstance().verify(loadDocIds);
        if (CollectionUtils.isNotEmpty(docIdSet)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "not exist index,docids:" + String.join((CharSequence)", ", docIdSet));
        }
        this.recreateExceptionIndex(loadDocIds);
    }

    private void recreateExceptionIndex(Set<String> loadedDocIds) {
        HashSet<String> tempLoadedDocIds = new HashSet<String>(loadedDocIds);
        Iterator it = tempLoadedDocIds.iterator();
        while (it.hasNext()) {
            String docId = (String)it.next();
            HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
            if (hdxContentDo == null || !FileUtils.getFile((String[])new String[]{hdxContentDo.getPath()}).exists()) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index] File is not exist or not load, docId[{0}]", new Object[]{docId});
                it.remove();
                continue;
            }
            HdxIndexDo hdxIndexDo = HdxIndexBusinessDaoHandler.getInstance().selectIndex(docId);
            if (hdxIndexDo == null) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]doc already exist, but not find index. docId[{0}]", new Object[]{docId});
                this.addTaskToSet(docId, "create");
                it.remove();
                continue;
            }
            if (this.needReCreate(hdxIndexDo, hdxContentDo)) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]update index\uff0cdocId[{0}]-status[{1}].", new Object[]{docId, hdxIndexDo.getState()});
                this.addTaskToSet(docId, "recreate");
                it.remove();
                continue;
            }
            if (StringUtils.equals((CharSequence)hdxIndexDo.getState(), (CharSequence)"10000") && StringUtils.equals((CharSequence)hdxIndexDo.getRate(), (CharSequence)"100")) continue;
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]recreate exception index\uff0cdocId\uff1a{0}", new Object[]{docId});
            this.addTaskToSet(docId, "create");
            it.remove();
        }
    }

    private boolean needReCreate(HdxIndexDo hdxIndexDo, HdxContentDo hdxContentDo) {
        if (StringUtils.equals((CharSequence)hdxIndexDo.getState(), (CharSequence)"10004")) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)hdxIndexDo.getState(), (CharSequence)"10000")) {
            return false;
        }
        File file = FileUtils.getFile((String[])new String[]{this.icsLiteStorageAdapter.getIndexPath() + hdxIndexDo.getIndexDir()});
        if (!file.exists()) {
            return true;
        }
        return !HdxIndexBusinessDaoHandler.getInstance().isLastestIndex(hdxIndexDo.getCreateTime(), hdxContentDo.getLoadTime());
    }

    public void upgradeIndex(String hisOldAppVersion) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "HDX upgradeIndex start.");
        List loadDocIds = HdxIndexServiceHandler.getInstance().selectAllIndex();
        if (CollectionUtils.isEmpty((Collection)loadDocIds)) {
            return;
        }
        String indexRootPath = this.icsLiteStorageAdapter.getIndexPath();
        if (StringUtils.isBlank((CharSequence)indexRootPath)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Index root path not get.");
            return;
        }
        SearchManagerBase searchManagerBase = new SearchManagerBase();
        for (HdxIndexDo hdxIndexDo : loadDocIds) {
            if (!StringUtils.equals((CharSequence)hdxIndexDo.getState(), (CharSequence)"10000")) continue;
            String indexDir = indexRootPath + hdxIndexDo.getIndexDir();
            String docId = hdxIndexDo.getDocId();
            if (!HdxIndexBusinessDaoHandler.getInstance().isNeedUpdate(searchManagerBase, indexDir, hdxIndexDo.getLang())) continue;
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]Index lang or index version is different, need update index: {0}", new Object[]{docId});
            HdxIndexServiceHandler.getInstance().updateIndex(docId, "10004", "");
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "HDX upgradeIndex end.");
    }

    private static class HdxIndexBusinessHandlerHolder {
        private static final HdxIndexBusinessHandler INSTANCE = new HdxIndexBusinessHandler();

        private HdxIndexBusinessHandlerHolder() {
        }
    }
}

