/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.index.serviceimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsRelationDo;
import com.huawei.support.icscbb.commonsearch.index.service.IndexFacade;
import com.huawei.support.icscbb.commonsearch.lucene.index.dto.FieldInfoDto;
import com.huawei.support.icscbb.commonsearch.lucene.search.service.SearchManagerBase;
import com.huawei.support.icscbb.commonsearch.searchdb.dto.IcsIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.service.impl.IcsIndexServiceHandler;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.docnav.service.impl.IcsDocnavPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.service.impl.IcsVersionRelationPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavTreeDto;
import com.huawei.support.icslite.business.docnav.serviceimpl.IcsDocnavBusinessServiceHandler;
import com.huawei.support.icslite.business.index.common.AbstractIndexService;
import com.huawei.support.icslite.business.index.common.IndexDirUtils;
import com.huawei.support.icslite.business.index.common.UnzipHelper;
import com.huawei.support.icslite.business.index.service.IcsIndexBusiness;
import com.huawei.support.icslite.business.index.task.IcsIndexDoConverter;
import com.huawei.support.icslite.business.index.task.IcsIndexHdxFileTask;
import com.huawei.support.icslite.business.index.task.manager.IndexTask;
import com.huawei.support.icslite.business.index.task.manager.IndexTaskManager;
import com.huawei.support.icslite.business.index.thread.IcsIndexUnzipThread;
import com.huawei.support.icslite.business.search.serviceimpl.IcsSearchBusinessHandler;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsIndexBusinessHandler
extends AbstractIndexService
implements IcsIndexBusiness {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsIndexBusinessHandler.class);
    private static final int PAGE_SIZE = 200;
    private static final String ICS_RESOURCES_INDEX_PATH = "resources/index";
    private static final String ICS_INDEX_DIR_PREFIX = "index_";
    private static final Object LOCK_OBJECT = new Object();
    private final IcsLiteStorageAdapter icsLiteStorageAdapter = IcsLiteStorageInstance.getInstance();
    protected Map<String, String> indexSubDirIdMap = new HashMap<String, String>();

    private IcsIndexBusinessHandler() {
    }

    public static IcsIndexBusinessHandler getInstance() {
        return IcsIndexBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public void createIndexTb() {
        IcsIndexServiceHandler.getInstance().createIndexTb();
    }

    @Override
    public boolean create(String docId) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "createIcsIndex docid:" + docId);
        this.addTaskToList(docId, "create");
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchAddIndex(Collection<String> docIds) {
        if (CollectionUtils.isEmpty(docIds)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "batchAddIndex. docIds is null.");
            return;
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "batchAddIndex. docIds:" + JSON.toJSONString(docIds));
        Object object = LOCK_OBJECT;
        synchronized (object) {
            for (String docId : docIds) {
                this.addTaskToList(docId, "increment-create");
            }
        }
    }

    @Override
    public boolean createThreadPoolTask(String docId, String taskType) {
        IcsContentDo icsContentDto = IcsContentPoolServiceHandler.getInstance().get(docId);
        if (icsContentDto == null) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Not get Lib. will delete index task, docId:{0}.", new Object[]{docId});
            IcsIndexServiceHandler.getInstance().deleteIndex(docId);
            return true;
        }
        if (StringUtils.equals((CharSequence)taskType, (CharSequence)"recreate") && StringUtils.isBlank((CharSequence)IcsCommonServiceHandler.getInstance().getAppVersion())) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Not get app version, can't recreate index, docId:{0}", new Object[]{docId});
            return false;
        }
        List docNaviDtos = IcsDocnavPoolServiceHandler.getInstance().get(docId);
        HwIcsLibDo hwIcsLibDo = new HwIcsLibDo().setPids(this.getPidsFromDocNav(icsContentDto.getDocId(), docNaviDtos)).setTaskType(taskType).setFilterMetaIds(this.getMeteNameIdsOfTopicFilter(docNaviDtos)).setRelationLibInfos(this.getRelationLibInfo(docId)).setSoftVersion((String)StringUtils.defaultIfBlank((CharSequence)this.indexSubDirIdMap.remove(docId), (CharSequence)""));
        hwIcsLibDo.setIndexLang(ConfigServiceHandler.getInstance().get("system.lang")).setDocId(icsContentDto.getDocId()).setIndexDir(IndexDirUtils.getIcsIndexRootDir(docId)).setIssueDate(icsContentDto.getIssueDate()).setLanguage(icsContentDto.getLang()).setPath(icsContentDto.getPath()).setProductName(icsContentDto.getProductName()).setProductV(icsContentDto.getProductV()).setLibId(icsContentDto.getProjectid()).setLibV(icsContentDto.getLibV()).setLibName(icsContentDto.getLibName()).setIndexConfigDo(this.getIndexConfigDo());
        return this.addTask(hwIcsLibDo);
    }

    @Override
    public Map<String, String> selectIndexProgress() {
        List docIds = IcsIndexServiceHandler.getInstance().selectAllIndex();
        if (CollectionUtils.isEmpty((Collection)docIds)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> indexProgressMap = new HashMap<String, String>();
        int size = docIds.size();
        if (size <= 200) {
            List icsIndexDos = IcsIndexServiceHandler.getInstance().selectByDodIds(docIds);
            this.getIndexProgress(icsIndexDos, indexProgressMap);
        } else {
            int start = 0;
            int len = 200;
            while (start < size) {
                List subDocIds = docIds.subList(start, len);
                List icsIndexDos = IcsIndexServiceHandler.getInstance().selectByDodIds(subDocIds);
                this.getIndexProgress(icsIndexDos, indexProgressMap);
                start = len;
                len = Math.min(start + 200, size);
            }
        }
        return indexProgressMap;
    }

    @Override
    public void recreate(List<String> docIdLst) {
        if (CollectionUtils.isEmpty(docIdLst)) {
            return;
        }
        docIdLst.forEach(docId -> this.addTaskToList((String)docId, "recreate"));
    }

    private void getIndexProgress(List<IcsIndexDo> icsIndexDoList, Map<String, String> indexProgressMap) {
        if (CollectionUtils.isEmpty(icsIndexDoList)) {
            return;
        }
        icsIndexDoList.forEach(icsIndexDo -> {
            String processRate = icsIndexDo.getProcessRate();
            if ((StringUtils.isBlank((CharSequence)processRate) || StringUtils.equals((CharSequence)processRate, (CharSequence)"0")) && StringUtils.equalsAny((CharSequence)icsIndexDo.getState(), (CharSequence[])new CharSequence[]{"10000", "10004"})) {
                processRate = "100";
            }
            indexProgressMap.put(icsIndexDo.getDocId(), processRate);
        });
    }

    private List<HwIcsRelationDo> getRelationLibInfo(String docId) {
        ArrayList<HwIcsRelationDo> hwicsRelationLibInfos = new ArrayList<HwIcsRelationDo>();
        List refDocIds = IcsVersionRelationPoolServiceHandler.getInstance().getRelationDocIcList(docId);
        if (CollectionUtils.isEmpty((Collection)refDocIds)) {
            return hwicsRelationLibInfos;
        }
        for (String refDocId : refDocIds) {
            IcsContentDo icsContentDo = IcsContentPoolServiceHandler.getInstance().get(refDocId);
            if (icsContentDo == null) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "not get contentDo. id:{0}", new Object[]{docId});
                continue;
            }
            hwicsRelationLibInfos.add(new HwIcsRelationDo(refDocId, icsContentDo.getPath(), false));
        }
        return hwicsRelationLibInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTaskToList(String docId, String taskType) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]Add index task. docId[{0}]-taskType[{1}]", new Object[]{docId, taskType});
        String lastTaskType = taskType;
        Object object = LOCK_OBJECT;
        synchronized (object) {
            IcsIndexDo icsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(docId, docId);
            if (StringUtils.equals((CharSequence)taskType, (CharSequence)"create")) {
                if (icsIndexDo != null) {
                    this.interrupt(docId);
                    IcsIndexServiceHandler.getInstance().deleteIndex(docId);
                } else {
                    IcsContentDo icsContentDto = IcsContentPoolServiceHandler.getInstance().get(docId);
                    if (icsContentDto == null) {
                        CodeCCUtils.INSTANCE.infoLog(LOGGER, "not get content. id:{0}", new Object[]{docId});
                        return;
                    }
                    icsIndexDo = IcsIndexDoConverter.INSTANCE.contentDto2do(icsContentDto);
                    String indexDir = IndexDirUtils.getIcsIndexRelativeDir(docId, "");
                    icsIndexDo.setIndexDir(indexDir);
                    icsIndexDo.setRefDocId(docId);
                    icsIndexDo.setCreateTime(this.getIndexCreateTime(icsContentDto.getLoadTime()));
                    if (UnzipHelper.isZipContainFile(icsIndexDo.getPath(), ICS_RESOURCES_INDEX_PATH)) {
                        icsIndexDo.setState("10004");
                        icsIndexDo.setIndexDir(IndexDirUtils.getIcsIndexLibRelativeDir(docId));
                        lastTaskType = "recreate";
                        this.indexSubDirIdMap.put(docId, IndexDirUtils.getIndexDirExt());
                        IcsIndexUnzipThread unzipThread = new IcsIndexUnzipThread(icsIndexDo.getPath(), docId);
                        UnzipHelper.execute(unzipThread);
                    }
                }
                IcsIndexServiceHandler.getInstance().addIndex(icsIndexDo);
                Set<String> refDocIds = this.getRelationDocIds(this.getRelationLibInfo(docId));
                IcsIndexServiceHandler.getInstance().addIndexRef(icsIndexDo, refDocIds);
            } else if (StringUtils.equalsAny((CharSequence)taskType, (CharSequence[])new CharSequence[]{"recreate"})) {
                String indexDirExt = IndexDirUtils.getIndexDirExt();
                this.indexSubDirIdMap.put(docId, indexDirExt);
                String icsIndexRelativeDir = IndexDirUtils.getIcsIndexRootDir(docId) + File.separator + ICS_INDEX_DIR_PREFIX + indexDirExt;
                File file = FileUtils.getFile((String[])new String[]{icsIndexRelativeDir});
                if (file.exists()) {
                    FileUtils.deleteQuietly((File)file);
                }
            } else {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index] add index task of increment-create of docId[{0}].", new Object[]{docId});
            }
        }
        IndexTaskManager.getInstance().add(new IndexTask(docId, 0, 0, "ics", lastTaskType));
    }

    private boolean addTask(HwIcsLibDo hwicsLibInfo) {
        if (hwicsLibInfo == null) {
            return true;
        }
        boolean isSuccess = true;
        String docId = hwicsLibInfo.getDocId();
        IcsIndexDo icsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(docId, docId);
        switch (hwicsLibInfo.getTaskType()) {
            case "create": 
            case "recreate": {
                this.addTaskToPool(hwicsLibInfo);
                break;
            }
            case "increment-create": {
                if (icsIndexDo == null) {
                    hwicsLibInfo.setTaskType("create");
                    this.addTaskToPool(hwicsLibInfo);
                    break;
                }
                Set<String> refDocIds = this.getRelationDocIds(hwicsLibInfo.getRelationLibInfos());
                this.deleteRef(docId, refDocIds);
                isSuccess = this.incrementUpdate(hwicsLibInfo, icsIndexDo);
                break;
            }
        }
        return isSuccess;
    }

    private void deleteRef(String docId, Set<String> refDocIds) {
        List icsIndexDos = IcsIndexServiceHandler.getInstance().selectIndex(docId);
        if (CollectionUtils.isEmpty((Collection)icsIndexDos)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "not find index record. docId:" + docId);
            return;
        }
        List<String> curDocIds = icsIndexDos.stream().map(IcsIndexDo::getRefDocId).collect(Collectors.toList());
        List retainCurDocIds = curDocIds.stream().filter(item -> !refDocIds.contains(item) && !StringUtils.equals((CharSequence)docId, (CharSequence)item)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(retainCurDocIds)) {
            return;
        }
        for (String retainDocId : retainCurDocIds) {
            this.deleteIndexRef(docId, retainDocId);
            this.deleteIndexDoc(curDocIds, docId, retainDocId);
        }
    }

    private void deleteIndexRef(String docId, String retainDocId) {
        IcsIndexDo retainIcsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(docId, retainDocId);
        if (retainIcsIndexDo == null) {
            return;
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, String.format(Locale.ENGLISH, "[index]del ref Index docId:%s,refDocId:%s.", docId, retainDocId));
        IcsFileUtils.delFileOrDir((File)FileUtils.getFile((String[])new String[]{this.getRealIndexDir(retainIcsIndexDo.getIndexDir())}), (String)this.icsLiteStorageAdapter.getIndexPath());
        IcsIndexServiceHandler.getInstance().deleteRefIndex(docId, retainDocId);
    }

    private void deleteIndexDoc(List<String> curDocIds, String docId, String retainDocId) {
        String fieldValue = "\"" + retainDocId + "\"";
        for (String refDocId : curDocIds) {
            IcsIndexDo refIcsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(docId, refDocId);
            if (refIcsIndexDo == null) continue;
            CodeCCUtils.INSTANCE.infoLog(LOGGER, String.format(Locale.ENGLISH, "[index]increment del ref Index docId:%s,refDocId:%s", docId, refDocId));
            FieldInfoDto fieldInfo = new FieldInfoDto();
            fieldInfo.setFieldName("s_reldocid");
            fieldInfo.setFieldValue(fieldValue);
            IndexFacade.deleteIndex((FieldInfoDto)fieldInfo, (String)this.getRealIndexDir(refIcsIndexDo.getIndexDir()), (String)ConfigServiceHandler.getInstance().get("system.lang"));
        }
    }

    private int deleteIndex(String docId) {
        String indexRootDir;
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]delete index docId:{0}", new Object[]{docId});
        if (!IcsSearchBusinessHandler.getInstance().deleteIndexReaderCache(docId)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Delete search indexReader cache fail.");
        }
        if (StringUtils.isBlank((CharSequence)(indexRootDir = this.icsLiteStorageAdapter.getIndexPath()))) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "index root dir is null, from ics lite storage adapter");
        } else {
            String indexDir;
            int pos;
            IcsIndexDo icsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(docId, docId);
            if (icsIndexDo != null && (pos = StringUtils.lastIndexOf((CharSequence)(indexDir = icsIndexDo.getIndexDir()), (CharSequence)File.separator)) != -1) {
                String currentIndexMainDir = StringUtils.substring((String)indexDir, (int)0, (int)pos);
                IcsFileUtils.delFileOrDir((File)FileUtils.getFile((String[])new String[]{indexRootDir + currentIndexMainDir}), (String)indexRootDir);
            }
        }
        return IcsIndexServiceHandler.getInstance().deleteIndex(docId);
    }

    private String getRealIndexDir(String indexDir) {
        String indexRootDir = this.icsLiteStorageAdapter.getIndexPath();
        if (StringUtils.isBlank((CharSequence)indexRootDir)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "index root dir is null, from ics lite storage adapter");
            return "";
        }
        return indexRootDir + indexDir;
    }

    private void addTaskToPool(HwIcsLibDo icsIndexTaskInfo) {
        String docId = icsIndexTaskInfo.getDocId();
        IcsIndexDo icsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(docId, docId);
        if (!StringUtils.equals((CharSequence)icsIndexTaskInfo.getTaskType(), (CharSequence)"recreate")) {
            IcsIndexServiceHandler.getInstance().addIndexRef(icsIndexDo, new HashSet<String>(this.getRelationDocIds(icsIndexTaskInfo.getRelationLibInfos())));
        }
        IcsIndexHdxFileTask icsIndexHdxFileTask = new IcsIndexHdxFileTask.Builder().icsIndexTaskInfo(icsIndexTaskInfo).setIndexRootDir(this.icsLiteStorageAdapter.getIndexPath()).setEventBus(this.eventBus).setJavaHome(this.icsLiteStorageAdapter.getJavaHomePath()).build();
        this.eventBus.register((Object)icsIndexHdxFileTask);
        this.execute(icsIndexHdxFileTask);
    }

    private void interrupt(String docId) {
        this.eventBus.post((Object)docId);
    }

    private boolean incrementUpdate(HwIcsLibDo icsIndexTaskInfo, IcsIndexDo icsIndexDo) {
        Set<String> refDocIds = this.getRelationDocIds(icsIndexTaskInfo.getRelationLibInfos());
        if (CollectionUtils.isEmpty(refDocIds)) {
            return true;
        }
        List icsIndexDos = IcsIndexServiceHandler.getInstance().selectIndex(icsIndexDo.getDocId());
        List curDocIds = icsIndexDos.stream().map(IcsIndexDo::getRefDocId).collect(Collectors.toList());
        List retainRefDocIds = refDocIds.stream().filter(item -> !curDocIds.contains(item)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(retainRefDocIds)) {
            return true;
        }
        if (StringUtils.equals((CharSequence)icsIndexDo.getState(), (CharSequence)"10002")) {
            return true;
        }
        if (StringUtils.equalsAny((CharSequence)icsIndexDo.getState(), (CharSequence[])new CharSequence[]{"10003", "10001"})) {
            return false;
        }
        retainRefDocIds.addAll(this.deleteAllRef(icsIndexDo.getDocId()));
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "incrementUpdate docId:{0}", new Object[]{icsIndexDo.getDocId()});
        this.updateTaskStateAndProgress(icsIndexDo.getDocId());
        icsIndexTaskInfo.setTaskType("increment-create");
        icsIndexTaskInfo.getRelationLibInfos().forEach(v -> {
            if (retainRefDocIds.contains(v.getDocId())) {
                v.setIncrement(true);
            }
        });
        this.addTaskToPool(icsIndexTaskInfo);
        return true;
    }

    private List<String> deleteAllRef(String docId) {
        String appVersion = IcsCommonServiceHandler.getInstance().getAppVersion();
        String icsIndexDir = IndexDirUtils.getIcsIndexRootDir(docId) + File.separator + ICS_INDEX_DIR_PREFIX + appVersion;
        if (!FileUtils.getFile((String[])new String[]{icsIndexDir}).exists()) {
            return new ArrayList<String>();
        }
        List icsIndexDos = IcsIndexServiceHandler.getInstance().selectIndex(docId);
        if (CollectionUtils.isEmpty((Collection)icsIndexDos)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "not find index record. docId:{0}", new Object[]{docId});
            return new ArrayList<String>();
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "The upgrade index exists. Therefore, delete the index of the mapping package before re-create.");
        ArrayList<String> deleteDocIds = new ArrayList<String>();
        for (IcsIndexDo icsIndexdo : icsIndexDos) {
            String refDocId = icsIndexdo.getRefDocId();
            if (StringUtils.equals((CharSequence)refDocId, (CharSequence)docId) || !StringUtils.contains((CharSequence)icsIndexdo.getIndexDir(), (CharSequence)appVersion)) continue;
            this.deleteIndexRef(docId, refDocId);
            deleteDocIds.add(refDocId);
        }
        return deleteDocIds;
    }

    private void updateTaskStateAndProgress(String docId) {
        IcsIndexServiceHandler.getInstance().updateIndex(docId, "10004", "");
    }

    private List<String> getPidsFromDocNav(String docId, List<IcsDocnavDo> docNaviDtos) {
        if (CollectionUtils.isEmpty(docNaviDtos)) {
            return Lists.newArrayList();
        }
        HashSet pidIds = new HashSet();
        docNaviDtos.forEach(item -> {
            List<IcsDocnavTreeDto> icsDocnavTreeDtos = IcsDocnavBusinessServiceHandler.getInstance().getNaviPid(docId, item.getDocnavId(), "");
            pidIds.addAll(this.getPids(icsDocnavTreeDtos));
        });
        return new ArrayList<String>(pidIds);
    }

    private List<String> getMeteNameIdsOfTopicFilter(List<IcsDocnavDo> docNaviDtos) {
        if (CollectionUtils.isEmpty(docNaviDtos)) {
            return Lists.newArrayList();
        }
        HashSet metaNameIds = Sets.newHashSet();
        for (IcsDocnavDo icsDocnavDo : docNaviDtos) {
            JSONArray jsonArray;
            String filterJson = icsDocnavDo.getFilterJson();
            if (StringUtils.isBlank((CharSequence)filterJson) || (jsonArray = JSON.parseArray((String)filterJson)) == null) continue;
            int size = jsonArray.size();
            for (int index = 0; index < size; ++index) {
                JSONObject jsonObject = jsonArray.getJSONObject(index);
                if (jsonObject == null) continue;
                String topicFilter = jsonObject.getString("topicfilter");
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)topicFilter, (CharSequence[])new CharSequence[]{"false"})) continue;
                metaNameIds.add(jsonObject.getString("metanameid"));
            }
        }
        return new ArrayList<String>(metaNameIds);
    }

    private List<String> getPids(Collection<IcsDocnavTreeDto> icsDocnavTreeDtos) {
        ArrayList<String> pidIds = new ArrayList<String>();
        if (CollectionUtils.isEmpty(icsDocnavTreeDtos)) {
            return pidIds;
        }
        for (IcsDocnavTreeDto icsDocnavTreeDto : icsDocnavTreeDtos) {
            Set<IcsDocnavTreeDto> pidSet = icsDocnavTreeDto.getIcsPidSet();
            if (CollectionUtils.isEmpty(pidSet)) continue;
            pidSet.forEach(pidDto -> {
                Optional<IcsPidDo> icsPidDto;
                if ("doc".equals(pidDto.getType()) && (icsPidDto = Optional.ofNullable(pidDto.getIcsPidDo())).isPresent()) {
                    pidIds.add(icsPidDto.map(IcsPidDo::getPidId).orElse(""));
                }
            });
        }
        return pidIds;
    }

    @Override
    public int delete(String docId) {
        IcsIndexDo icsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(docId, docId);
        if (icsIndexDo == null) {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "[index]index not exist, docId:" + docId);
            return 0;
        }
        if (StringUtils.equalsAny((CharSequence)icsIndexDo.getState(), (CharSequence[])new CharSequence[]{"10001", "10004"})) {
            this.interrupt(docId);
        }
        IndexTaskManager.getInstance().remove(docId);
        return this.deleteIndex(docId);
    }

    @Override
    public void verifyIndex() {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "app start. verifyIndex.");
        Set loadDocIds = IcsContentPoolServiceHandler.getInstance().getAllDocId();
        if (StringUtils.equals((CharSequence)ConfigServiceHandler.getInstance().get("index.recreate.flag"), (CharSequence)"1")) {
            this.recreate(new ArrayList<String>(loadDocIds));
            return;
        }
        this.recreateExceptionIndex(loadDocIds);
        Set<String> docIds = this.verifyIndex(loadDocIds);
        if (CollectionUtils.isNotEmpty(docIds)) {
            docIds.forEach(docId -> this.addTaskToList((String)docId, "create"));
        }
    }

    private Set<String> verifyIndex(Set<String> loadedDocIds) {
        String indexRootDir;
        String icsIndexRootDir;
        HashSet<String> resultSet = new HashSet<String>();
        if (CollectionUtils.isEmpty(loadedDocIds)) {
            return resultSet;
        }
        List icsIndexDos = IcsIndexServiceHandler.getInstance().selectAllIndex();
        if (CollectionUtils.isNotEmpty((Collection)icsIndexDos)) {
            HashSet docIds = new HashSet(icsIndexDos);
            docIds.stream().filter(docId -> !loadedDocIds.contains(docId)).forEach(docId -> this.deleteIndex((String)docId));
        }
        if (StringUtils.isBlank((CharSequence)(icsIndexRootDir = (indexRootDir = this.icsLiteStorageAdapter.getIndexPath()) + File.separator + "ics"))) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "index root dir is null, from ics lite storage adapter");
            return SetUtils.emptySet();
        }
        File file = FileUtils.getFile((String[])new String[]{icsIndexRootDir});
        File[] files = file.listFiles();
        if (!file.exists() || !file.isDirectory() || files == null) {
            return SetUtils.emptySet();
        }
        HashSet<String> tempLoadedDocIds = new HashSet<String>(loadedDocIds);
        for (File subFile : files) {
            if (!loadedDocIds.contains(subFile.getName())) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]clear dirty data docId:" + subFile.getName());
                this.deleteLocalIndexOfNoUse(subFile, new String[]{"index", "searchFilter.html"});
                continue;
            }
            tempLoadedDocIds.remove(subFile.getName());
            File indexFile = FileUtils.getFile((String[])new String[]{IcsFileUtils.getCanonicalPath((File)subFile) + File.separator + ICS_INDEX_DIR_PREFIX + IcsCommonServiceHandler.getInstance().getAppVersion()});
            Object[] subDirs = indexFile.listFiles();
            if (ArrayUtils.isEmpty((Object[])subDirs)) continue;
            for (Object subDir : subDirs) {
                String fileName = ((File)subDir).getName();
                if (!StringUtils.startsWithIgnoreCase((CharSequence)fileName, (CharSequence)"ics") || loadedDocIds.contains(fileName)) continue;
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]clear related dirty data docId:" + fileName);
                IcsFileUtils.delFileOrDir((File)subDir, (String)indexRootDir);
            }
        }
        return tempLoadedDocIds;
    }

    public void scheduleCleanDirtyIndex() {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "scheduleCleanDirtyIndex.");
        Set loadDocIds = IcsContentPoolServiceHandler.getInstance().getAllDocId();
        this.verifyIndex(loadDocIds);
    }

    private void recreateExceptionIndex(Set<String> loadedDocIds) {
        HashSet<String> tempLoadedDocIds = new HashSet<String>(loadedDocIds);
        Iterator it = tempLoadedDocIds.iterator();
        while (it.hasNext()) {
            String docId = (String)it.next();
            IcsContentDo icsContentDto = IcsContentPoolServiceHandler.getInstance().get(docId);
            if (icsContentDto == null) {
                it.remove();
                continue;
            }
            IcsIndexDo icsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(docId, docId);
            if (icsIndexDo == null) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]doc already exist, but not find index. docId[{0}]", new Object[]{docId});
                this.create(docId);
                it.remove();
                continue;
            }
            if (this.needReCreate(icsIndexDo, icsContentDto)) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]update index\uff0cdocId[{0}]-status[{1}]", new Object[]{docId, icsIndexDo.getState()});
                this.addTaskToList(docId, "recreate");
                it.remove();
                continue;
            }
            if (StringUtils.equals((CharSequence)icsIndexDo.getState(), (CharSequence)"10000") && StringUtils.equals((CharSequence)icsIndexDo.getProcessRate(), (CharSequence)"100")) continue;
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]recreate exception index\uff0cdocId\uff1a{0}", new Object[]{docId});
            this.addTaskToList(docId, "create");
            it.remove();
        }
        this.batchAddIndex(tempLoadedDocIds);
    }

    private boolean needReCreate(IcsIndexDo icsIndexDo, IcsContentDo icsContentDo) {
        if (StringUtils.equals((CharSequence)icsIndexDo.getState(), (CharSequence)"10004")) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)icsIndexDo.getState(), (CharSequence)"10000")) {
            return false;
        }
        File file = FileUtils.getFile((String[])new String[]{this.icsLiteStorageAdapter.getIndexPath() + icsIndexDo.getIndexDir()});
        if (!file.exists()) {
            return true;
        }
        return !this.isLastestIndex(icsIndexDo.getCreateTime(), icsContentDo.getLoadTime());
    }

    public void upgradeIndex(String hisOldAppVersion) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "ICS upgradeIndex start.");
        List loadDocIds = IcsIndexServiceHandler.getInstance().selectAllIndex();
        if (CollectionUtils.isEmpty((Collection)loadDocIds)) {
            return;
        }
        String indexPath = this.icsLiteStorageAdapter.getIndexPath();
        if (StringUtils.isBlank((CharSequence)indexPath)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Index root path not get.");
            return;
        }
        SearchManagerBase searchManagerBase = new SearchManagerBase();
        for (String docId : loadDocIds) {
            IcsIndexDo icsIndexDo = IcsIndexServiceHandler.getInstance().selectRef(docId, docId);
            if (icsIndexDo == null || !StringUtils.equals((CharSequence)icsIndexDo.getState(), (CharSequence)"10000") || !this.isNeedUpdate(searchManagerBase, indexPath + icsIndexDo.getIndexDir(), icsIndexDo.getLanguage())) continue;
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]Index lang or index version is different, need update index: {0}", new Object[]{docId});
            this.updateTaskStateAndProgress(docId);
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "ICS upgradeIndex end.");
    }

    private Set<String> getRelationDocIds(List<HwIcsRelationDo> hwIcsRelationDos) {
        return ((List)Optional.ofNullable(hwIcsRelationDos).orElse(new ArrayList())).stream().map(HwIcsRelationDo::getDocId).collect(Collectors.toSet());
    }

    private static class IcsIndexBusinessHandlerHolder {
        private static final IcsIndexBusinessHandler INSTANCE = new IcsIndexBusinessHandler();

        private IcsIndexBusinessHandlerHolder() {
        }
    }
}

