/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.index.task;

import com.alibaba.fastjson.JSON;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.commonsearch.index.entity.HdxLibDo;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.service.SearchManagerBase;
import com.huawei.support.icscbb.commonsearch.search.component.SearchProcessor;
import com.huawei.support.icscbb.commonsearch.searchdb.dto.HdxIndexDo;
import com.huawei.support.icscbb.commonsearch.searchdb.service.impl.HdxIndexServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.sys.SystemCommandUtils;
import com.huawei.support.icslite.business.index.common.IndexProgressHelper;
import com.huawei.support.icslite.business.index.process.HdxIndexSubProcess;
import com.huawei.support.icslite.business.index.process.helper.ProcessHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HdxIndexFileTask
extends IndexProgressHelper
implements Runnable {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxIndexFileTask.class);
    private final SearchManagerBase searchManagerBase = new SearchManagerBase();
    private HdxLibDo hdxLibDo;
    private String javaHome;
    private AsyncEventBus eventBus;
    private Process process;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]start create index:{0}", new Object[]{this.hdxLibDo.getDocId()});
        int processStatus = 0;
        try {
            HdxIndexServiceHandler.getInstance().updateIndex(this.hdxLibDo.getDocId(), this.getTaskStatusByTaskType(this.hdxLibDo.getTaskType()), "");
            String javaBin = this.javaHome + File.separator + "bin" + File.separator + "icslite_index";
            List cmdList = SystemCommandUtils.getProcessArgs(HdxIndexSubProcess.class, (String)javaBin, this.getProcessJvmOpts(), new ArrayList(), (List)EXCLUDE_JAR_LIST);
            ProcessBuilder builder = new ProcessBuilder(cmdList);
            this.process = builder.start();
            ProcessHelper.writeArg(this.process, JSON.toJSONString((Object)this.hdxLibDo));
            if (StringUtils.equals((CharSequence)this.hdxLibDo.getTaskType(), (CharSequence)"create")) {
                this.asyncUpdateIndexProgress(this.searchManagerBase, this.hdxLibDo.getIndexDir(), this.hdxLibDo.getIndexLang());
            }
            processStatus = SystemCommandUtils.waitFor((Process)this.process, (long)this.getProcessTimeOut(), (TimeUnit)TimeUnit.MINUTES);
            if (StringUtils.equals((CharSequence)this.hdxLibDo.getTaskType(), (CharSequence)"create")) {
                this.updateIndexProgress(this.searchManagerBase, this.hdxLibDo.getIndexDir(), this.hdxLibDo.getIndexLang());
            }
        }
        catch (SearchException | IOException | InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]HdxIndexSubProcess process error", e);
            processStatus = 1;
        }
        finally {
            this.cancelTask();
            this.eventBus.unregister((Object)this);
            String taskStatus = "10000";
            if (processStatus != 0) {
                taskStatus = "10002";
                CodeCCUtils.INSTANCE.warnLog(LOGGER, "[hdx-index]The index is not created properly. Only some documents can be queried. Maybe time out.");
                this.process.destroyForcibly();
            }
            this.updateIndexRecord(taskStatus);
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]end create index:{0}", new Object[]{this.hdxLibDo.getDocId()});
    }

    private void updateIndexRecord(String taskStatus) {
        if (StringUtils.equals((CharSequence)taskStatus, (CharSequence)"10002") || !StringUtils.equals((CharSequence)this.hdxLibDo.getTaskType(), (CharSequence)"recreate")) {
            HdxIndexServiceHandler.getInstance().updateIndex(this.hdxLibDo.getDocId(), taskStatus, "");
            return;
        }
        File file = FileUtils.getFile((String[])new String[]{this.hdxLibDo.getIndexDir()});
        if (file.exists() && ArrayUtils.isNotEmpty((Object[])file.listFiles())) {
            HdxIndexDo hdxIndexDo = new HdxIndexDo();
            hdxIndexDo.setDocId(this.hdxLibDo.getDocId());
            String absIndexDir = this.hdxLibDo.getIndexDir();
            String relativeIndexDir = StringUtils.substring((String)absIndexDir, (int)absIndexDir.indexOf(File.separator + "hdx" + File.separator + this.hdxLibDo.getDocId() + File.separator + "index"));
            hdxIndexDo.setIndexDir(relativeIndexDir);
            HdxIndexDo oldHdxIndexDo = HdxIndexServiceHandler.getInstance().selectIndex(this.hdxLibDo.getDocId());
            if (HdxIndexServiceHandler.getInstance().update(hdxIndexDo) > 0) {
                this.deleteOldIndex(oldHdxIndexDo);
                HdxIndexServiceHandler.getInstance().updateIndex(this.hdxLibDo.getDocId(), taskStatus, "");
            }
        }
    }

    private void deleteOldIndex(HdxIndexDo hdxIndexDo) {
        File file;
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]index updated, delete old index docId:{0}", new Object[]{this.hdxLibDo.getDocId()});
        if (hdxIndexDo == null) {
            return;
        }
        String indexRootPath = IcsLiteStorageInstance.getInstance().getIndexPath();
        if (!SearchProcessor.deleteIndexReaderCache((String)(indexRootPath + hdxIndexDo.getIndexDir()), (String)"libtasktype")) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]Delete search indexReader cache fail.The file may not be deleted completely.");
        }
        if ((file = FileUtils.getFile((String[])new String[]{indexRootPath + hdxIndexDo.getIndexDir()})).exists() && !IcsFileUtils.delFileOrDir((File)file, (String)indexRootPath)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[hdx-index]old index delete fail. docId:{0}", new Object[]{this.hdxLibDo.getDocId()});
        }
    }

    @Override
    protected void updateProgress(String rate) {
        if (StringUtils.equals((CharSequence)this.hdxLibDo.getTaskType(), (CharSequence)"recreate")) {
            return;
        }
        if (this.isInterrupt()) {
            HdxIndexServiceHandler.getInstance().updateProcessrate(this.hdxLibDo.getDocId(), "100");
            return;
        }
        this.pushIndexProgressMessage(this.hdxLibDo.getDocId(), rate);
        HdxIndexServiceHandler.getInstance().updateProcessrate(this.hdxLibDo.getDocId(), rate);
    }

    @Override
    protected void exitProcess() {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[hdx-index]exit index process.");
        this.cancelTask();
        if (this.process != null && this.process.isAlive()) {
            this.process.destroyForcibly();
        }
    }

    public HdxIndexFileTask setHdxIndexTaskInfo(HdxLibDo libInfo) {
        this.hdxLibDo = libInfo;
        return this;
    }

    public HdxIndexFileTask setEventBus(AsyncEventBus asyncEventBus) {
        this.eventBus = asyncEventBus;
        return this;
    }

    public HdxIndexFileTask setJavaHome(String jreHome) {
        this.javaHome = jreHome;
        return this;
    }

    @Subscribe
    public void dealWithEvent(String event) {
        if (StringUtils.equals((CharSequence)this.hdxLibDo.getDocId(), (CharSequence)event)) {
            this.exitProcess();
        }
    }
}

