/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.index.task;

import com.alibaba.fastjson.JSON;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageInstance;
import com.huawei.support.icscbb.commonsearch.index.constant.IndexConstants;
import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsRelationDo;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.service.SearchManagerBase;
import com.huawei.support.icscbb.commonsearch.search.component.SearchProcessor;
import com.huawei.support.icscbb.commonsearch.searchdb.service.IcsIndexService;
import com.huawei.support.icscbb.commonsearch.searchdb.service.impl.IcsIndexServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.sys.SystemCommandUtils;
import com.huawei.support.icslite.business.index.common.IndexDirUtils;
import com.huawei.support.icslite.business.index.common.IndexProgressHelper;
import com.huawei.support.icslite.business.index.process.IcsIndexSubProcess;
import com.huawei.support.icslite.business.index.process.helper.ProcessHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsIndexHdxFileTask
extends IndexProgressHelper
implements Runnable {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsIndexHdxFileTask.class);
    private final HwIcsLibDo hwIcsLibDo;
    private final IcsIndexService icsIndexService = IcsIndexServiceHandler.getInstance();
    private final String indexRootDir;
    private final AsyncEventBus eventBus;
    private final String javaHome;
    private final SearchManagerBase searchManagerBase = new SearchManagerBase();
    private Process process;

    public IcsIndexHdxFileTask(Builder builder) {
        this.hwIcsLibDo = builder.icsIndexTaskInfo;
        this.indexRootDir = builder.indexRootDir;
        this.eventBus = builder.eventBus;
        this.javaHome = builder.javaHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]start create index:{0}", new Object[]{this.hwIcsLibDo.getDocId()});
        if (StringUtils.isBlank((CharSequence)this.indexRootDir)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]index root dir is null, from ics lite storage adapter");
            return;
        }
        int processStatus = 0;
        String indexDirAbsPath = this.hwIcsLibDo.getIndexDir() + String.format(Locale.ENGLISH, IndexConstants.HDX_INDEXDIR_FORMAT, "", this.hwIcsLibDo.getDocId());
        try {
            this.icsIndexService.updateIndex(this.hwIcsLibDo.getDocId(), this.getTaskStatusByTaskType(this.hwIcsLibDo.getTaskType()), "");
            String javaBin = this.javaHome + File.separator + "bin" + File.separator + "icslite_index";
            List cmdList = SystemCommandUtils.getProcessArgs(IcsIndexSubProcess.class, (String)javaBin, this.getProcessJvmOpts(), new ArrayList(), (List)EXCLUDE_JAR_LIST);
            ProcessBuilder builder = new ProcessBuilder(cmdList);
            this.process = builder.start();
            ProcessHelper.writeArg(this.process, JSON.toJSONString((Object)this.hwIcsLibDo));
            if (StringUtils.equals((CharSequence)this.hwIcsLibDo.getTaskType(), (CharSequence)"create")) {
                this.asyncUpdateIndexProgress(this.searchManagerBase, indexDirAbsPath, this.hwIcsLibDo.getIndexLang());
            }
            processStatus = SystemCommandUtils.waitFor((Process)this.process, (long)this.getProcessTimeOut(), (TimeUnit)TimeUnit.MINUTES);
            if (StringUtils.equals((CharSequence)this.hwIcsLibDo.getTaskType(), (CharSequence)"recreate")) {
                indexDirAbsPath = IndexDirUtils.getIcsIndexAbsoluteDir(this.hwIcsLibDo.getDocId(), this.hwIcsLibDo.getSoftVersion());
            }
            if (StringUtils.equalsAny((CharSequence)this.hwIcsLibDo.getTaskType(), (CharSequence[])new CharSequence[]{"create", "recreate"})) {
                this.updateIndexProgress(this.searchManagerBase, indexDirAbsPath, this.hwIcsLibDo.getIndexLang());
            }
        }
        catch (SearchException | IOException | InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]IcsIndexSubProcess process error", e);
            processStatus = 1;
        }
        finally {
            this.cancelTask();
            this.eventBus.unregister((Object)this);
            String taskStatus = "10000";
            if (processStatus != 0) {
                taskStatus = "10002";
                CodeCCUtils.INSTANCE.warnLog(LOGGER, "[index]The index is not created properly. Only some documents can be queried. Maybe timeout.");
            }
            this.updateIndexRecord(taskStatus);
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]end create index:{0}", new Object[]{this.hwIcsLibDo.getDocId()});
    }

    private void updateIndexRecord(String taskStatus) {
        if (StringUtils.equals((CharSequence)taskStatus, (CharSequence)"10002") || !StringUtils.equals((CharSequence)this.hwIcsLibDo.getTaskType(), (CharSequence)"recreate")) {
            this.icsIndexService.updateIndex(this.hwIcsLibDo.getDocId(), taskStatus, "");
            return;
        }
        File file = FileUtils.getFile((String[])new String[]{IndexDirUtils.getIcsIndexAbsoluteDir(this.hwIcsLibDo.getDocId(), this.hwIcsLibDo.getSoftVersion())});
        if (file.exists() && ArrayUtils.isNotEmpty((Object[])file.listFiles())) {
            List docIds = this.hwIcsLibDo.getRelationLibInfos().stream().map(HwIcsRelationDo::getDocId).collect(Collectors.toList());
            docIds.add(this.hwIcsLibDo.getDocId());
            List<String> oldIndexDirs = this.getOldIndexDirs();
            if (this.icsIndexService.updateIndexDir(this.hwIcsLibDo.getDocId(), this.hwIcsLibDo.getSoftVersion(), docIds) > 0) {
                this.deleteOldIndex(oldIndexDirs);
                this.icsIndexService.updateIndex(this.hwIcsLibDo.getDocId(), taskStatus, "");
            }
        }
    }

    private void deleteOldIndex(List<String> oldIndexDirs) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]index updated, delete old index docId:{0}", new Object[]{this.hwIcsLibDo.getDocId()});
        String indexRootPath = IcsLiteStorageInstance.getInstance().getIndexPath();
        oldIndexDirs.forEach(indexDir -> this.delIndexAndFile(indexRootPath, (String)indexDir));
    }

    private void delIndexAndFile(String indexRootPath, String indexDir) {
        File file;
        if (!SearchProcessor.deleteIndexReaderCache((String)indexDir, (String)"libtasktype")) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Delete search indexReader cache fail.The file may not be deleted completely.");
        }
        if ((file = FileUtils.getFile((String[])new String[]{indexDir})).exists() && !IcsFileUtils.delFileOrDir((File)file, (String)indexRootPath)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]old index delete fail. docId:{0}", new Object[]{this.hwIcsLibDo.getDocId()});
        }
    }

    private List<String> getOldIndexDirs() {
        List icsIndexDos = IcsIndexServiceHandler.getInstance().selectIndex(this.hwIcsLibDo.getDocId());
        ArrayList<String> indexDirs = new ArrayList<String>();
        String indexRootPath = IcsLiteStorageInstance.getInstance().getIndexPath();
        ((List)Optional.ofNullable(icsIndexDos).orElse(new ArrayList())).forEach(icsIndexDo -> indexDirs.add(indexRootPath + icsIndexDo.getIndexDir()));
        return indexDirs;
    }

    @Override
    protected void updateProgress(String rate) {
        if (this.isInterrupt()) {
            return;
        }
        this.pushIndexProgressMessage(this.hwIcsLibDo.getDocId(), rate);
        this.icsIndexService.updateProgress(this.hwIcsLibDo.getDocId(), rate);
    }

    @Override
    protected void exitProcess() {
        this.cancelTask();
        if (this.process != null && this.process.isAlive()) {
            this.process.destroyForcibly();
        }
    }

    @Subscribe
    public void dealWithEvent(String event) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]exit index process.");
        this.cancelTask();
        if (StringUtils.equals((CharSequence)this.hwIcsLibDo.getDocId(), (CharSequence)event)) {
            this.exitProcess();
        }
    }

    public static class Builder {
        private HwIcsLibDo icsIndexTaskInfo;
        private String indexRootDir;
        private AsyncEventBus eventBus;
        private String javaHome;

        public Builder icsIndexTaskInfo(HwIcsLibDo taskInfo) {
            this.icsIndexTaskInfo = taskInfo;
            return this;
        }

        public Builder setIndexRootDir(String rootDir) {
            this.indexRootDir = rootDir;
            return this;
        }

        public Builder setEventBus(AsyncEventBus asyncEventBus) {
            this.eventBus = asyncEventBus;
            return this;
        }

        public Builder setJavaHome(String jreHome) {
            this.javaHome = jreHome;
            return this;
        }

        public IcsIndexHdxFileTask build() {
            return new IcsIndexHdxFileTask(this);
        }
    }
}

