/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.index.task.manager;

import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.index.common.AbstractIndexService;
import com.huawei.support.icslite.business.index.service.HdxIndexBusiness;
import com.huawei.support.icslite.business.index.service.IcsIndexBusiness;
import com.huawei.support.icslite.business.index.task.manager.IndexTask;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IndexTaskManager
extends AbstractIndexService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IndexTaskManager.class);
    private static final int TASK_SET_SIZE_MAX = 1000;
    private static final int HIGHEST_TASK_PRIORITY_NUM = 0;
    private int firstPriorityNum = 0;
    private int secondPriorityNum = 0;
    private PriorityBlockingQueue<IndexTask> indexTaskQueue = new PriorityBlockingQueue(1000);
    private ArrayBlockingQueue<IndexTask> icsUpgradeQueue = new ArrayBlockingQueue(1000, true);
    private ArrayBlockingQueue<IndexTask> hdxUpgradeQueue = new ArrayBlockingQueue(1000, true);

    private IndexTaskManager() {
    }

    public static IndexTaskManager getInstance() {
        return IndexTaskManagerHolder.INSTANCE;
    }

    public void add(IndexTask indexTask) {
        if (this.isFull()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Index task queue is more then 1000, can't process. docId[{0}]-taskType[{1}]" + indexTask.getDocId(), new Object[]{indexTask.getMode()});
            return;
        }
        if (this.isExist(indexTask)) {
            return;
        }
        if (!StringUtils.equals((CharSequence)indexTask.getMode(), (CharSequence)"recreate")) {
            if (this.isDoubleClickTask(indexTask)) {
                indexTask.setFirstPriorityNum(0);
                indexTask.setSecondPriorityNum(this.secondPriorityNum++);
            } else {
                indexTask.setFirstPriorityNum(this.firstPriorityNum++);
            }
            this.indexTaskQueue.add(indexTask);
            return;
        }
        if (StringUtils.equals((CharSequence)indexTask.getResType(), (CharSequence)"hdx")) {
            this.hdxUpgradeQueue.add(indexTask);
        } else {
            this.icsUpgradeQueue.add(indexTask);
        }
    }

    private boolean isDoubleClickTask(IndexTask indexTask) {
        return IcsCommonServiceHandler.getInstance().getDoubleClickLibPathPool().containsValue(indexTask.getDocId());
    }

    private boolean isFull() {
        return this.indexTaskQueue.size() > 1000 || this.icsUpgradeQueue.size() > 1000 || this.hdxUpgradeQueue.size() > 1000;
    }

    private boolean isExist(IndexTask indexTask) {
        return this.exist(indexTask, this.indexTaskQueue) || this.exist(indexTask, this.icsUpgradeQueue) || this.exist(indexTask, this.hdxUpgradeQueue);
    }

    private boolean exist(IndexTask indexTask, Queue<IndexTask> queue) {
        return queue.stream().anyMatch(queueTask -> StringUtils.equals((CharSequence)queueTask.getDocId(), (CharSequence)indexTask.getDocId()));
    }

    public void remove(String docId) {
        Iterator<IndexTask> iterator = this.indexTaskQueue.iterator();
        while (iterator.hasNext()) {
            IndexTask indexTask = iterator.next();
            if (!StringUtils.equals((CharSequence)indexTask.getDocId(), (CharSequence)docId)) continue;
            iterator.remove();
            break;
        }
    }

    public synchronized int getQueueLocation(String docId) {
        Object[] indexTasks = this.indexTaskQueue.toArray(new IndexTask[0]);
        Arrays.sort(indexTasks);
        int location = 1;
        for (Object indexTask : indexTasks) {
            if (StringUtils.equals((CharSequence)((IndexTask)indexTask).getMode(), (CharSequence)"increment-create")) continue;
            if (StringUtils.equals((CharSequence)((IndexTask)indexTask).getDocId(), (CharSequence)docId)) {
                return location;
            }
            ++location;
        }
        for (IndexTask indexTask : this.icsUpgradeQueue) {
            if (StringUtils.equals((CharSequence)indexTask.getMode(), (CharSequence)"increment-create")) continue;
            if (StringUtils.equals((CharSequence)indexTask.getDocId(), (CharSequence)docId)) {
                return location;
            }
            ++location;
        }
        for (IndexTask indexTask : this.hdxUpgradeQueue) {
            if (StringUtils.equals((CharSequence)indexTask.getMode(), (CharSequence)"increment-create")) continue;
            if (StringUtils.equals((CharSequence)indexTask.getDocId(), (CharSequence)docId)) {
                return location;
            }
            ++location;
        }
        return 0;
    }

    public void start() {
        if (this.hasIdleThreads()) {
            return;
        }
        Optional<Object> indexTaskOpt = Optional.empty();
        try {
            indexTaskOpt = this.getTask();
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Index task queue process error.", (Throwable)e);
        }
        if (!indexTaskOpt.isPresent()) {
            this.firstPriorityNum = 0;
            this.secondPriorityNum = 0;
            return;
        }
        IndexTask indexTask = (IndexTask)indexTaskOpt.get();
        if (StringUtils.equals((CharSequence)indexTask.getResType(), (CharSequence)"hdx")) {
            HdxIndexBusiness hdxIndexBusiness = (HdxIndexBusiness)SpringContextUtil.getBean((String)"hdxIndexBusiness");
            hdxIndexBusiness.startCreateIndex(indexTask.getDocId(), indexTask.getMode());
        } else {
            IcsIndexBusiness icsIndexBusiness = (IcsIndexBusiness)SpringContextUtil.getBean((String)"icsIndexBusiness");
            icsIndexBusiness.createThreadPoolTask(indexTask.getDocId(), indexTask.getMode());
        }
    }

    private Optional<IndexTask> getTask() throws InterruptedException {
        if (CollectionUtils.isEmpty(this.indexTaskQueue) && CollectionUtils.isEmpty(this.icsUpgradeQueue) && CollectionUtils.isEmpty(this.hdxUpgradeQueue)) {
            return Optional.empty();
        }
        if (CollectionUtils.isNotEmpty(this.indexTaskQueue)) {
            return Optional.ofNullable(this.indexTaskQueue.take());
        }
        if (CollectionUtils.isNotEmpty(this.icsUpgradeQueue)) {
            return Optional.ofNullable(this.icsUpgradeQueue.take());
        }
        return Optional.ofNullable(this.hdxUpgradeQueue.take());
    }

    private static class IndexTaskManagerHolder {
        private static final IndexTaskManager INSTANCE = new IndexTaskManager();

        private IndexTaskManagerHolder() {
        }
    }
}

