/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.index.thread;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.zipfile.ZipFileUtils;
import com.huawei.support.icslite.business.index.common.IndexDirUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;

public class IcsIndexUnzipThread
implements Runnable {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsIndexUnzipThread.class);
    private static final String ICS_RESOURCES_INDEX_RELATIVE_PATH = "resources/index/";
    private String docPath;
    private String docId;

    public IcsIndexUnzipThread(String docPath, String docId) {
        this.docPath = docPath;
        this.docId = docId;
    }

    @Override
    public void run() {
        this.unzipIcsIndex(this.docPath, this.docId);
    }

    private boolean unzipIcsIndex(String icsDocPath, String docIdParam) {
        File zipFile = FileUtils.getFile((String[])new String[]{icsDocPath});
        if (!zipFile.exists()) {
            return false;
        }
        String indexLibPath = IndexDirUtils.getIcsIndexLibDir(docIdParam);
        File libIndexDir = FileUtils.getFile((String[])new String[]{indexLibPath});
        if (!libIndexDir.exists() && !libIndexDir.mkdirs()) {
            return false;
        }
        boolean result = ZipFileUtils.unZipForExpectDir((String)icsDocPath, (String)indexLibPath, (String)ICS_RESOURCES_INDEX_RELATIVE_PATH);
        this.copyIndexToIndexLibRootDir(indexLibPath);
        return result;
    }

    private void copyIndexToIndexLibRootDir(String indexLibPath) {
        File[] files = FileUtils.getFile((String[])new String[]{indexLibPath}).listFiles();
        if (ObjectUtils.isEmpty((Object)files)) {
            return;
        }
        try {
            File defaultIndexDir = files[0];
            FileUtils.copyDirectory((File)defaultIndexDir, (File)FileUtils.getFile((String[])new String[]{indexLibPath}));
            FileUtils.deleteQuietly((File)defaultIndexDir);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Ics Index unzip, Copy dir fail.", (Throwable)e);
        }
    }
}

