/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.libmanage.dependency;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.libentity.dto.LibBaseDo;
import com.huawei.support.icslite.business.customsort.service.impl.CustomSortBusinessHandler;
import com.huawei.support.icslite.business.hdx.navi.service.impl.HdxNaviBusinessHandler;
import com.huawei.support.icslite.business.ics.navi.service.impl.IcsNaviBusinessHandler;
import com.huawei.support.icslite.business.index.serviceimpl.HdxIndexBusinessHandler;
import com.huawei.support.icslite.business.index.serviceimpl.IcsIndexBusinessHandler;
import com.huawei.support.icslite.business.search.serviceimpl.HdxSearchBusinessHandler;
import com.huawei.support.icslite.business.search.serviceimpl.IcsSearchBusinessHandler;
import com.huawei.support.icslite.business.verifylib.service.VerifyService;
import com.huawei.support.icslite.business.verifylib.service.impl.VerifyServiceHandler;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.customsort.dto.CustomSortDo;
import com.huawei.support.icslite.customsort.service.impl.CustomSortServiceHandler;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class LibManageDependency {
    VerifyService verifyService = VerifyServiceHandler.getInstance();

    private LibManageDependency() {
    }

    public static LibManageDependency getInstance() {
        return LibManageDependencyHolder.INSTANCE;
    }

    public void startVerify() {
        this.verifyService.signal();
    }

    public void delVerifyTask(String docId) {
        this.verifyService.del(docId);
    }

    public boolean delCustomSortData(String docId) {
        return CustomSortServiceHandler.getInstance().delByDocId(docId);
    }

    public boolean addCustomSortData(LibBaseDo libBaseDo, String libType) {
        return CustomSortBusinessHandler.getInstance().addLibData(libBaseDo, libType);
    }

    public Set<String> getCustomDocId() {
        return CustomSortServiceHandler.getInstance().getAllDocId();
    }

    public void setUpDateFlag(String docId, boolean bUpdate) {
        CustomSortBusinessHandler.getInstance().setUpDateFlag(docId, bUpdate);
    }

    public Map<String, String> getIcsIndexProgress() {
        return IcsIndexBusinessHandler.getInstance().selectIndexProgress();
    }

    public Map<String, String> getHdxIndexProgress() {
        return HdxIndexBusinessHandler.getInstance().selectIndexProgress();
    }

    public void initHdxNavi(HdxContentDo hdx, List<HdxContentDo> exdHdxList) {
        HdxNaviBusinessHandler.getInstance().init(hdx, exdHdxList);
    }

    public void initIcsNavi(IcsContentDo icsContentDo) {
        IcsNaviBusinessHandler.getInstance().init(icsContentDo);
    }

    public void initMend(HdxContentDo base, HdxContentDo mend, List<HdxContentDo> expandList) {
        HdxNaviBusinessHandler.getInstance().initMend(base, mend, expandList);
    }

    public void initExpand(HdxContentDo hdxContentDo) {
        HdxNaviBusinessHandler.getInstance().initExpand(hdxContentDo);
    }

    public int remove(String docId) {
        return HdxNaviBusinessHandler.getInstance().remove(docId);
    }

    public boolean createHdxIndex(String docId) {
        return HdxIndexBusinessHandler.getInstance().create(docId);
    }

    public int deleteHdxIndex(String docId) {
        return HdxIndexBusinessHandler.getInstance().delete(docId);
    }

    public boolean generateFilterHtmlPieces(String docId) {
        return HdxSearchBusinessHandler.getInstance().generateFilterHtmlPieces(docId);
    }

    public boolean delConfigFile(String docId) {
        return HdxSearchBusinessHandler.getInstance().delConfigFile(docId);
    }

    public int deleteByDocId(String docId) {
        return IcsNaviBusinessHandler.getInstance().deleteByDocId(docId);
    }

    public void updateMainDocPids(String docId) {
        IcsNaviBusinessHandler.getInstance().updateMainDocPids(docId);
    }

    public boolean createIcsIndex(String docId) {
        return IcsIndexBusinessHandler.getInstance().create(docId);
    }

    public int deleteIcsIndex(String docId) {
        return IcsIndexBusinessHandler.getInstance().delete(docId);
    }

    public void batchAddIndex(Collection<String> docIds) {
        IcsIndexBusinessHandler.getInstance().batchAddIndex(docIds);
    }

    public List<CustomSortDo> getCustomDoList(String docId) {
        return CustomSortServiceHandler.getInstance().getCustomDoList(docId);
    }

    public boolean generateIcsFilterHtmlPieces(String docId) {
        return IcsSearchBusinessHandler.getInstance().generateIcsFilterHtmlPieces(docId);
    }

    public void deleteDocResourceDir(String docId, String resourceType) {
        String resourcePath = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "resource" + File.separator + resourceType + File.separator + docId;
        IcsFileUtils.delFileOrDir((File)FileUtils.getFile((String[])new String[]{resourcePath}), (String)resourcePath);
    }

    private static class LibManageDependencyHolder {
        private static final LibManageDependency INSTANCE = new LibManageDependency();

        private LibManageDependencyHolder() {
        }
    }
}

