/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.libmanage.serviceimpl;

import com.google.common.eventbus.AsyncEventBus;
import com.huawei.support.icscbb.hdx.common.content.dao.HdxContentDaoHandler;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.pool.BasePool;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icslite.business.doubleclicklib.entity.message.DoubleClickSceneMessage;
import com.huawei.support.icslite.business.libmanage.constant.LibManageContants;
import com.huawei.support.icslite.business.libmanage.dependency.LibManageDependency;
import com.huawei.support.icslite.business.libmanage.dto.LibResponseDto;
import com.huawei.support.icslite.business.libmanage.mapper.LibResponseConverter;
import com.huawei.support.icslite.business.libmanage.service.HdxManageService;
import com.huawei.support.icslite.business.search.serviceimpl.HdxSearchSuggestBusinessHander;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.docnote.dto.DocNoteDo;
import com.huawei.support.icslite.docnote.service.impl.DocNoteServiceHandler;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class HdxManageServiceHandler
extends BasePool<String>
implements HdxManageService,
LibManageContants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxManageServiceHandler.class);
    private static final String RESOURCE_TYPE_HDX = "hdx";
    private AsyncEventBus eventBus = EventBusUtils.INSTANCE.getEventBus();

    private HdxManageServiceHandler() {
    }

    public static HdxManageServiceHandler getInstance() {
        return HdxManageServiceHandlerHolder.INSTANCE;
    }

    protected void createPool(String key) {
    }

    protected void addPool(String key, String value) {
        if (this.objectMap.containsKey(key)) {
            return;
        }
        super.addPool(key, (Object)value);
    }

    public String getPool(String key) {
        return (String)super.getPool(key);
    }

    @Override
    public void createTb() {
        HdxContentPoolServiceHandler.getInstance().createTb();
        HdxContentPoolServiceHandler.getInstance().createOldTb();
    }

    @Override
    public synchronized Optional<HdxContentDo> addHdx(File file) {
        return this.addHdx(file, false);
    }

    @Override
    public Optional<HdxContentDo> addDoubleClickHdx(File file) {
        return this.addHdx(file, true);
    }

    @Override
    public boolean findHdx(HdxContentDo hdx) {
        return HdxContentPoolServiceHandler.getInstance().findHdx(hdx);
    }

    @Override
    public void updateHdx(List<HdxContentDo> hdxContentList) {
        HashSet<String> docIdSet = new HashSet<String>();
        for (HdxContentDo hdx : hdxContentList) {
            this.updateHdx(hdx, docIdSet, false);
        }
    }

    @Override
    public void updateHdx(HdxContentDo hdx) {
        HashSet<String> docIdSet = new HashSet<String>();
        this.updateHdx(hdx, docIdSet, true);
    }

    private void updateHdx(HdxContentDo hdxContentDo, Set<String> docIdSet, boolean isDoubleClick) {
        this.updateFromBaseHdx(hdxContentDo, docIdSet);
        if (isDoubleClick) {
            this.doubleClickUpdateFromMendHdx(hdxContentDo, docIdSet);
        } else {
            this.updateFromMendHdx(hdxContentDo, docIdSet);
        }
        this.updateFromExtendHdx(hdxContentDo, docIdSet);
        hdxContentDo.setbUse(true);
        HdxContentPoolServiceHandler.getInstance().update(hdxContentDo);
        this.libLoadedThirdModuleHandler(hdxContentDo);
    }

    private void libLoadedThirdModuleHandler(HdxContentDo hdxContentDo) {
        LibManageDependency.getInstance().createHdxIndex(hdxContentDo.getDocId());
        HdxSearchSuggestBusinessHander.getInstance().updateSuggestWords(hdxContentDo.getDocId());
        DocNoteServiceHandler.getInstance().updateHdxFlag(this.createDocNoteDo(hdxContentDo, "0"));
    }

    private DocNoteDo createDocNoteDo(HdxContentDo hdxContentDo, String deleteFlag) {
        return new DocNoteDo().setLibId(hdxContentDo.getLibId()).setLibV((String)StringUtils.defaultIfBlank((CharSequence)hdxContentDo.getLibV(), (CharSequence)"")).setLang(hdxContentDo.getLang()).setDeleteFlag(deleteFlag);
    }

    private void doubleClickUpdateFromMendHdx(HdxContentDo mendHdx, Set<String> docIdSet) {
        this.updateFromMendHdxWhenDifferWayLoad(mendHdx, docIdSet, true);
    }

    private void updateBaseHdx(HdxContentDo hdx, List<HdxContentDo> exdHdxList, Set<String> docIdSet) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "updateBaseHdx");
        this.updateBefore(hdx, docIdSet);
        LibManageDependency.getInstance().initHdxNavi(hdx, exdHdxList);
        this.updateAfter(hdx, docIdSet);
    }

    private void updateMendHdx(HdxContentDo base, HdxContentDo mend, List<HdxContentDo> exdHdxList, Set<String> docIdSet) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "updateMendHdx");
        this.updateBefore(mend, docIdSet);
        LibManageDependency.getInstance().initMend(base, mend, exdHdxList);
        this.updateAfter(mend, docIdSet);
    }

    private void updateExtHdx(HdxContentDo exd, Set<String> docIdSet) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "updateExtHdx");
        this.updateBefore(exd, docIdSet);
        LibManageDependency.getInstance().initExpand(exd);
        this.updateAfter(exd, docIdSet);
    }

    private void updateBefore(HdxContentDo hdx, Set<String> docIdSet) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "updateBefore, docId: " + hdx.getDocId());
        if (docIdSet.contains(hdx.getDocId())) {
            return;
        }
        hdx.setbUse(false);
        LibManageDependency.getInstance().generateFilterHtmlPieces(hdx.getDocId());
    }

    private void updateAfter(HdxContentDo hdx, Set<String> docIdSet) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "updateAfter , docId: " + hdx.getDocId());
        docIdSet.add(hdx.getDocId());
        hdx.setbUse(true);
    }

    public void updateFromBaseHdx(HdxContentDo baseHdx, Set<String> docIdSet) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "updateFromBaseHdx");
        if (!StringUtils.equals((CharSequence)baseHdx.getLibType(), (CharSequence)"0")) {
            return;
        }
        List exdHdxList = HdxContentPoolServiceHandler.getInstance().getExtendList(baseHdx);
        this.updateBaseHdx(baseHdx, exdHdxList, docIdSet);
    }

    public void updateFromMendHdx(HdxContentDo mendHdx, Set<String> docIdSet) {
        this.updateFromMendHdxWhenDifferWayLoad(mendHdx, docIdSet, false);
    }

    private void updateFromMendHdxWhenDifferWayLoad(HdxContentDo mendHdx, Set<String> docIdSet, boolean isDoubleClick) {
        if (!StringUtils.equals((CharSequence)mendHdx.getLibType(), (CharSequence)"1")) {
            return;
        }
        HdxContentDo baseHdx = HdxContentPoolServiceHandler.getInstance().getBaseByMend(mendHdx);
        String mendHdxPath = mendHdx.getPath();
        if (baseHdx == null) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Can't find Base Lib with File: {0}", new Object[]{new File(mendHdxPath).getName()});
            HdxContentPoolServiceHandler.getInstance().del(mendHdx.getDocId());
            this.addPool(mendHdx.getPath(), "3");
            if (isDoubleClick) {
                IcsCommonServiceHandler.getInstance().getDoubleClickLibPathPool().remove(mendHdxPath);
                IcsCommonServiceHandler.getInstance().setDoubleClickLibPath("");
                CodeCCUtils.INSTANCE.infoLog(LOG, "name : {0} remove doubleClickLibPathPool  success.", new Object[]{mendHdx.getDocId() + "_" + mendHdx.getLibName()});
                this.eventBus.post((Object)new DoubleClickSceneMessage("3", mendHdxPath));
            }
            LibManageDependency.getInstance().delCustomSortData(mendHdx.getDocId());
            return;
        }
        List exdHdxList = HdxContentPoolServiceHandler.getInstance().getExtendList(baseHdx);
        this.updateMendHdx(baseHdx, mendHdx, exdHdxList, docIdSet);
    }

    public void updateFromExtendHdx(HdxContentDo extendHdx, Set<String> docIdSet) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "updateFromExtendHdx");
        if (!StringUtils.equals((CharSequence)extendHdx.getLibType(), (CharSequence)"2")) {
            return;
        }
        this.updateExtHdx(extendHdx, docIdSet);
        this.updateHdxFromExtend(extendHdx, docIdSet);
    }

    private void updateHdxFromExtend(HdxContentDo extendHdx, Set<String> docIdSet) {
        List baseList = HdxContentPoolServiceHandler.getInstance().getBaseByExtend(extendHdx);
        for (HdxContentDo baseHdx : baseList) {
            List exdHdxList = HdxContentPoolServiceHandler.getInstance().getExtendList(baseHdx);
            this.updateBaseHdx(baseHdx, exdHdxList, docIdSet);
            List mendHdxList = HdxContentPoolServiceHandler.getInstance().getMendList(baseHdx);
            for (HdxContentDo mendHdx : mendHdxList) {
                this.updateMendHdx(baseHdx, mendHdx, exdHdxList, docIdSet);
            }
        }
    }

    @Override
    public String getFileName(String docId) {
        HdxContentDo hdx = HdxContentPoolServiceHandler.getInstance().get(docId);
        if (hdx == null) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "hdx is null.");
            return "";
        }
        String path = hdx.getPath();
        if (StringUtils.isBlank((CharSequence)path)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "path is null.");
            return "";
        }
        File file = FileUtils.getFile((String[])new String[]{path});
        if (!file.isFile()) {
            return "";
        }
        return file.getName();
    }

    @Override
    public synchronized boolean del(String docId) {
        return this.delReturnFail(docId) == null;
    }

    @Override
    public synchronized HdxContentDo delReturnFail(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delHdx, docId: " + docId);
        if (StringUtils.isBlank((CharSequence)docId)) {
            return null;
        }
        HdxContentDo hdx = this.delHdxObject(docId);
        if (hdx == null) {
            return null;
        }
        boolean isSuccess = IcsFileUtils.delFile((String)hdx.getPath());
        if (isSuccess) {
            OperationLogUtils.INSTANCE.successOperationLog("icslite-business-service", "DELETE", "delHdx success. docId:{0}", new Object[]{docId});
            return null;
        }
        return hdx;
    }

    @Override
    public HdxContentDo delHdxObject(String docId) {
        if (docId == null) {
            return null;
        }
        CodeCCUtils.INSTANCE.debugLog(LOG, "delHdxObject, docId: " + docId);
        HdxContentDo hdxContentDo = this.getHdx(docId);
        if (hdxContentDo != null) {
            hdxContentDo.setState("Deleted");
            hdxContentDo.setbUse(false);
            HdxSearchSuggestBusinessHander.getInstance().deleteSuggestWords(docId);
            this.delBaseHdx(hdxContentDo);
            this.delMendHdx(hdxContentDo);
            this.delExtendHdx(hdxContentDo);
            LibManageDependency.getInstance().delCustomSortData(docId);
            String path = hdxContentDo.getPath();
            ZipFilePool.removeAndClose((String)path);
            DocNoteServiceHandler.getInstance().updateHdxFlag(this.createDocNoteDo(hdxContentDo, "1"));
        }
        return hdxContentDo;
    }

    private void delBaseHdx(HdxContentDo baseHdx) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delHdxObject by baseHdx");
        if (!StringUtils.equals((CharSequence)baseHdx.getLibType(), (CharSequence)"0")) {
            return;
        }
        String docId = baseHdx.getDocId();
        LibManageDependency.getInstance().deleteHdxIndex(docId);
        LibManageDependency.getInstance().remove(docId);
        LibManageDependency.getInstance().deleteDocResourceDir(docId, RESOURCE_TYPE_HDX);
        List mendList = HdxContentPoolServiceHandler.getInstance().getMendList(baseHdx);
        for (HdxContentDo mendHdx : mendList) {
            mendHdx.setLastModified(0L);
            mendHdx.setState("Deleted");
            mendHdx.setbUse(false);
            String mendDocId = mendHdx.getDocId();
            LibManageDependency.getInstance().deleteHdxIndex(mendDocId);
            LibManageDependency.getInstance().remove(mendDocId);
            HdxContentPoolServiceHandler.getInstance().del(mendDocId);
            LibManageDependency.getInstance().delCustomSortData(mendDocId);
            LibManageDependency.getInstance().deleteDocResourceDir(docId, RESOURCE_TYPE_HDX);
            ZipFilePool.removeAndClose((String)mendHdx.getPath());
        }
        HdxContentPoolServiceHandler.getInstance().del(docId);
    }

    private void delMendHdx(HdxContentDo mendHdx) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delMendHdx by mendHdx");
        if (!mendHdx.getLibType().equals("1")) {
            return;
        }
        String docId = mendHdx.getDocId();
        LibManageDependency.getInstance().deleteHdxIndex(docId);
        LibManageDependency.getInstance().remove(docId);
        HdxContentPoolServiceHandler.getInstance().del(docId);
        LibManageDependency.getInstance().deleteDocResourceDir(docId, RESOURCE_TYPE_HDX);
    }

    private void delExtendHdx(HdxContentDo extendHdx) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delExtendHdx by extendHdx");
        if (!extendHdx.getLibType().equals("2")) {
            return;
        }
        String docId = extendHdx.getDocId();
        LibManageDependency.getInstance().deleteHdxIndex(docId);
        LibManageDependency.getInstance().remove(docId);
        HdxContentPoolServiceHandler.getInstance().del(docId);
        this.updateWithDelExtend(extendHdx);
        LibManageDependency.getInstance().deleteDocResourceDir(docId, RESOURCE_TYPE_HDX);
    }

    private void updateWithDelExtend(HdxContentDo extendHdx) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "updateWithDelExtend by extendHdx");
        HashSet<String> docIdSet = new HashSet<String>();
        this.updateHdxFromExtend(extendHdx, docIdSet);
    }

    @Override
    public HdxContentDo getHdx(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getHdx, docId: " + docId);
        if (docId != null) {
            return HdxContentPoolServiceHandler.getInstance().get(docId);
        }
        return null;
    }

    @Override
    public HdxContentDo getByPath(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "filePath isEmpty ");
            return null;
        }
        return HdxContentPoolServiceHandler.getInstance().getByPath(filePath);
    }

    @Override
    public Collection<LibResponseDto> getAll(String productName, String productVer) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllHdx, productName: ", new Object[]{productName, " productVer:", productVer});
        return LibResponseConverter.INSTANCE.domainHdx(HdxContentPoolServiceHandler.getInstance().getAll(productName, productVer));
    }

    @Override
    public int hdxSize() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "hdxSize");
        return HdxContentPoolServiceHandler.getInstance().size();
    }

    @Override
    public int hdxSize(String productName, String productVer) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "hdxSize, productName{0} ,productVer{1}", new Object[]{productName, productVer});
        return HdxContentPoolServiceHandler.getInstance().size(productName, productVer);
    }

    @Override
    public int oldSize() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "icsSize");
        return HdxContentPoolServiceHandler.getInstance().oldSize();
    }

    @Override
    public void getAllProduct(Map<String, Set<String>> map) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllProduct");
        HdxContentPoolServiceHandler.getInstance().getAllProduct(map);
    }

    @Override
    public List<HdxContentDo> getHdxOldAll(int start, int len) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getHdxOldAll");
        return HdxContentPoolServiceHandler.getInstance().getAllOld(start, len);
    }

    @Override
    public Set<String> getAllDocId() {
        return HdxContentPoolServiceHandler.getInstance().getAllDocId();
    }

    @Override
    public boolean setUpdate(String docId, boolean bUpdate) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is Empty ");
            return false;
        }
        return HdxContentPoolServiceHandler.getInstance().setUpdate(docId, bUpdate);
    }

    @Override
    public void updateHdxLibData() {
        HdxContentPoolServiceHandler.getInstance().updateHdxLibData();
    }

    @Override
    public void updateVerify(String docId, String verifyResult) {
        HdxContentPoolServiceHandler.getInstance().updateVerify(docId, verifyResult);
    }

    @Override
    public HdxContentDo getHdxByVerify() {
        return HdxContentPoolServiceHandler.getInstance().getByVerify("Undefined");
    }

    @Override
    public void updateAllVerify(String oldVerify, String newVerify) {
        HdxContentPoolServiceHandler.getInstance().updateAllVerify(oldVerify, newVerify);
    }

    @Override
    public void initPool() {
        HdxContentPoolServiceHandler.getInstance().initPool();
    }

    @Override
    public boolean setIndexProgress(String docId, String indexProgress) {
        HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
        if (hdxContentDo != null) {
            hdxContentDo.setIndexProgress(indexProgress + "%");
            return true;
        }
        return false;
    }

    private synchronized Optional<HdxContentDo> addHdx(File file, boolean isAddDoubleClick) {
        HdxContentDo hdx = HdxContentPoolServiceHandler.getInstance().create(file);
        String hdxFilePath = IcsFileUtils.getCanonicalPath((File)file);
        if (hdx == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "addHdx: add(f) is null.");
            this.hdxLibNonComplianceHandler(hdxFilePath, isAddDoubleClick);
            return Optional.empty();
        }
        hdx.setbUse(false);
        return this.addHdxContentDo(file, isAddDoubleClick, hdx);
    }

    private void hdxLibNonComplianceHandler(String hdxFilePath, boolean isAddDoubleClick) {
        this.addPool(hdxFilePath, "1");
        if (!isAddDoubleClick) {
            return;
        }
        this.eventBus.post((Object)new DoubleClickSceneMessage("1", hdxFilePath));
        IcsCommonServiceHandler.getInstance().setDoubleClickLibPath("");
    }

    private Optional<HdxContentDo> addHdxContentDo(File file, boolean isAddDoubleClick, HdxContentDo hdx) {
        boolean isCheck = this.libLoadCheck(hdx, file, isAddDoubleClick);
        if (!isCheck) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "addHdx: add(f) is null.");
            return Optional.empty();
        }
        if (HdxContentPoolServiceHandler.getInstance().add(hdx)) {
            if (isAddDoubleClick) {
                IcsCommonServiceHandler.getInstance().setDoubleClickLibPathPool(hdx.getPath(), hdx.getDocId());
                CodeCCUtils.INSTANCE.infoLog(LOG, "setDoubleClickLibPathPool  success. name: {0}", new Object[]{hdx.getDocId() + "_" + hdx.getLibName()});
            } else {
                CodeCCUtils.INSTANCE.infoLog(LOG, "[content] add hdx lib success, the libPath is {0}, the docId is {1}.", new Object[]{hdx.getPath(), hdx.getDocId()});
            }
            return Optional.ofNullable(hdx);
        }
        return Optional.empty();
    }

    private boolean libLoadCheck(HdxContentDo hdxContentDo, File hdxFile, boolean isDoubleClick) {
        String hdxFileName = hdxFile.getName();
        String hdxFilePath = hdxContentDo.getPath();
        if (!HdxContentDaoHandler.getInstance().checkAtr(hdxContentDo, hdxFileName)) {
            this.hdxLibNonComplianceHandler(hdxFilePath, isDoubleClick);
            return false;
        }
        if (HdxContentPoolServiceHandler.getInstance().findHdx(hdxContentDo)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, String.format(Locale.ENGLISH, "The project has the same HDX properties file,which is : {0}", hdxFileName));
            if (isDoubleClick) {
                IcsCommonServiceHandler.getInstance().setDoubleClickLibPathPool(hdxContentDo.getPath(), hdxContentDo.getDocId());
                CodeCCUtils.INSTANCE.infoLog(LOG, "setDoubleClickLibPathPool  success. name: {0}", new Object[]{hdxContentDo.getDocId() + "_" + hdxContentDo.getLibName()});
                this.eventBus.post((Object)new DoubleClickSceneMessage("0", hdxFilePath));
            }
            this.addPool(hdxFilePath, "0");
            return false;
        }
        return true;
    }

    private static class HdxManageServiceHandlerHolder {
        private static final HdxManageServiceHandler INSTANCE = new HdxManageServiceHandler();

        private HdxManageServiceHandlerHolder() {
        }
    }
}

