/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.libmanage.serviceimpl;

import com.alibaba.fastjson.JSON;
import com.google.common.eventbus.AsyncEventBus;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.docnav.constant.IcsDocnavConstants;
import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.docnav.service.impl.IcsDocnavPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icspid.service.impl.IcsPidPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.service.impl.IcsVersionRelationPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaNameDo;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaValueDo;
import com.huawei.support.icscbb.hwics.common.meta.service.impl.IcsMetaNamePoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.meta.service.impl.IcsMetaValuePoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.libentity.dto.IcsBaseDo;
import com.huawei.support.icscbb.util.pool.BasePool;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icslite.business.docnav.serviceimpl.IcsDocnavBusinessServiceHandler;
import com.huawei.support.icslite.business.doubleclicklib.entity.message.DoubleClickSceneMessage;
import com.huawei.support.icslite.business.ics.content.dto.IcsContentDto;
import com.huawei.support.icslite.business.ics.content.dto.mapper.IcsContentDtoConverter;
import com.huawei.support.icslite.business.libmanage.constant.LibManageContants;
import com.huawei.support.icslite.business.libmanage.dependency.LibManageDependency;
import com.huawei.support.icslite.business.libmanage.dto.LibResponseDto;
import com.huawei.support.icslite.business.libmanage.mapper.LibResponseConverter;
import com.huawei.support.icslite.business.libmanage.service.IcsManageService;
import com.huawei.support.icslite.business.search.serviceimpl.IcsSearchSuggestBusinessHander;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.docnote.dto.DocNoteDo;
import com.huawei.support.icslite.docnote.service.impl.DocNoteServiceHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsManageServiceHandler
extends BasePool<String>
implements IcsManageService,
IcsDocnavConstants,
LibManageContants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsManageServiceHandler.class);
    private static final String RESOURCE_TYPE_ICS = "ics";
    private final AsyncEventBus eventBus = EventBusUtils.INSTANCE.getEventBus();

    private IcsManageServiceHandler() {
    }

    public static IcsManageServiceHandler getInstance() {
        return IcsManageServiceHandlerHolder.INSTANCE;
    }

    protected void createPool(String key) {
    }

    protected void addPool(String key, String value) {
        if (this.objectMap.containsKey(key)) {
            return;
        }
        super.addPool(key, (Object)value);
    }

    public String getPool(String key) {
        return (String)super.getPool(key);
    }

    @Override
    public void createTb() {
        IcsContentPoolServiceHandler.getInstance().createTb();
        IcsContentPoolServiceHandler.getInstance().createLastOldTb();
        IcsContentPoolServiceHandler.getInstance().createOldTb();
        IcsMetaNamePoolServiceHandler.getInstance().createTb();
        IcsMetaValuePoolServiceHandler.getInstance().createTb();
        IcsPidPoolServiceHandler.getInstance().createTb();
        IcsDocnavPoolServiceHandler.getInstance().createTb();
        IcsVersionRelationPoolServiceHandler.getInstance().createTb();
    }

    @Override
    public synchronized Optional<IcsContentDo> addIcs(File file) {
        return this.addIcsWhenDifferWayLoad(file, false);
    }

    @Override
    public synchronized Optional<IcsContentDo> addDoubleClickIcs(File file) {
        return this.addIcsWhenDifferWayLoad(file, true);
    }

    private synchronized Optional<IcsContentDo> addIcsWhenDifferWayLoad(File file, boolean isDoubleClick) {
        IcsContentDo icsContent = IcsContentPoolServiceHandler.getInstance().create(file);
        String icsFilePath = IcsFileUtils.getCanonicalPath((File)file);
        String icsFileName = file.getName();
        if (icsContent == null) {
            this.icsLibNonComplianceHandler(isDoubleClick, icsFilePath);
            return Optional.empty();
        }
        icsFilePath = icsContent.getPath();
        boolean isLoaded = this.findIcs(icsContent);
        if (icsContent.isFlag() && isLoaded) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The same file is : {0} .", new Object[]{icsFileName});
            this.icsLibRepeatsHandler(isDoubleClick, icsContent, icsFilePath);
            return Optional.empty();
        }
        if (!this.addIcsLib(file, isDoubleClick, icsContent, isLoaded)) {
            return Optional.empty();
        }
        if (!icsContent.isFlag()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "addIcsWhenDifferWayLoad : add(f) is null. file: {0}", new Object[]{icsFileName});
            this.icsLibNonComplianceHandler(isDoubleClick, icsFilePath);
            return Optional.empty();
        }
        return Optional.ofNullable(icsContent);
    }

    private void icsLibRepeatsHandler(boolean isDoubleClick, IcsContentDo icsContent, String icsFilePath) {
        this.addPool(icsFilePath, "0");
        if (isDoubleClick) {
            this.addRealIcsDocIdInDoubleClickPool(icsContent);
            this.eventBus.post((Object)new DoubleClickSceneMessage("0", icsFilePath));
        }
    }

    private boolean addIcsLib(File icsFile, boolean isDoubleClick, IcsContentDo icsContentDo, boolean isLoaded) {
        if (isLoaded || !icsContentDo.isFlag()) {
            return true;
        }
        String docId = icsContentDo.getDocId();
        String icsFilePath = icsContentDo.getPath();
        if (!this.addOtherData(icsContentDo)) {
            this.rollBackData(docId, icsFile.getName());
            this.icsLibNonComplianceHandler(isDoubleClick, icsFilePath);
            return false;
        }
        if (!IcsContentPoolServiceHandler.getInstance().add(icsContentDo)) {
            this.rollBackData(docId, icsFile.getName());
            this.icsLibNonComplianceHandler(isDoubleClick, icsFilePath);
            return false;
        }
        if (isDoubleClick) {
            IcsCommonServiceHandler.getInstance().setDoubleClickLibPathPool(icsFilePath, docId);
            CodeCCUtils.INSTANCE.infoLog(LOG, "setDoubleClickLibPathPool  success. name: {0}", new Object[]{docId + "_" + icsContentDo.getLibName()});
        }
        this.libLoadedThirdModuleHandler(icsContentDo);
        if (isDoubleClick) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "[content] add ics lib success, double click load, the libPath is {0}, the docId is {1}.", new Object[]{icsFilePath, docId});
        } else {
            CodeCCUtils.INSTANCE.infoLog(LOG, "[content] add ics lib success, the libPath is {0}, the docId is {1}.", new Object[]{icsFilePath, docId});
        }
        return true;
    }

    private void libLoadedThirdModuleHandler(IcsContentDo icsContentDo) {
        String docId = icsContentDo.getDocId();
        LibManageDependency.getInstance().initIcsNavi(icsContentDo);
        LibManageDependency.getInstance().createIcsIndex(docId);
        IcsSearchSuggestBusinessHander.getInstance().deleteCachedSuggestWords(docId);
        LibManageDependency.getInstance().generateIcsFilterHtmlPieces(docId);
        DocNoteServiceHandler.getInstance().updateIcsFlag(this.createDocNoteDo(IcsContentDtoConverter.INSTANCE.domainDto(icsContentDo), "0"));
    }

    private void icsLibNonComplianceHandler(boolean isDoubleClick, String icsFilePath) {
        this.addPool(icsFilePath, "2");
        if (!isDoubleClick) {
            return;
        }
        this.eventBus.post((Object)new DoubleClickSceneMessage("2", icsFilePath));
        IcsCommonServiceHandler.getInstance().setDoubleClickLibPath("");
    }

    private void rollBackData(String docId, String fileName) {
        this.delIcsObject(docId);
        CodeCCUtils.INSTANCE.errorLog(LOG, "addIcsWhenDifferWayLoad: add(f) is null. file: {0}", new Object[]{fileName});
    }

    private void addRealIcsDocIdInDoubleClickPool(IcsContentDo ics) {
        if (IcsCommonServiceHandler.getInstance().getDoubleClickLibPathPool().containsKey(ics.getPath())) {
            return;
        }
        List icsList = IcsContentPoolServiceHandler.getInstance().getIcsList(Collections.singletonList(ics));
        if (CollectionUtils.isEmpty((Collection)icsList)) {
            return;
        }
        IcsContentDo icsContentDo = (IcsContentDo)icsList.get(0);
        if (this.isSameIcs(ics, icsContentDo)) {
            IcsCommonServiceHandler.getInstance().setDoubleClickLibPathPool(ics.getPath(), icsContentDo.getDocId());
            CodeCCUtils.INSTANCE.infoLog(LOG, "setDoubleClickLibPathPool  success. name: {0}", new Object[]{ics.getDocId() + "_" + ics.getLibName()});
        }
    }

    private boolean isSameIcs(IcsContentDo icsContentDoOne, IcsContentDo icsContentDoTwo) {
        return BooleanUtils.and((boolean[])new boolean[]{StringUtils.equals((CharSequence)icsContentDoOne.getProjectid(), (CharSequence)icsContentDoTwo.getProjectid()), StringUtils.equals((CharSequence)icsContentDoOne.getLibV(), (CharSequence)icsContentDoTwo.getLibV()), StringUtils.equals((CharSequence)icsContentDoOne.getIssueDate(), (CharSequence)icsContentDoTwo.getIssueDate())});
    }

    private boolean addOtherData(IcsContentDo icsContentDo) {
        boolean isSuccess = BooleanUtils.and((boolean[])new boolean[]{IcsMetaNamePoolServiceHandler.getInstance().add((IcsBaseDo)icsContentDo), IcsMetaValuePoolServiceHandler.getInstance().add((IcsBaseDo)icsContentDo), IcsVersionRelationPoolServiceHandler.getInstance().add((IcsBaseDo)icsContentDo), IcsPidPoolServiceHandler.getInstance().add(IcsPidPoolServiceHandler.getInstance().create((IcsBaseDo)icsContentDo))});
        if (BooleanUtils.isFalse((Boolean)isSuccess)) {
            return false;
        }
        List icsDocnavList = IcsDocnavPoolServiceHandler.getInstance().create((IcsBaseDo)icsContentDo);
        this.docnavDatafromMeta(icsDocnavList);
        return IcsDocnavPoolServiceHandler.getInstance().add(icsDocnavList);
    }

    private void docnavDatafromMeta(List<IcsDocnavDo> icsDocnavList) {
        for (IcsDocnavDo docnav : icsDocnavList) {
            this.docnavDatafromMeta(docnav);
            docnav.setFilterJson(JSON.toJSONString((Object)docnav.getFilterList()));
            docnav.getFilterList().clear();
        }
    }

    private void docnavDatafromMeta(IcsDocnavDo docnav) {
        List filterList = docnav.getFilterList();
        for (Map filterMap : filterList) {
            this.docnavDatafromMeta(filterMap, docnav.getDocId());
        }
    }

    private void docnavDatafromMeta(Map<String, String> filterMap, String docId) {
        String metanameId = filterMap.get("metanameid");
        String filterName = filterMap.get("name");
        String metaValueIdlist = filterMap.get("metalist");
        LinkedHashMap<String, String> metaValueMap = new LinkedHashMap<String, String>();
        if (filterName == null) {
            String metaName = this.getMetaName(docId, metanameId);
            if (metaName == null) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "setTag error. name : null.");
                return;
            }
            filterMap.put("name", metaName);
        }
        if (metaValueIdlist == null) {
            this.filterfromMetaName(metaValueMap, docId, metanameId);
        } else {
            this.filterFromMetaValue(metaValueMap, docId, metaValueIdlist);
        }
        filterMap.put("metavalueidlist", JSON.toJSONString(metaValueMap));
    }

    private void filterfromMetaName(Map<String, String> metaValueMap, String docId, String metanameId) {
        List<IcsMetaValueDo> metaValueList = this.getMetaValueByMetaNameId(docId, metanameId);
        for (IcsMetaValueDo icsMetaValueDto : metaValueList) {
            metaValueMap.put(icsMetaValueDto.getMetaValueId(), icsMetaValueDto.getMetaValue());
        }
    }

    private void filterFromMetaValue(Map<String, String> metaValueMap, String docId, String metaValueIdlist) {
        String[] metaValueIds;
        for (String metaValueId : metaValueIds = metaValueIdlist.trim().split(";")) {
            Optional<IcsMetaValueDo> icsMetaValueDtoOpt = this.getMetaValue(docId, metaValueId);
            if (!icsMetaValueDtoOpt.isPresent()) continue;
            IcsMetaValueDo icsMetaValueDo = icsMetaValueDtoOpt.get();
            metaValueMap.put(icsMetaValueDo.getMetaValueId(), icsMetaValueDo.getMetaValue());
        }
    }

    private Optional<IcsMetaValueDo> getMetaValue(String docId, String metaValueId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getMetaValue, docId: " + docId + ",metaValueId:" + metaValueId);
        if (docId == null || metaValueId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or metaValueId is null.");
            return Optional.empty();
        }
        return Optional.ofNullable(IcsMetaValuePoolServiceHandler.getInstance().get(docId, metaValueId));
    }

    private List<IcsMetaValueDo> getMetaValueByMetaNameId(String docId, String metaNameId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getMetaValueByMetaNameId, docId: " + docId + ",metaNameId:" + metaNameId);
        ArrayList<IcsMetaValueDo> icsMetaValueList = new ArrayList<IcsMetaValueDo>();
        if (docId == null || metaNameId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or metaNameId is null.");
            return icsMetaValueList;
        }
        icsMetaValueList.addAll(IcsMetaValuePoolServiceHandler.getInstance().getByMetaNameId(docId, metaNameId));
        return icsMetaValueList;
    }

    private String getMetaName(String docId, String metanameId) {
        IcsMetaNameDo icsMetaNameDo = IcsMetaNamePoolServiceHandler.getInstance().get(docId, metanameId);
        return icsMetaNameDo == null ? null : icsMetaNameDo.getMetaName();
    }

    @Override
    public boolean findIcs(IcsContentDo ics) {
        return IcsContentPoolServiceHandler.getInstance().findIcs((IcsBaseDo)ics);
    }

    @Override
    public String getFileName(String docId) {
        IcsContentDo ics = IcsContentPoolServiceHandler.getInstance().get(docId);
        if (ics == null) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "ics is null.");
            return null;
        }
        String path = ics.getPath();
        if (path == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "icsLibPath is null.");
            return null;
        }
        File file = FileUtils.getFile((String[])new String[]{path});
        if (!file.isFile()) {
            return null;
        }
        return file.getName();
    }

    @Override
    public synchronized boolean del(String docId) {
        return this.delReturnFail(docId) == null;
    }

    @Override
    public synchronized IcsContentDto delReturnFail(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delIcs, docId: " + docId);
        if (docId == null) {
            return null;
        }
        IcsContentDto ics = this.delIcsObject(docId);
        if (ics == null) {
            return null;
        }
        this.updateVersionrelation(ics);
        boolean isSuccess = IcsFileUtils.delFile((String)ics.getPath());
        if (isSuccess) {
            OperationLogUtils.INSTANCE.successOperationLog("icslite-business-service", "DELETE", "delIcs success. docId:{0}", new Object[]{docId});
            return null;
        }
        return ics;
    }

    @Override
    public IcsContentDto delIcsObject(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delIcsObject, docId: " + docId);
        if (docId == null) {
            return null;
        }
        IcsContentDto ics = this.getIcs(docId);
        if (ics != null) {
            ics.setbUse(false);
        }
        LibManageDependency.getInstance().deleteIcsIndex(docId);
        LibManageDependency.getInstance().deleteByDocId(docId);
        IcsMetaNamePoolServiceHandler.getInstance().del(docId);
        IcsMetaValuePoolServiceHandler.getInstance().del(docId);
        IcsDocnavPoolServiceHandler.getInstance().del(docId);
        IcsPidPoolServiceHandler.getInstance().del(docId);
        IcsSearchSuggestBusinessHander.getInstance().deleteCachedSuggestWords(docId);
        IcsVersionRelationPoolServiceHandler.getInstance().del(docId);
        LibManageDependency.getInstance().deleteDocResourceDir(docId, RESOURCE_TYPE_ICS);
        if (ics != null) {
            IcsContentPoolServiceHandler.getInstance().del(docId);
            LibManageDependency.getInstance().delCustomSortData(docId);
            String path = ics.getPath();
            ZipFilePool.removeAndClose((String)path);
            DocNoteServiceHandler.getInstance().updateIcsFlag(this.createDocNoteDo(ics, "1"));
        }
        return ics;
    }

    private DocNoteDo createDocNoteDo(IcsContentDto icsContentDto, String deleteFlag) {
        return new DocNoteDo().setProjectId(icsContentDto.getProjectid()).setLibV((String)StringUtils.defaultIfBlank((CharSequence)icsContentDto.getLibV(), (CharSequence)"")).setIssueDate(icsContentDto.getIssueDate()).setLang(icsContentDto.getLang()).setDeleteFlag(deleteFlag);
    }

    @Override
    public IcsContentDto getIcs(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getIcs, docId: " + docId);
        if (docId != null) {
            return IcsContentDtoConverter.INSTANCE.domainDto(IcsContentPoolServiceHandler.getInstance().get(docId));
        }
        return null;
    }

    @Override
    public Collection<LibResponseDto> getAll(String productName, String productVer) {
        CodeCCUtils.INSTANCE.debugLog(LOG, String.format(Locale.ENGLISH, "getAllIcs, productName:%s ,productVer:%s", productName, productVer));
        return LibResponseConverter.INSTANCE.domainIcs(IcsContentPoolServiceHandler.getInstance().getAll(productName, productVer));
    }

    @Override
    public int icsSize(String productName, String productVer) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "icsSize");
        if (productName == null || productVer == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "productName or productVer is null.");
            return 0;
        }
        return IcsContentPoolServiceHandler.getInstance().icsSize(productName, productVer);
    }

    @Override
    public int icsOldSize() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "icsSize");
        return IcsContentPoolServiceHandler.getInstance().icsOldSize();
    }

    @Override
    public void getAllProduct(Map<String, Set<String>> map) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllProduct");
        IcsContentPoolServiceHandler.getInstance().getAllProduct(map);
    }

    @Override
    public Set<String> getAllDocId() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllDocId");
        return new HashSet<String>(IcsContentPoolServiceHandler.getInstance().getAllDocId());
    }

    @Override
    public void updateVersionrelation(Set<String> updateLibSet) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "updateVersionrelation");
        if (updateLibSet == null) {
            return;
        }
        LinkedHashSet<String> libSet = new LinkedHashSet<String>(updateLibSet);
        for (String docId : libSet) {
            IcsDocnavBusinessServiceHandler.getInstance().delTreeAndPidPool(docId);
            IcsVersionRelationPoolServiceHandler.getInstance().delVersionRelationPool(docId);
            LibManageDependency.getInstance().updateMainDocPids(docId);
        }
        LibManageDependency.getInstance().batchAddIndex(libSet);
    }

    @Override
    public void updateVersionrelation(IcsContentDto ics) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "updateVersionrelation");
        LinkedHashSet<String> updateLibSet = new LinkedHashSet<String>();
        if (ics == null) {
            return;
        }
        this.getDocIdFromVersionrelation(ics.getDocId(), updateLibSet);
        updateLibSet.addAll(this.getDocIdFromVersionrelation(ics.getProjectid(), ics.getProductV(), ics.getLang()));
        this.updateVersionrelation(updateLibSet);
    }

    @Override
    public void getDocIdFromVersionrelation(String docId, Set<String> updateLibSet) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getDocIdFromVersionrelation");
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return;
        }
        String mainDocId = IcsVersionRelationPoolServiceHandler.getInstance().getMainDocId(docId);
        if (mainDocId != null) {
            updateLibSet.add(mainDocId);
        }
    }

    @Override
    public List<String> getDocIdFromVersionrelation(String projectid, String productversion, String lang) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getDocIdFromVersionrelation");
        ArrayList<String> list = new ArrayList<String>();
        if (projectid == null || productversion == null || lang == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Either projectid, productversion, or lang is empty.");
            return list;
        }
        list.addAll(IcsVersionRelationPoolServiceHandler.getInstance().getDocIdByProjectidAndVer(projectid, productversion, lang));
        return list;
    }

    @Override
    public List<IcsContentDo> getIcsOldAll(int start, int len) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getIcsOldAll");
        return IcsContentPoolServiceHandler.getInstance().getOldAll(start, len);
    }

    @Override
    public boolean setUpdate(String docId, boolean isUpdate) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is Empty ");
            return false;
        }
        return IcsContentPoolServiceHandler.getInstance().setUpdate(docId, isUpdate);
    }

    @Override
    public IcsContentDo getByPath(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "filePath isEmpty ");
            return null;
        }
        return IcsContentPoolServiceHandler.getInstance().getByPath(filePath);
    }

    @Override
    public IcsContentDo getIcsByVerify() {
        return IcsContentPoolServiceHandler.getInstance().getByVerify("Undefined");
    }

    @Override
    public void updateIcsLibData() {
        IcsContentPoolServiceHandler.getInstance().updateIcsLibData();
    }

    @Override
    public void updateVerify(String docId, String verifyResult) {
        IcsContentPoolServiceHandler.getInstance().updateVerify(docId, verifyResult);
    }

    @Override
    public void updateAllVerify(String oldVerify, String newVerify) {
        IcsContentPoolServiceHandler.getInstance().updateAllVerify(oldVerify, newVerify);
    }

    @Override
    public void initPool() {
        IcsContentPoolServiceHandler.getInstance().initPool();
    }

    @Override
    public IcsContentDo getIcsDo(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getHdx, docId: " + docId);
        if (docId != null) {
            return IcsContentPoolServiceHandler.getInstance().get(docId);
        }
        return null;
    }

    @Override
    public boolean setIndexProgress(String docId, String indexProgress) {
        IcsContentDo icsContentDo = IcsContentPoolServiceHandler.getInstance().get(docId);
        if (icsContentDo != null) {
            icsContentDo.setIndexProgress(indexProgress + "%");
            return true;
        }
        return false;
    }

    private static class IcsManageServiceHandlerHolder {
        private static final IcsManageServiceHandler INSTANCE = new IcsManageServiceHandler();

        private IcsManageServiceHandlerHolder() {
        }
    }
}

