/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.libmanage.serviceimpl;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.LibBaseDo;
import com.huawei.support.icslite.business.customsort.util.DocFilterUtils;
import com.huawei.support.icslite.business.ics.content.dto.mapper.IcsContentDtoConverter;
import com.huawei.support.icslite.business.libmanage.constant.LibManageContants;
import com.huawei.support.icslite.business.libmanage.dependency.LibManageDependency;
import com.huawei.support.icslite.business.libmanage.dto.FilterParamDto;
import com.huawei.support.icslite.business.libmanage.dto.LibDeleteFailDto;
import com.huawei.support.icslite.business.libmanage.dto.LibResponseDto;
import com.huawei.support.icslite.business.libmanage.mapper.LibResponseConverter;
import com.huawei.support.icslite.business.libmanage.service.LibManageService;
import com.huawei.support.icslite.business.libmanage.serviceimpl.HdxManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.serviceimpl.IcsManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.task.LibManageInitTask;
import com.huawei.support.icslite.business.libmanage.task.builder.impl.LibLoadPathBuilder;
import com.huawei.support.icslite.business.libmanage.task.director.LibManageDirector;
import com.huawei.support.icslite.business.libmanage.utils.CommonLibManageUtils;
import com.huawei.support.icslite.business.preferences.serviceimpl.DocumentSettingServiceHandler;
import com.huawei.support.icslite.business.upgradelib.service.impl.UpgradeLibBusinessHandler;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.common.utils.LibMsgShowUtils;
import com.huawei.support.icslite.customsort.dto.CustomSortDo;
import com.huawei.support.icslite.customsort.service.impl.CustomSortServiceHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class LibManageServiceHandler
implements LibManageService,
LibManageContants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(LibManageServiceHandler.class);

    private LibManageServiceHandler() {
    }

    public static LibManageServiceHandler getInstance() {
        return LibManageServiceHandlerHolder.INSTANCE;
    }

    @Override
    public void createTb() {
        IcsManageServiceHandler.getInstance().createTb();
        HdxManageServiceHandler.getInstance().createTb();
    }

    @Override
    public void init() {
        HdxManageServiceHandler.getInstance().initPool();
        IcsManageServiceHandler.getInstance().initPool();
        LibManageInitTask.getInstance().start();
    }

    @Override
    public void reInit() {
        LibManageInitTask.getInstance().toStart();
    }

    @Override
    public boolean getInitState() {
        return LibManageInitTask.getInstance().isUse();
    }

    @Override
    public int getLoadLibSize() {
        LibManageDirector libManageDirector = LibManageDirector.getInstance();
        libManageDirector.construct(LibLoadPathBuilder.getInstance());
        return libManageDirector.getLoadLibSize();
    }

    @Override
    public Set<String> getAllDocId() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllDocId");
        HashSet<String> docidSet = new HashSet<String>();
        docidSet.addAll(HdxManageServiceHandler.getInstance().getAllDocId());
        docidSet.addAll(IcsManageServiceHandler.getInstance().getAllDocId());
        return docidSet;
    }

    @Override
    public Set<String> getDocIdforContent() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getDocIdforContent");
        HashSet<String> docidSet = new HashSet<String>();
        docidSet.addAll(IcsManageServiceHandler.getInstance().getAllDocId());
        docidSet.addAll(HdxManageServiceHandler.getInstance().getAllDocId());
        return docidSet;
    }

    @Override
    public String getIcsLiteDefaultSettingPath() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getIcsLiteDefaultSettingPath");
        return DocumentSettingServiceHandler.getInstance().getIcsLiteDefaultSettingPath();
    }

    @Override
    public List<String> getIcsLiteMultiPath() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getIcsLiteMultiPath");
        return DocumentSettingServiceHandler.getInstance().getIcsLiteMultiPath();
    }

    @Override
    public void getAllProduct(Map<String, Set<String>> map) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getAllProduct");
        IcsManageServiceHandler.getInstance().getAllProduct(map);
        HdxManageServiceHandler.getInstance().getAllProduct(map);
    }

    @Override
    public int size(String productName, String productVer, FilterParamDto filterParamDto) {
        return (int)DocFilterUtils.filterLib(this.getAllLib(productName, productVer).stream(), filterParamDto).count();
    }

    @Override
    public List<LibResponseDto> getPaginationData(List<LibResponseDto> libDatalist, int start, int len) {
        int fromIndex = start;
        fromIndex = (fromIndex = Math.max(fromIndex, 0)) > libDatalist.size() ? 0 : fromIndex;
        int toIndex = Math.addExact(start, len);
        toIndex = Math.max(toIndex, 0);
        toIndex = Math.min(toIndex, libDatalist.size());
        return libDatalist.subList(fromIndex, toIndex);
    }

    @Override
    public List<LibResponseDto> getAllLib(String productName, String productVer) {
        ArrayList<LibResponseDto> libDatalist = new ArrayList<LibResponseDto>();
        libDatalist.addAll(IcsManageServiceHandler.getInstance().getAll(productName, productVer));
        libDatalist.addAll(HdxManageServiceHandler.getInstance().getAll(productName, productVer));
        for (LibResponseDto libResponseDto : libDatalist) {
            if (!StringUtils.isBlank((CharSequence)libResponseDto.getIndexProgress())) continue;
            libResponseDto.setIndexProgress("0%");
        }
        CommonLibManageUtils.libDataSort(libDatalist);
        return libDatalist;
    }

    @Override
    public String getFileName(String docId) {
        String icsFileName = IcsManageServiceHandler.getInstance().getFileName(docId);
        String hdxFileName = HdxManageServiceHandler.getInstance().getFileName(docId);
        return icsFileName != null ? icsFileName : hdxFileName;
    }

    @Override
    public boolean delLib(String docId) {
        boolean isDelete;
        if (docId.matches("^HDX[\\w\\.\\(\\)\\-\\, ]{1,97}$")) {
            this.delDoubleClickHdxPool(docId);
            isDelete = HdxManageServiceHandler.getInstance().del(docId);
        } else {
            isDelete = IcsManageServiceHandler.getInstance().del(docId);
        }
        LibManageDependency.getInstance().delVerifyTask(docId);
        UpgradeLibBusinessHandler.getInstance().delLibLoadedCache(docId);
        return isDelete;
    }

    @Override
    public LibResponseDto delLibReturnFail(String docId) {
        LibResponseDto libResponseDto;
        if (docId.matches("^HDX[\\w\\.\\(\\)\\-\\, ]{1,97}$")) {
            this.delDoubleClickHdxPool(docId);
            libResponseDto = LibResponseConverter.INSTANCE.domainDto(HdxManageServiceHandler.getInstance().delReturnFail(docId));
        } else {
            libResponseDto = LibResponseConverter.INSTANCE.domainDto(IcsContentDtoConverter.INSTANCE.dtoToDo(IcsManageServiceHandler.getInstance().delReturnFail(docId)));
        }
        LibManageDependency.getInstance().delVerifyTask(docId);
        UpgradeLibBusinessHandler.getInstance().delLibLoadedCache(docId);
        return libResponseDto;
    }

    private void delDoubleClickHdxPool(String docId) {
        HdxContentDo hdx = HdxManageServiceHandler.getInstance().getHdx(docId);
        Map doubleClickLibPathPool = IcsCommonServiceHandler.getInstance().getDoubleClickLibPathPool();
        if (doubleClickLibPathPool.containsValue(docId)) {
            String removeDocId = (String)IcsCommonServiceHandler.getInstance().getDoubleClickLibPathPool().remove(hdx.getPath());
            CodeCCUtils.INSTANCE.infoLog(LOG, "{0} docId lib remove from doubleClickLibPathPool", new Object[]{removeDocId});
        }
    }

    @Override
    public boolean setUpdate(String docId, boolean isUpdate) {
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is Empty ");
            return false;
        }
        boolean isSuccess = docId.matches("^HDX[\\w\\.\\(\\)\\-\\, ]{1,97}$") ? HdxManageServiceHandler.getInstance().setUpdate(docId, isUpdate) : IcsManageServiceHandler.getInstance().setUpdate(docId, isUpdate);
        LibManageDependency.getInstance().setUpDateFlag(docId, isUpdate);
        return isSuccess;
    }

    @Override
    public IcsContentDo getIcsByVerify() {
        return IcsManageServiceHandler.getInstance().getIcsByVerify();
    }

    @Override
    public HdxContentDo getHdxByVerify() {
        return HdxManageServiceHandler.getInstance().getHdxByVerify();
    }

    @Override
    public void updateLibData() {
        IcsManageServiceHandler.getInstance().updateIcsLibData();
        HdxManageServiceHandler.getInstance().updateHdxLibData();
    }

    @Override
    public void updateVerify(String docId, String verifyResult) {
        if (docId.matches("^HDX[\\w\\.\\(\\)\\-\\, ]{1,97}$")) {
            HdxManageServiceHandler.getInstance().updateVerify(docId, verifyResult);
        } else {
            IcsManageServiceHandler.getInstance().updateVerify(docId, verifyResult);
        }
        CustomSortServiceHandler.getInstance().updateVerify(docId, verifyResult);
    }

    @Override
    public void updateAllVerify(String oldVerify, String newVerify) {
        HdxManageServiceHandler.getInstance().updateAllVerify(oldVerify, newVerify);
        IcsManageServiceHandler.getInstance().updateAllVerify(oldVerify, newVerify);
    }

    @Override
    public String getDocIdByPath(String path) {
        File file = FileUtils.getFile((String[])new String[]{path});
        try {
            String fileNewPath = file.getCanonicalPath();
            IcsContentDo icsContentDo = IcsManageServiceHandler.getInstance().getByPath(fileNewPath);
            if (icsContentDo != null) {
                return icsContentDo.getDocId();
            }
            HdxContentDo hdxContentDo = HdxManageServiceHandler.getInstance().getByPath(fileNewPath);
            if (hdxContentDo != null) {
                return hdxContentDo.getDocId();
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "file.getCanonicalPath failed");
        }
        return null;
    }

    @Override
    public boolean delCustomSortData(String docId) {
        return LibManageDependency.getInstance().delCustomSortData(docId);
    }

    @Override
    public boolean addCustomSortData(LibBaseDo libBaseDo, String libType) {
        return LibManageDependency.getInstance().addCustomSortData(libBaseDo, libType);
    }

    @Override
    public void syncCustomSortData() {
        Set<String> docDocIdSet = this.getAllDocId();
        Set<String> customDocIdSet = LibManageDependency.getInstance().getCustomDocId();
        if (CollectionUtils.isEmpty(customDocIdSet) && !CollectionUtils.isEmpty(docDocIdSet)) {
            for (String docId : docDocIdSet) {
                this.getDataAndStash(docId);
            }
            return;
        }
        this.delOldData(docDocIdSet, customDocIdSet);
        customDocIdSet = LibManageDependency.getInstance().getCustomDocId();
        this.addNewData(docDocIdSet, customDocIdSet);
    }

    @Override
    public boolean setIndexProgress(String docId, String indexProgress) {
        if (docId.matches("^HDX[\\w\\.\\(\\)\\-\\, ]{1,97}$")) {
            return HdxManageServiceHandler.getInstance().setIndexProgress(docId, indexProgress);
        }
        return IcsManageServiceHandler.getInstance().setIndexProgress(docId, indexProgress);
    }

    @Override
    public List<String> delByDocIdList(List<String> docIdList) {
        ArrayList<String> delFailedIdList = new ArrayList<String>();
        for (String docId : docIdList) {
            boolean delResult = this.delLib(docId);
            if (delResult) continue;
            CodeCCUtils.INSTANCE.warnLog(LOG, "delByDocIdList by docId,{0}", new Object[]{docId});
            delFailedIdList.add(docId);
        }
        return delFailedIdList;
    }

    @Override
    public List<LibDeleteFailDto> delByDocIds(List<String> docIds) {
        ArrayList<LibResponseDto> libResponseDtos = new ArrayList<LibResponseDto>();
        for (String docId : docIds) {
            LibResponseDto libResponseDto = this.delLibReturnFail(docId);
            if (libResponseDto == null) continue;
            libResponseDtos.add(libResponseDto);
        }
        if (CollectionUtils.isEmpty(libResponseDtos)) {
            return Collections.emptyList();
        }
        return this.getLibDeleteFailDtoByDocIds(libResponseDtos);
    }

    @Override
    public String getLibLoadErrorCodeByPath(String loadedLibPath) {
        String hdxErrorCode = HdxManageServiceHandler.getInstance().getPool(loadedLibPath);
        return StringUtils.isBlank((CharSequence)hdxErrorCode) ? IcsManageServiceHandler.getInstance().getPool(loadedLibPath) : hdxErrorCode;
    }

    private void delOldData(Set<String> docDocIdSet, Set<String> customDocIdSet) {
        for (String docId : customDocIdSet) {
            List<CustomSortDo> customSortDoList;
            if (!docDocIdSet.contains(docId)) {
                this.delCustomSortData(docId);
            }
            if ((customSortDoList = LibManageDependency.getInstance().getCustomDoList(docId)).size() > 1) {
                this.delCustomSortData(docId);
            }
            this.updateIndexProgressAndVerify(docId);
        }
    }

    private void addNewData(Set<String> docDocIdSet, Set<String> customDocIdSet) {
        for (String docId : docDocIdSet) {
            if (customDocIdSet.contains(docId)) continue;
            this.getDataAndStash(docId);
        }
    }

    private void getDataAndStash(String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is blank");
            return;
        }
        if (docId.matches("^HDX[\\w\\.\\(\\)\\-\\, ]{1,97}$")) {
            this.addHdxData(docId);
        } else {
            this.addIcsData(docId);
        }
    }

    private void addHdxData(String docId) {
        HdxContentDo hdx = HdxManageServiceHandler.getInstance().getHdx(docId);
        if (hdx == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "hdx is null. docId{0}" + docId);
            return;
        }
        if (StringUtils.equals((CharSequence)hdx.getState(), (CharSequence)"Load error")) {
            return;
        }
        this.addCustomSortData((LibBaseDo)hdx, hdx.getType());
    }

    private void addIcsData(String docId) {
        IcsContentDo ics = IcsManageServiceHandler.getInstance().getIcsDo(docId);
        if (ics == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "ics is null. docId{0}" + docId);
            return;
        }
        if (StringUtils.equals((CharSequence)ics.getState(), (CharSequence)"Load error")) {
            return;
        }
        this.addCustomSortData((LibBaseDo)ics, ics.getType());
    }

    private void updateIndexProgressAndVerify(String docId) {
        if (docId.matches("^HDX[\\w\\.\\(\\)\\-\\, ]{1,97}$")) {
            HdxContentDo hdx = HdxManageServiceHandler.getInstance().getHdx(docId);
            CustomSortServiceHandler.getInstance().updateIndexProgress(docId, hdx.getIndexProgress());
            CustomSortServiceHandler.getInstance().updateVerify(docId, hdx.getVerify());
        } else {
            IcsContentDo ics = IcsManageServiceHandler.getInstance().getIcsDo(docId);
            CustomSortServiceHandler.getInstance().updateIndexProgress(docId, ics.getIndexProgress());
            CustomSortServiceHandler.getInstance().updateVerify(docId, ics.getVerify());
        }
    }

    private List<LibDeleteFailDto> getLibDeleteFailDtoByDocIds(List<LibResponseDto> libResponseDtos) {
        CommonLibManageUtils.libDataSort(libResponseDtos);
        ArrayList<LibDeleteFailDto> delFailedDtos = new ArrayList<LibDeleteFailDto>();
        for (LibResponseDto libResponseDto : libResponseDtos) {
            LibDeleteFailDto libDeleteFailDto = new LibDeleteFailDto();
            String libVersion = (String)StringUtils.defaultIfBlank((CharSequence)libResponseDto.getLibV(), (CharSequence)"");
            libDeleteFailDto.setVersion(LibMsgShowUtils.getPageVersionInformation((String)libResponseDto.getProductV(), (String)libVersion, (String)LibMsgShowUtils.getFormatIssueDate((String)libResponseDto.getIssueDate())));
            libDeleteFailDto.setLibName(libResponseDto.getLibName());
            delFailedDtos.add(libDeleteFailDto);
        }
        return delFailedDtos;
    }

    private static class LibManageServiceHandlerHolder {
        private static final LibManageServiceHandler INSTANCE = new LibManageServiceHandler();

        private LibManageServiceHandlerHolder() {
        }
    }
}

