/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.libmanage.task;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.libmanage.task.builder.impl.LibLoadPathBuilder;
import com.huawei.support.icslite.business.libmanage.task.director.LibManageDirector;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LibManageInitTask
extends Thread {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(LibManageInitTask.class);
    private volatile boolean isUsed = true;
    private final Lock libManageLock = new ReentrantLock();
    private final Condition libManageCondition = this.libManageLock.newCondition();
    private volatile boolean taskLoop = true;
    private volatile boolean reLoop;

    private LibManageInitTask() {
        super.setName("LibManageInitTask");
        this.setUncaughtExceptionHandler((thisThread, exception) -> CodeCCUtils.INSTANCE.errorLog(LOG, thisThread.getName(), exception));
    }

    public static LibManageInitTask getInstance() {
        return LibManageInitTaskHolder.INSTANCE;
    }

    public void toStop() {
        this.taskLoop = false;
        this.signal();
    }

    private void await() {
        this.libManageLock.lock();
        this.isUsed = false;
        try {
            this.libManageCondition.await();
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "await: ", (Throwable)e);
        }
        finally {
            this.libManageLock.unlock();
        }
    }

    public void toStart() {
        this.reLoop = true;
        this.taskLoop = true;
        this.signal();
    }

    private void signal() {
        this.libManageLock.lock();
        this.isUsed = true;
        try {
            this.libManageCondition.signal();
        }
        finally {
            this.libManageLock.unlock();
        }
    }

    @Override
    public void run() {
        CodeCCUtils.INSTANCE.infoLog(LOG, "LibManageTask Thread run start");
        while (this.taskLoop) {
            this.reLoop = false;
            try {
                this.loadLib();
            }
            catch (Exception e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "LibManageTask Thread error", (Throwable)e);
            }
            if (this.reLoop) continue;
            this.await();
        }
        CodeCCUtils.INSTANCE.infoLog(LOG, "LibManageTask Thread run end");
    }

    private void loadLib() {
        LibManageDirector libManageDirector = LibManageDirector.getInstance();
        libManageDirector.construct(LibLoadPathBuilder.getInstance());
        libManageDirector.loadLib();
    }

    public boolean isUse() {
        return this.isUsed;
    }

    private static class LibManageInitTaskHolder {
        private static final LibManageInitTask INSTANCE = new LibManageInitTask();

        private LibManageInitTaskHolder() {
        }
    }
}

