/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.libmanage.task.builder.impl;

import com.google.common.eventbus.AsyncEventBus;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.libentity.dto.LibBaseDo;
import com.huawei.support.icscbb.util.pool.BasePool;
import com.huawei.support.icslite.business.customsort.service.impl.CustomSortBusinessHandler;
import com.huawei.support.icslite.business.doubleclicklib.entity.message.DoubleClickSceneMessage;
import com.huawei.support.icslite.business.libmanage.service.HdxManageService;
import com.huawei.support.icslite.business.libmanage.task.builder.HdxLibManageService;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class HdxLibManageServiceHandler
extends BasePool<HdxContentDo>
implements HdxLibManageService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxLibManageServiceHandler.class);
    private AsyncEventBus eventBus = EventBusUtils.INSTANCE.getEventBus();
    private HdxManageService hdxManageService = (HdxManageService)SpringContextUtil.getBean((String)"hdxManageService");

    private HdxLibManageServiceHandler() {
    }

    public static HdxLibManageServiceHandler getInstance() {
        return HdxLibManageServiceHandlerHolder.INSTANCE;
    }

    protected void createPool(String key) {
    }

    @Override
    public void checkOldHdx(HdxContentDo hdx) {
        hdx.setState("Task queue");
        File file = FileUtils.getFile((String[])new String[]{hdx.getPath()});
        if (!file.isFile()) {
            super.addPool(hdx.getPath(), (Object)hdx);
            return;
        }
        if (this.objectMap.containsKey(hdx.getPath())) {
            this.hdxManageService.delHdxObject(hdx.getDocId());
            return;
        }
        if (!hdx.isbUse()) {
            this.hdxManageService.delHdxObject(hdx.getDocId());
            return;
        }
        if (file.lastModified() == hdx.getLastModified()) {
            super.addPool(hdx.getPath(), (Object)hdx);
            hdx.setbUse(true);
        } else {
            this.hdxManageService.delHdxObject(hdx.getDocId());
        }
    }

    @Override
    public void setHdxIndexProgress(HdxContentDo hdxContentDo, Map<String, String> hdxIndexProgressMap) {
        if (hdxContentDo.isbUse()) {
            String indexProgress = hdxIndexProgressMap.get(hdxContentDo.getDocId());
            indexProgress = (String)StringUtils.defaultIfBlank((CharSequence)indexProgress, (CharSequence)"0");
            hdxContentDo.setIndexProgress(indexProgress + "%");
        }
    }

    @Override
    public void createAndCheckHdx(File file, List<HdxContentDo> hdxContentList) {
        String filePath = IcsFileUtils.getCanonicalPath((File)file);
        HdxContentDo hdx = (HdxContentDo)super.getPool(filePath);
        if (hdx != null && (StringUtils.equals((CharSequence)"Task queue", (CharSequence)hdx.getState()) || StringUtils.equals((CharSequence)"NewLoaded", (CharSequence)hdx.getState()))) {
            hdx.setState("Loaded");
            return;
        }
        Optional<HdxContentDo> hdxContentDoOpt = this.hdxManageService.addHdx(file);
        if (hdxContentDoOpt.isPresent()) {
            HdxContentDo hdxContentDo = hdxContentDoOpt.get();
            hdxContentDo.setState("NewLoaded");
            hdxContentDo.setIndexProgress("0%");
            super.addPool(filePath, (Object)hdxContentDo);
            hdxContentList.add(hdxContentDo);
            CustomSortBusinessHandler.getInstance().addLibData((LibBaseDo)hdxContentDo, hdxContentDo.getType());
        } else {
            CodeCCUtils.INSTANCE.errorLog(LOG, "addHdx: add(f) is null, file: {0} ", new Object[]{file.getName()});
            HdxContentDo hdxContentDo = new HdxContentDo();
            hdxContentDo.setPath(filePath);
            hdxContentDo.setState("Load error");
            hdxContentDo.setErrMessage("Create object error");
            super.addPool(filePath, (Object)hdxContentDo);
        }
    }

    @Override
    public Map<String, HdxContentDo> getHdxPool() {
        return this.objectMap;
    }

    @Override
    public Optional<HdxContentDo> createAndCheckHdx(File file) {
        return this.createAndCheckHdx(file, null, true);
    }

    private Optional<HdxContentDo> createAndCheckHdx(File file, List<HdxContentDo> hdxContentList, boolean isDoubleClick) {
        HdxContentDo hdxContentDo;
        String filePath = IcsFileUtils.getCanonicalPath((File)file);
        HdxContentDo hdx = (HdxContentDo)super.getPool(filePath);
        if (hdx != null && StringUtils.equalsAny((CharSequence)hdx.getState(), (CharSequence[])new CharSequence[]{"Task queue", "NewLoaded"})) {
            hdx.setState("Loaded");
            if (isDoubleClick) {
                this.eventBus.post((Object)new DoubleClickSceneMessage("0", filePath));
            }
            return Optional.empty();
        }
        Optional<HdxContentDo> hdxContentDoOpt = isDoubleClick ? this.hdxManageService.addDoubleClickHdx(file) : this.hdxManageService.addHdx(file);
        if (hdxContentDoOpt.isPresent()) {
            hdxContentDo = hdxContentDoOpt.get();
            hdxContentDo.setState("NewLoaded");
            hdxContentDo.setIndexProgress("0%");
            super.addPool(filePath, (Object)hdxContentDo);
            if (!isDoubleClick) {
                hdxContentList.add(hdxContentDo);
            }
        } else {
            CodeCCUtils.INSTANCE.errorLog(LOG, "addHdx: add(f) is null, file: {0} ", new Object[]{file.getName()});
            HdxContentDo hdxContentDo2 = new HdxContentDo();
            hdxContentDo2.setPath(filePath);
            hdxContentDo2.setState("Load error");
            hdxContentDo2.setErrMessage("Create object error");
            super.addPool(filePath, (Object)hdxContentDo2);
            return Optional.empty();
        }
        CustomSortBusinessHandler.getInstance().addLibData((LibBaseDo)hdxContentDo, hdxContentDo.getType());
        return Optional.of(hdxContentDo);
    }

    private static class HdxLibManageServiceHandlerHolder {
        private static final HdxLibManageServiceHandler INSTANCE = new HdxLibManageServiceHandler();

        private HdxLibManageServiceHandlerHolder() {
        }
    }
}

