/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.libmanage.task.builder.impl;

import com.google.common.eventbus.AsyncEventBus;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.libentity.dto.LibBaseDo;
import com.huawei.support.icscbb.util.pool.BasePool;
import com.huawei.support.icslite.business.customsort.service.impl.CustomSortBusinessHandler;
import com.huawei.support.icslite.business.doubleclicklib.entity.message.DoubleClickSceneMessage;
import com.huawei.support.icslite.business.libmanage.service.IcsManageService;
import com.huawei.support.icslite.business.libmanage.task.builder.IcsLibManageService;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsLibManageServiceHandler
extends BasePool<IcsContentDo>
implements IcsLibManageService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsLibManageServiceHandler.class);
    private final Set<String> updateLibSet = Collections.synchronizedSet(new LinkedHashSet());
    private AsyncEventBus eventBus = EventBusUtils.INSTANCE.getEventBus();
    private IcsManageService icsManageService = (IcsManageService)SpringContextUtil.getBean((String)"icsManageService");

    private IcsLibManageServiceHandler() {
    }

    public static IcsLibManageServiceHandler getInstance() {
        return IcsLibManageServiceHandlerHolder.INSTANCE;
    }

    protected void createPool(String key) {
    }

    @Override
    public void checkOldIcs(IcsContentDo ics) {
        ics.setState("Task queue");
        File file = FileUtils.getFile((String[])new String[]{ics.getPath()});
        if (!file.isFile()) {
            super.addPool(ics.getPath(), (Object)ics);
            return;
        }
        if (this.objectMap.containsKey(ics.getPath())) {
            this.icsManageService.delIcsObject(ics.getDocId());
            return;
        }
        if (!ics.isbUse()) {
            this.icsManageService.delIcsObject(ics.getDocId());
            return;
        }
        if (file.lastModified() == ics.getLastModified()) {
            super.addPool(ics.getPath(), (Object)ics);
            ics.setbUse(true);
        } else {
            this.icsManageService.delIcsObject(ics.getDocId());
        }
    }

    @Override
    public void setIcsIndexProgress(IcsContentDo icsContentDo, Map<String, String> icsIndexProgressMap) {
        if (icsContentDo.isbUse()) {
            String indexProgress = icsIndexProgressMap.get(icsContentDo.getDocId());
            indexProgress = (String)StringUtils.defaultIfBlank((CharSequence)indexProgress, (CharSequence)"0");
            icsContentDo.setIndexProgress(indexProgress + "%");
        }
    }

    @Override
    public void checkUpdateVersionrelation(IcsContentDo ics) {
        this.updateLibSet.addAll(this.icsManageService.getDocIdFromVersionrelation(ics.getProjectid(), ics.getProductV(), ics.getLang()));
        this.icsManageService.getDocIdFromVersionrelation(ics.getDocId(), this.updateLibSet);
    }

    @Override
    public void updateVersionrelation() {
        this.icsManageService.updateVersionrelation(this.updateLibSet);
        this.updateLibSet.clear();
    }

    @Override
    public void addAndCheckIcs(File file) {
        this.addAndCheckIcsWhenDifferLoad(file, false);
    }

    @Override
    public void doubleClickAddIcs(File file) {
        this.addAndCheckIcsWhenDifferLoad(file, true);
    }

    private void addAndCheckIcsWhenDifferLoad(File file, boolean isDoubleClick) {
        Optional<IcsContentDo> icsContentDoOpt;
        String filePathStr = IcsFileUtils.getCanonicalPath((File)file);
        IcsContentDo ics = (IcsContentDo)super.getPool(filePathStr);
        if (ics != null && StringUtils.equalsAny((CharSequence)ics.getState(), (CharSequence[])new CharSequence[]{"Task queue", "NewLoaded"})) {
            ics.setState("Loaded");
            if (isDoubleClick) {
                this.eventBus.post((Object)new DoubleClickSceneMessage("0", ics.getPath()));
            }
            return;
        }
        Optional<IcsContentDo> optional = icsContentDoOpt = isDoubleClick ? this.icsManageService.addDoubleClickIcs(file) : this.icsManageService.addIcs(file);
        if (icsContentDoOpt.isPresent()) {
            IcsContentDo icsContentDo = icsContentDoOpt.get();
            icsContentDo.setState("NewLoaded");
            icsContentDo.setIndexProgress("0%");
            this.checkUpdateVersionrelation(icsContentDo);
            super.addPool(filePathStr, (Object)icsContentDo);
            CustomSortBusinessHandler.getInstance().addLibData((LibBaseDo)icsContentDo, icsContentDo.getType());
        } else {
            CodeCCUtils.INSTANCE.errorLog(LOG, "addIcs: add(f) is null, file: {0} ", new Object[]{file.getName()});
            IcsContentDo icsContentDo = new IcsContentDo();
            icsContentDo.setPath(filePathStr);
            icsContentDo.setState("Load error");
            icsContentDo.setErrMessage("Create object error");
            super.addPool(filePathStr, (Object)icsContentDo);
        }
    }

    @Override
    public Map<String, IcsContentDo> getIcsPool() {
        return this.objectMap;
    }

    private static class IcsLibManageServiceHandlerHolder {
        private static final IcsLibManageServiceHandler INSTANCE = new IcsLibManageServiceHandler();

        private IcsLibManageServiceHandlerHolder() {
        }
    }
}

