/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.libmanage.task.builder.impl;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icslite.business.libmanage.service.HdxManageService;
import com.huawei.support.icslite.business.libmanage.task.builder.impl.HdxLibManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.task.builder.impl.IcsLibManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.task.builder.impl.LibManageAbstractBuilder;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class LibLoadDoubleClickBuilder
extends LibManageAbstractBuilder {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(LibLoadDoubleClickBuilder.class);

    private LibLoadDoubleClickBuilder() {
    }

    public static LibLoadDoubleClickBuilder getInstance() {
        return DoubleClickLoadLibBuilderHolder.INSTANCE;
    }

    @Override
    public void loadLibrary(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        File file = FileUtils.getFile((String[])new String[]{path});
        if (!IcsFileUtils.isFile((File)file)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "The file cannot be read");
            return;
        }
        if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".hwics")) {
            IcsLibManageServiceHandler.getInstance().doubleClickAddIcs(file);
            return;
        }
        Optional<HdxContentDo> hdxContentDoOpt = HdxLibManageServiceHandler.getInstance().createAndCheckHdx(file);
        if (!hdxContentDoOpt.isPresent()) {
            return;
        }
        HdxContentDo hdxContentDo = hdxContentDoOpt.get();
        CodeCCUtils.INSTANCE.infoLog(LOG, "[content] add hdx lib success, double click load, the libPath is {0}, the docId is {1}.", new Object[]{hdxContentDo.getPath(), hdxContentDo.getDocId()});
        HdxManageService hdxManageService = (HdxManageService)SpringContextUtil.getBean((String)"hdxManageService");
        hdxManageService.updateHdx(hdxContentDo);
    }

    @Override
    public void loadNewLib() {
        IcsCommonServiceHandler icsCommonServiceHandler = IcsCommonServiceHandler.getInstance();
        String doubleClickLibPath = icsCommonServiceHandler.getDoubleClickLibPath();
        this.loadLibrary(icsCommonServiceHandler.getDoubleClickLibPath());
        for (Map.Entry libPathEntry : icsCommonServiceHandler.getDoubleClickLibPathPool().entrySet()) {
            if (StringUtils.equals((CharSequence)doubleClickLibPath, (CharSequence)((CharSequence)libPathEntry.getKey()))) continue;
            this.loadLibrary((String)libPathEntry.getKey());
        }
    }

    private static class DoubleClickLoadLibBuilderHolder {
        private static final LibLoadDoubleClickBuilder INSTANCE = new LibLoadDoubleClickBuilder();

        private DoubleClickLoadLibBuilderHolder() {
        }
    }
}

