/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.libmanage.task.builder.impl;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icslite.business.libmanage.service.HdxManageService;
import com.huawei.support.icslite.business.libmanage.service.LibManageService;
import com.huawei.support.icslite.business.libmanage.task.builder.impl.HdxLibManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.task.builder.impl.IcsLibManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.task.builder.impl.LibManageAbstractBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class LibLoadPathBuilder
extends LibManageAbstractBuilder {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(LibLoadPathBuilder.class);

    private LibLoadPathBuilder() {
    }

    public static LibLoadPathBuilder getInstance() {
        return SetPathLoadLibBuliderHolder.INSTANCE;
    }

    @Override
    public void loadNewLib() {
        LibManageService libManageService = (LibManageService)SpringContextUtil.getBean((String)"libManageService");
        String defaultPathStr = libManageService.getIcsLiteDefaultSettingPath();
        if (StringUtils.isNotBlank((CharSequence)defaultPathStr)) {
            this.loadLibrary(defaultPathStr);
        } else {
            CodeCCUtils.INSTANCE.errorLog(LOG, "loadNewLib, defaultPathStr is null");
        }
        List<String> querySettings = libManageService.getIcsLiteMultiPath();
        if (CollectionUtils.isEmpty(querySettings)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "afterPropertiesSet querySettings is null");
            return;
        }
        for (String pathStr : querySettings) {
            if (StringUtils.isBlank((CharSequence)pathStr)) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "afterPropertiesSet getIcsLiteMultiPath, pathStr is null");
                continue;
            }
            this.loadLibrary(pathStr);
        }
    }

    @Override
    public void loadLibrary(String path) {
        File files = FileUtils.getFile((String[])new String[]{path});
        if (!IcsFileUtils.isDirectory((File)files)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The file cannot be read from the path.");
            return;
        }
        File[] listFiles = files.listFiles();
        if (listFiles == null || listFiles.length == 0) {
            return;
        }
        ArrayList<HdxContentDo> hdxContentList = new ArrayList<HdxContentDo>();
        for (File file : listFiles) {
            if (!IcsFileUtils.isFile((File)file)) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "The file cannot be read from listFiles.");
                continue;
            }
            if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".hdx")) {
                HdxLibManageServiceHandler.getInstance().createAndCheckHdx(file, hdxContentList);
            }
            if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(".hwics")) continue;
            IcsLibManageServiceHandler.getInstance().addAndCheckIcs(file);
        }
        HdxManageService hdxManageService = (HdxManageService)SpringContextUtil.getBean((String)"hdxManageService");
        hdxManageService.updateHdx(hdxContentList);
    }

    private static class SetPathLoadLibBuliderHolder {
        private static final LibLoadPathBuilder INSTANCE = new LibLoadPathBuilder();

        private SetPathLoadLibBuliderHolder() {
        }
    }
}

