/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.libmanage.task.builder.impl;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.libmanage.dependency.LibManageDependency;
import com.huawei.support.icslite.business.libmanage.service.HdxManageService;
import com.huawei.support.icslite.business.libmanage.service.IcsManageService;
import com.huawei.support.icslite.business.libmanage.service.LibManageService;
import com.huawei.support.icslite.business.libmanage.serviceimpl.LibManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.task.builder.LibManageBuilder;
import com.huawei.support.icslite.business.libmanage.task.builder.impl.HdxLibManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.task.builder.impl.IcsLibManageServiceHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public abstract class LibManageAbstractBuilder
implements LibManageBuilder {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(LibManageServiceHandler.class);
    private IcsManageService icsManageService = (IcsManageService)SpringContextUtil.getBean((String)"icsManageService");
    private HdxManageService hdxManageService = (HdxManageService)SpringContextUtil.getBean((String)"hdxManageService");
    private LibManageService libManageService = (LibManageService)SpringContextUtil.getBean((String)"libManageService");

    @Override
    public void updateLibData() {
        this.libManageService.updateLibData();
    }

    @Override
    public void loadAndCheckOldLib() {
        int icsSize = this.icsManageService.icsOldSize();
        int icsMinIndex = 0;
        ArrayList<IcsContentDo> icsContentlist = new ArrayList<IcsContentDo>();
        Map<String, String> icsIndexProgressMap = LibManageDependency.getInstance().getIcsIndexProgress();
        while (icsSize - icsMinIndex > 0) {
            icsContentlist.addAll(this.icsManageService.getIcsOldAll(icsMinIndex, 100));
            for (IcsContentDo ics : icsContentlist) {
                IcsLibManageServiceHandler.getInstance().checkOldIcs(ics);
                IcsLibManageServiceHandler.getInstance().setIcsIndexProgress(ics, icsIndexProgressMap);
            }
            icsContentlist.clear();
            icsMinIndex += 100;
        }
        int hdxSize = this.hdxManageService.oldSize();
        int hdxMinIndex = 0;
        ArrayList<HdxContentDo> hdxContentlist = new ArrayList<HdxContentDo>();
        Map<String, String> hdxIndexProgressMap = LibManageDependency.getInstance().getHdxIndexProgress();
        while (hdxSize - hdxMinIndex > 0) {
            hdxContentlist.addAll(this.hdxManageService.getHdxOldAll(hdxMinIndex, 100));
            for (HdxContentDo hdx : hdxContentlist) {
                HdxLibManageServiceHandler.getInstance().checkOldHdx(hdx);
                HdxLibManageServiceHandler.getInstance().setHdxIndexProgress(hdx, hdxIndexProgressMap);
            }
            hdxContentlist.clear();
            hdxMinIndex += 100;
        }
    }

    @Override
    public abstract void loadNewLib();

    @Override
    public void delLastLib() {
        for (IcsContentDo ics : IcsLibManageServiceHandler.getInstance().getIcsPool().values()) {
            if (!"Task queue".equals(ics.getState())) continue;
            ics.setState("Deleted");
            IcsLibManageServiceHandler.getInstance().checkUpdateVersionrelation(ics);
            this.icsManageService.delIcsObject(ics.getDocId());
            CodeCCUtils.INSTANCE.infoLog(LOG, "[content] del ics lib, the libPath is {0}, the docId is {1}.", new Object[]{ics.getPath(), ics.getDocId()});
        }
        for (HdxContentDo hdx : HdxLibManageServiceHandler.getInstance().getHdxPool().values()) {
            if (!"Task queue".equals(hdx.getState())) continue;
            hdx.setState("Deleted");
            this.hdxManageService.delHdxObject(hdx.getDocId());
            CodeCCUtils.INSTANCE.infoLog(LOG, "[content] del hdx lib, the libPath is {0}, the docId is {1}.", new Object[]{hdx.getPath(), hdx.getDocId()});
        }
        IcsLibManageServiceHandler.getInstance().getIcsPool().clear();
        HdxLibManageServiceHandler.getInstance().getHdxPool().clear();
    }

    @Override
    public void syncCustomSortData() {
        this.libManageService.syncCustomSortData();
    }

    @Override
    public void updateVersionrelation() {
        IcsLibManageServiceHandler.getInstance().updateVersionrelation();
    }

    @Override
    public void checkLib() {
        Set<String> docIdSet = this.libManageService.getAllDocId();
        Set<String> docIdSetforContent = this.libManageService.getDocIdforContent();
        docIdSet.removeAll(docIdSetforContent);
        for (String docId : docIdSet) {
            this.icsManageService.delIcsObject(docId);
            this.hdxManageService.delHdxObject(docId);
        }
    }

    @Override
    public void verifyLib() {
        LibManageDependency.getInstance().startVerify();
    }

    public abstract void loadLibrary(String var1);

    @Override
    public int getLoadLibSize() {
        return IcsLibManageServiceHandler.getInstance().getIcsPool().values().size() + HdxLibManageServiceHandler.getInstance().getHdxPool().values().size();
    }
}

