/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.libmanage.utils;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.common.dto.LibCommonDto;
import com.huawei.support.icslite.business.libmanage.dto.LibResponseDto;
import com.huawei.support.icslite.business.upgradelibcommon.exception.VersionCompareException;
import com.huawei.support.icslite.business.upgradelibcommon.util.CommonLibUpgradeUtils;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.wsf.core.HWEncoder;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CommonLibManageUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(CommonLibManageUtils.class);
    protected static final String INDEX_PROGRESS_FINISH = "100%";
    protected static final String INDEX_PROGRESS_NOT_START = "0%";

    public static String getLibManageInfo(Map<String, Set<String>> map) {
        String imgBaseDir = ConfigServiceHandler.getInstance().get("system.resourcePath");
        StringBuilder resultStrBuilder = new StringBuilder();
        resultStrBuilder.append("<ul class=\"hdx_rootUL\">");
        map.forEach((key, value) -> {
            String encodeProductName = CommonLibManageUtils.productNameConstruct(imgBaseDir, resultStrBuilder, key);
            value.stream().sorted(Comparator.reverseOrder()).forEach(productVer -> CommonLibManageUtils.prodVerConstruct(imgBaseDir, resultStrBuilder, encodeProductName, productVer));
            resultStrBuilder.append("</div>");
        });
        resultStrBuilder.append("</ul>");
        return resultStrBuilder.toString();
    }

    private static void prodVerConstruct(String imgBaseDir, StringBuilder resultStrBuilder, String encodeProductName, String productVer) {
        String encodeProductV = HWEncoder.encodeForHTMLAttribute((String)productVer);
        resultStrBuilder.append("<li productName=\"").append(encodeProductName).append("\" productVer=\"").append(encodeProductV).append("\"  type='productVersion' >").append("<a class='ics_home_menu_navi_productVer' onclick=\"javascript:icsProductVer(this);\" title=\"").append(encodeProductV).append("\">").append("<img src='/icslite/").append(imgBaseDir).append("/index/icon-enddoc.png' />").append(encodeProductV).append("</a></li>");
    }

    private static String productNameConstruct(String imgBaseDir, StringBuilder resultStrBuilder, String key) {
        String encodeProductName = HWEncoder.encodeForHTMLAttribute((String)key);
        resultStrBuilder.append("<li productName=\"").append(encodeProductName).append("\" type='productName' >").append("<a onclick=\"javascript:icsProduct(this);\" title=\"").append(encodeProductName).append("\">").append("<img src='/icslite/").append(imgBaseDir).append("/index/icon-tree-close.png' />").append(encodeProductName).append("</a></li>");
        resultStrBuilder.append("<div class='ics_home_menu_navi_hide' mystate='hide' >");
        return encodeProductName;
    }

    public static void libDataSort(List<LibResponseDto> libDatalist) {
        libDatalist.sort(((Comparator)CommonLibManageUtils::compareLibName).thenComparing(Comparator.comparing(LibCommonDto::getProductV).reversed()).thenComparing(new LibVersionComparator()));
    }

    private static int compareLibName(LibResponseDto libResponseDto, LibResponseDto targetLibDto) {
        return Collator.getInstance(Locale.CHINA).compare(targetLibDto.getLibName(), libResponseDto.getLibName());
    }

    public static boolean isSonStr(String str, String inputKey) {
        if (StringUtils.isBlank((CharSequence)str) || StringUtils.isBlank((CharSequence)inputKey)) {
            return true;
        }
        return StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)StringUtils.trim((String)inputKey));
    }

    public static boolean isContain(List<String> filterList, String str) {
        if (CollectionUtils.isEmpty(filterList)) {
            return true;
        }
        return filterList.contains(StringUtils.defaultIfBlank((CharSequence)str, (CharSequence)""));
    }

    public static boolean isContainIndexStatus(List<String> indexStatuses, String indexProgress) {
        if (CollectionUtils.isEmpty(indexStatuses)) {
            return true;
        }
        if (StringUtils.equals((CharSequence)indexProgress, (CharSequence)INDEX_PROGRESS_FINISH)) {
            return indexStatuses.contains("2");
        }
        if (StringUtils.equals((CharSequence)indexProgress, (CharSequence)INDEX_PROGRESS_NOT_START)) {
            return indexStatuses.contains("0");
        }
        return indexStatuses.contains("1");
    }

    public static class LibVersionComparator
    implements Comparator<LibResponseDto>,
    Serializable {
        private static final long serialVersionUID = -7288368348216125042L;

        @Override
        public int compare(LibResponseDto beforeDto, LibResponseDto afterDto) {
            try {
                return CommonLibUpgradeUtils.compareLibVersion(afterDto.getLibV(), beforeDto.getLibV());
            }
            catch (VersionCompareException e) {
                CodeCCUtils.INSTANCE.errorLog(log, "CompareLibVersion VersionCompareException");
                return 0;
            }
        }
    }
}

