/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.officepreview.handler;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.sys.SystemCommandUtils;
import com.huawei.support.icslite.business.index.process.helper.ProcessHelper;
import com.huawei.support.icslite.business.officepreview.constant.PreviewConstants;
import com.huawei.support.icslite.business.officepreview.dto.PreviewDto;
import com.huawei.support.icslite.business.officepreview.process.PreviewSubProcess;
import com.huawei.support.icslite.business.officepreview.util.PreviewUtils;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class PreviewHandler {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(PreviewHandler.class);
    private static final String ERROR_MAG_TOP_GAP = "40%";
    private static final List<String> EXCLUDE_JAR_LIST = Collections.unmodifiableList(Arrays.asList("common-adapter-encryption", "icscbb-cms-verify", "bcpg-jdk15on", "bcpkix-jdk15on", "icslite-db", "hibernate-validator", "derby"));
    private String errorMsg = I18nResources.INSTANCE.getValueByKey("doc.preview.error.msg.tip");
    private Process process;
    private Set<String> convertingPaths = new CopyOnWriteArraySet<String>();
    private Set<String> convertErrorPaths = new CopyOnWriteArraySet<String>();

    private PreviewHandler() {
    }

    public static PreviewHandler getInstance() {
        return PreviewHandlerHolder.INSTANCE;
    }

    public InputStream getTopicSourceView(PreviewDto previewDto, String topicDocId, String resourcePath, String officeDownloadUrl) throws IOException {
        boolean renameFlag;
        String filePath = previewDto.getFilePath();
        String libPath = previewDto.getLibPath();
        String finalDestPath = PreviewUtils.getAsposeFinalDestPath(resourcePath, topicDocId, filePath);
        File finalDestFile = FileUtils.getFile((String[])new String[]{finalDestPath});
        if (finalDestFile.exists()) {
            this.convertErrorPaths.remove(finalDestPath);
            return FileUtils.openInputStream((File)finalDestFile);
        }
        if (this.isStreamEmpty(libPath, filePath, finalDestPath)) {
            return null;
        }
        if (this.convertErrorPaths.contains(finalDestPath)) {
            return new ByteArrayInputStream(String.format(Locale.ENGLISH, this.errorMsg, ERROR_MAG_TOP_GAP, officeDownloadUrl).getBytes(StandardCharsets.UTF_8));
        }
        if (!PreviewUtils.isOffice(filePath)) {
            return ZipFilePool.getInputStream((String)libPath, (String)filePath);
        }
        String destPath = PreviewUtils.getAsposeDestPath(resourcePath, topicDocId, filePath);
        this.convertingPaths.add(destPath);
        this.convertToHtml(previewDto.setDestPath(destPath));
        this.convertingPaths.remove(destPath);
        File destFile = FileUtils.getFile((String[])new String[]{destPath});
        if (!destFile.exists() && !finalDestFile.exists()) {
            this.convertErrorPaths.add(finalDestPath);
        }
        if (!(renameFlag = destFile.renameTo(finalDestFile))) {
            IcsFileUtils.copyFile((String)destPath, (String)finalDestPath);
            IcsFileUtils.delFile((String)destPath);
        }
        return FileUtils.openInputStream((File)finalDestFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isStreamEmpty(String libPath, String filePath, String finalDestPath) {
        try (InputStream is = ZipFilePool.getInputStream((String)libPath, (String)filePath);){
            if (is != null) return false;
            this.convertErrorPaths.add(finalDestPath);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "IOException, when ZipFilePool getInputStream.", (Throwable)e);
            return true;
        }
    }

    public String getConvertStatus(String topicDocId, String filePath, String resourcePath) {
        String finalDestPath = PreviewUtils.getAsposeFinalDestPath(resourcePath, topicDocId, filePath);
        if (FileUtils.getFile((String[])new String[]{finalDestPath}).exists() || this.convertErrorPaths.contains(finalDestPath)) {
            return "2";
        }
        String destPath = PreviewUtils.getAsposeDestPath(resourcePath, topicDocId, filePath);
        return this.convertingPaths.contains(destPath) ? "1" : "0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertToHtml(PreviewDto previewDto) throws IOException {
        int processStatus = 0;
        List cmdList = SystemCommandUtils.getProcessArgs(PreviewSubProcess.class, (String)PreviewConstants.PREVIEW_PROCESS_RUNNING_FILE_PATH, this.getPreviewProcessJvmOpts(), new ArrayList(), EXCLUDE_JAR_LIST);
        ProcessBuilder builder = new ProcessBuilder(cmdList);
        try {
            this.process = builder.start();
            ProcessHelper.writeArg(this.process, JSON.toJSONString((Object)previewDto));
            processStatus = SystemCommandUtils.waitFor((Process)this.process, (long)this.getProcessTimeOut(), (TimeUnit)TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "[Preview]PreviewSubProcess process error", (Throwable)e);
            processStatus = 1;
        }
        finally {
            if (processStatus != 0) {
                this.process.destroyForcibly();
            }
        }
        CodeCCUtils.INSTANCE.infoLog(log, "[Preview]End preview process, the target file is:{0}", new Object[]{previewDto.getDestPath()});
    }

    private List<String> getPreviewProcessJvmOpts() {
        String jvmXmx;
        ArrayList<String> jvmOpts = new ArrayList<String>();
        String jvmXms = ConfigServiceHandler.getInstance().get("preview.process.env.jvm.xms");
        if (StringUtils.isNotBlank((CharSequence)jvmXms)) {
            jvmOpts.add(jvmXms);
        }
        if (StringUtils.isNotBlank((CharSequence)(jvmXmx = ConfigServiceHandler.getInstance().get("preview.process.env.jvm.xmx")))) {
            jvmOpts.add(jvmXmx);
        }
        return jvmOpts;
    }

    private long getProcessTimeOut() {
        return Long.parseLong(ConfigServiceHandler.getInstance().getOrSetDefault("preview.process.timeout", "15"));
    }

    static {
        try {
            if (!FileUtils.getFile((String[])new String[]{PreviewConstants.PREVIEW_PROCESS_RUNNING_FILE_PATH}).exists()) {
                IcsFileUtils.copyFile((String)PreviewConstants.JAVAX_RUNNING_FILE_PATH, (String)PreviewConstants.PREVIEW_PROCESS_RUNNING_FILE_PATH);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.infoLog(log, "Create preview progress running file error.");
        }
    }

    private static class PreviewHandlerHolder {
        private static final PreviewHandler INSTANCE = new PreviewHandler();

        private PreviewHandlerHolder() {
        }
    }
}

