/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.officepreview.process;

import com.huawei.support.icscbb.convert.converter.office.ConverterContext;
import com.huawei.support.icscbb.convert.dto.OfficeConvertDto;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icslite.business.index.process.helper.ProcessHelper;
import com.huawei.support.icslite.business.officepreview.dto.PreviewDto;
import com.huawei.support.icslite.business.officepreview.util.PreviewUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class PreviewSubProcess {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(PreviewSubProcess.class);

    private PreviewSubProcess() {
    }

    public static void main(String[] args) {
        String previewDtoJson = ProcessHelper.readParentProcessArgs();
        if (StringUtils.isBlank((CharSequence)previewDtoJson)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Process args is empty.");
            return;
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Into preview process, the dataJson is {0}.", new Object[]{previewDtoJson});
        PreviewDto previewDto = (PreviewDto)JsonUtils.stringToBean((String)previewDtoJson, PreviewDto.class);
        if (previewDto == null) {
            return;
        }
        String destPath = previewDto.getDestPath();
        try {
            FileUtils.forceMkdirParent((File)FileUtils.getFile((String[])new String[]{destPath}));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "DestPath:{0} create parent dir is failed.", (Throwable)e, new Object[]{destPath});
        }
        OfficeConvertDto officeConvertDto = new OfficeConvertDto();
        BeanUtils.copyProperties((Object)previewDto, (Object)officeConvertDto);
        ConverterContext.getInstance().executeConvert(officeConvertDto.setDocType(PreviewUtils.getDocType(previewDto.getFilePath())));
    }
}

