/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.officepreview.util;

import com.huawei.support.icslite.business.officepreview.constant.PreviewConstants;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class PreviewUtils {
    public static String getAsposeDestPath(String resourcePath, String docId, String filePath) {
        return PreviewUtils.getAsposePath(resourcePath, docId, filePath, ".html");
    }

    public static String getAsposeFinalDestPath(String resourcePath, String docId, String filePath) {
        return PreviewUtils.getAsposePath(resourcePath, docId, filePath, "_final.html");
    }

    private static String getAsposePath(String resourcePath, String docId, String filePath, String suffix) {
        String tmpFilePath = StringUtils.replace((String)filePath, (String)"/", (String)File.separator);
        if (PreviewUtils.isOffice(filePath)) {
            tmpFilePath = StringUtils.substring((String)tmpFilePath, (int)0, (int)StringUtils.lastIndexOf((CharSequence)tmpFilePath, (CharSequence)".")) + suffix;
        }
        return resourcePath + File.separator + docId + File.separator + "aspose" + File.separator + tmpFilePath;
    }

    public static String getDocType(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return "";
        }
        int dotIndex = StringUtils.lastIndexOf((CharSequence)filePath, (CharSequence)".");
        if (dotIndex == -1) {
            return "";
        }
        return StringUtils.substring((String)filePath, (int)(dotIndex + 1));
    }

    public static boolean isOffice(String filePath) {
        return PreviewConstants.OFFICE_DOC_FORMAT_LIST.contains(StringUtils.toRootLowerCase((String)PreviewUtils.getDocType(filePath)));
    }
}

