/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.offlinedownload.service.impl;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkConnServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import com.huawei.support.icslite.business.downloadmanage.service.impl.DownloadOperationServiceHandler;
import com.huawei.support.icslite.business.offlinedownload.dto.OfflineDownloadUrlDto;
import com.huawei.support.icslite.business.offlinedownload.dto.assember.DtoAssembler;
import com.huawei.support.icslite.business.offlinedownload.service.OfflineDownloadSingleService;
import com.huawei.support.icslite.offlinedownload.dto.OfflineDownloadUrlDo;
import com.huawei.support.icslite.offlinedownload.service.impl.OfflineDownloadServiceHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

public class OfflineDownloadSingleServiceHandler
implements OfflineDownloadSingleService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(OfflineDownloadSingleServiceHandler.class);
    private final AtomicInteger supportDownloadTaskNum = new AtomicInteger(0);
    private final ReentrantLock reentrantLock = new ReentrantLock();
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final List<String> WHITE_DOMAIN_LIST = Arrays.asList(".huawei.com", ".huawei.cn", ".huawei.ru");

    private OfflineDownloadSingleServiceHandler() {
    }

    public static OfflineDownloadSingleServiceHandler getInstance() {
        return OfflineDownloadSingleServiceHandlerHolder.INSTANCE;
    }

    @Override
    public void init() {
        int offlineDownloadNum = OfflineDownloadServiceHandler.getInstance().getDownloadUrlsNum();
        this.supportDownloadTaskNum.set(offlineDownloadNum);
    }

    @Override
    public void createTb() {
        OfflineDownloadServiceHandler.getInstance().createTb();
    }

    @Override
    public int getSupportDownloadTasksNum() {
        return this.supportDownloadTaskNum.get();
    }

    @Override
    public int getSupportDownloadTasksNumDto() {
        if (this.isRunning.get()) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "getSupportDownloadTasksNumDto InterruptedException exception");
            }
        }
        return this.supportDownloadTaskNum.get();
    }

    @Override
    public void updateSupportDownloadTasksNum(String status) {
        this.supportDownloadTaskNum.set(OfflineDownloadServiceHandler.getInstance().getDownloadUrlsNum());
        if (StringUtils.equals((CharSequence)"login", (CharSequence)status) && this.isRunning.compareAndSet(false, true)) {
            try {
                int num = this.getOfflineDlTaskNumFromSupport();
                this.supportDownloadTaskNum.addAndGet(num);
            }
            catch (DownloadException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "updateSupportDownloadTasksNum fail! appear download exception");
            }
            this.isRunning.set(false);
        }
    }

    @Override
    public String deleteDownloadTasks(List<String> taskIds) {
        if (CollectionUtils.isEmpty(taskIds)) {
            return "0";
        }
        int successNum = OfflineDownloadServiceHandler.getInstance().deleteDownloadTasks(taskIds);
        OperationLogUtils.INSTANCE.successOperationLog("icslite-business-service-offlinedownload", "delete", String.format(Locale.ENGLISH, "deleteDownloadTasks success: %s", successNum));
        int taskIdSize = taskIds.size();
        int exceptionSize = Math.subtractExact(taskIdSize, successNum);
        String resultCode = "1";
        if (exceptionSize == 0) {
            resultCode = "0";
        } else {
            OperationLogUtils.INSTANCE.failOperationLog("icslite-business-service-offlinedownload", "delete", String.format(Locale.ENGLISH, "deleteDownloadTasks success: %s", successNum));
        }
        this.supportDownloadTaskNum.set(OfflineDownloadServiceHandler.getInstance().getDownloadUrlsNum());
        return resultCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<OfflineDownloadUrlDto>> getWillDownloadUrls() {
        HashMap<String, List<OfflineDownloadUrlDto>> resultMap = new HashMap<String, List<OfflineDownloadUrlDto>>();
        try {
            if (!this.reentrantLock.tryLock(10L, TimeUnit.SECONDS)) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "GetSupportDownloadUrlTasks fail! Already wait 10 second, not get lock.");
            }
            this.addSupportOfflineDlTasks();
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "GetSupportDownloadUrlTasks fail!", (Throwable)e);
        }
        catch (DownloadException e) {
            resultMap.put("code", new ArrayList());
            resultMap.put("data", new ArrayList());
            CodeCCUtils.INSTANCE.errorLog(LOG, "GetSupportDownloadUrlTasks appear download exception, get fail!", (Throwable)e);
            HashMap<String, List<OfflineDownloadUrlDto>> hashMap = resultMap;
            return hashMap;
        }
        finally {
            if (this.reentrantLock.isHeldByCurrentThread()) {
                this.reentrantLock.unlock();
            }
        }
        List offlineDownloadUrlDos = OfflineDownloadServiceHandler.getInstance().getWillDownloadUrls();
        OperationLogUtils.INSTANCE.successOperationLog("icslite-business-service-offlinedownload", "query", "Query offline download task : {0}", new Object[]{offlineDownloadUrlDos.size()});
        this.supportDownloadTaskNum.set(OfflineDownloadServiceHandler.getInstance().getDownloadUrlsNum());
        resultMap.put("data", DtoAssembler.INSTANCE.dosToDtos(offlineDownloadUrlDos));
        return resultMap;
    }

    private void addSupportOfflineDlTasks() throws DownloadException {
        int queryNum = Math.min(this.getOfflineDlTaskNumFromSupport(), 1500);
        if (queryNum <= 0) {
            return;
        }
        List<OfflineDownloadUrlDo> offlineDownLoadUrlDos = this.getOfflineDlTasksFromSupport(queryNum);
        if (CollectionUtils.isNotEmpty(offlineDownLoadUrlDos)) {
            offlineDownLoadUrlDos.removeIf(this::isNotMatchDomain);
            OfflineDownloadServiceHandler.getInstance().addDownloadTasks(offlineDownLoadUrlDos);
        }
    }

    private boolean isNotMatchDomain(OfflineDownloadUrlDo offlineDownloadUrlDo) {
        String domainString = DownloadSingleUtils.getDomainString(offlineDownloadUrlDo.getDownloadUrl());
        if (StringUtils.isBlank((CharSequence)domainString)) {
            return true;
        }
        return this.WHITE_DOMAIN_LIST.stream().noneMatch(endSuffix -> StringUtils.endsWithIgnoreCase((CharSequence)domainString, (CharSequence)endSuffix));
    }

    @Override
    public Map<String, Integer> addSupportDownloadTasks(List<DownloadSingleTaskDto> downloadSingleTaskDtos) {
        int endIndex = Math.min(downloadSingleTaskDtos.size(), 1000);
        List<String> isWillDeleteTaskIds = DownloadOperationServiceHandler.getInstance().addTasksReturnTaskIds(downloadSingleTaskDtos.subList(0, endIndex));
        int successNum = isWillDeleteTaskIds.size();
        String resultCode = this.deleteDownloadTasks(isWillDeleteTaskIds);
        if (StringUtils.equals((CharSequence)resultCode, (CharSequence)"1")) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "when addSupportDownLoadTasks offlineDownloadSingleService.deleteDownloadTasks fail");
        }
        int failNum = OfflineDownloadServiceHandler.getInstance().getDownloadUrlsNum();
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("successNum", successNum);
        resultMap.put("failNum", failNum);
        return resultMap;
    }

    private int getOfflineDlTaskNumFromSupport() throws DownloadException {
        Map<String, Object> serviceMap = this.getServiceMap("OfflineDownloadCountData", "");
        String numStr = serviceMap.get("data").toString();
        if (StringUtils.isBlank((CharSequence)numStr)) {
            return 0;
        }
        return Integer.parseInt(numStr);
    }

    private List<OfflineDownloadUrlDo> getOfflineDlTasksFromSupport(int size) throws DownloadException {
        Map<String, Object> serviceMap = this.getServiceMap("OfflineDownloadListData", "?size=" + size);
        String tasksJson = JSON.toJSONString((Object)serviceMap.get("data"));
        if (StringUtils.isBlank((CharSequence)tasksJson)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Not Offline download task of Support.");
            return Lists.newArrayList();
        }
        List offlineDownLoadUrlDos = JSON.parseArray((String)tasksJson, OfflineDownloadUrlDo.class);
        if (CollectionUtils.isEmpty((Collection)offlineDownLoadUrlDos)) {
            return Lists.newArrayList();
        }
        offlineDownLoadUrlDos.forEach(offlineDownLoadUrlDo -> offlineDownLoadUrlDo.setTaskId(UUID.randomUUID().toString()));
        return offlineDownLoadUrlDos;
    }

    private Map<String, Object> getServiceMap(String key, String param) throws DownloadException {
        if (NetworkConnServiceHandler.getInstance().isClosed()) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "The network connection switch is not turned on.");
            throw new DownloadException("The network connection switch is not turned on.");
        }
        String mainUrl = NetworkServiceHandler.getInstance().getMainUrl(key);
        if (StringUtils.isBlank((CharSequence)mainUrl)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Get main url is fail.");
            throw new DownloadException("Get main url is fail.");
        }
        String finalUrl = mainUrl + param;
        Map<String, String> networkMap = NetworkServiceHandler.getInstance().getNetworkData(finalUrl, "offlineDownloadBusiness");
        if (StringUtils.equals((CharSequence)"-1", (CharSequence)networkMap.get("code"))) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Get net work data is fail,return code -1.");
            throw new DownloadException("Get net work data is fail,return code -1.");
        }
        if (StringUtils.equals((CharSequence)"-3", (CharSequence)networkMap.get("code"))) {
            HashMap<String, Object> serviceMap = new HashMap<String, Object>();
            serviceMap.put("data", "");
            CodeCCUtils.INSTANCE.errorLog(LOG, "Get net work data is no permission,return code -3.");
            return serviceMap;
        }
        String networkDataJson = networkMap.get("dataJson");
        return JsonUtils.stringToMap((String)networkDataJson);
    }

    private static class OfflineDownloadSingleServiceHandlerHolder {
        private static final OfflineDownloadSingleServiceHandler INSTANCE = new OfflineDownloadSingleServiceHandler();

        private OfflineDownloadSingleServiceHandlerHolder() {
        }
    }
}

