/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.oldapppathmanage.service.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icslite.business.oldapppathmanage.constant.OldAppPathManageConstants;
import com.huawei.support.icslite.business.oldapppathmanage.dto.OldAppMsgDto;
import com.huawei.support.icslite.business.oldapppathmanage.dto.OldAppPathDto;
import com.huawei.support.icslite.business.oldapppathmanage.libpathparse.LibPathParse;
import com.huawei.support.icslite.business.oldapppathmanage.service.OldAppPathManageService;
import com.huawei.support.icslite.business.oldapppathmanage.utils.OldAppPathUtils;
import com.huawei.support.icslite.business.preferences.dto.VersionSettingDto;
import com.huawei.support.icslite.business.preferences.serviceimpl.DocumentSettingServiceHandler;
import com.huawei.wsf.core.HWEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OldAppPathManageServiceHandler
implements OldAppPathManageService,
OldAppPathManageConstants {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(OldAppPathManageServiceHandler.class);
    private volatile boolean isFirstLoading = true;

    private OldAppPathManageServiceHandler() {
    }

    public static OldAppPathManageServiceHandler getInstance() {
        return HdxManageServiceHandlerHolder.INSTANCE;
    }

    @Override
    public List<OldAppPathDto> getOldAppPathList() {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getOldAppPathList");
        ArrayList<OldAppPathDto> oldAppPathDtoList = new ArrayList<OldAppPathDto>();
        if (!this.isFirstLoading) {
            return oldAppPathDtoList;
        }
        VersionSettingDto libraryTips = DocumentSettingServiceHandler.getInstance().queryLastAppInfo("");
        if (StringUtils.equals((CharSequence)"0", (CharSequence)libraryTips.getOldAppLibraryTips()) || StringUtils.isBlank((CharSequence)libraryTips.getOldAppLibraryTips())) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Failed to get old document path configuration information or OLD_APP_FLAG is 0");
            return oldAppPathDtoList;
        }
        String oldSystemPath = System.getenv("oldAppPath");
        String appType = System.getenv("appType");
        if (StringUtils.equals((CharSequence)"ICSLite", (CharSequence)appType)) {
            appType = "lastIcsAppPath";
        }
        if (StringUtils.isBlank((CharSequence)oldSystemPath)) {
            OldAppMsgDto oldAppMsgDto = this.getOldAppMsg();
            oldSystemPath = oldAppMsgDto.getOldAppPath();
            appType = oldAppMsgDto.getOldAppType();
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{oldSystemPath, appType})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Can't find OldSystemPath");
            return oldAppPathDtoList;
        }
        if (StringUtils.equals((CharSequence)appType, (CharSequence)"lastIcsAppPath")) {
            oldAppPathDtoList.addAll(this.getIcsOldAppPaths(oldSystemPath));
            this.saveOldAppSystemPath(oldSystemPath, "lastIcsAppPath");
            this.encodePath(oldAppPathDtoList);
            return oldAppPathDtoList;
        }
        oldAppPathDtoList.addAll(this.getHdxOldAppPaths(oldSystemPath));
        this.saveOldAppSystemPath(oldSystemPath, "lastHdxAppPath");
        this.encodePath(oldAppPathDtoList);
        return oldAppPathDtoList;
    }

    private void encodePath(List<OldAppPathDto> oldAppPathDtos) {
        for (OldAppPathDto oldAppPathDto : oldAppPathDtos) {
            oldAppPathDto.setOldAppPath(HWEncoder.encodeForHTMLAttribute((String)oldAppPathDto.getOldAppPath()));
        }
    }

    private List<OldAppPathDto> getIcsOldAppPaths(String oldSystemPath) {
        String defaultPath = DocumentSettingServiceHandler.getInstance().getDefaultLibPath();
        if (StringUtils.isBlank((CharSequence)defaultPath)) {
            defaultPath = oldSystemPath + "libraries";
        }
        ArrayList icsAppPathDtoList = Lists.newArrayList();
        OldAppPathDto icsAppPathDto = new OldAppPathDto();
        boolean isExists = DocumentSettingServiceHandler.getInstance().isExistsLibPath(defaultPath);
        if (this.checkOldAppPath(defaultPath) && !isExists) {
            icsAppPathDto.setOldAppPath(defaultPath);
            icsAppPathDtoList.add(icsAppPathDto);
        }
        String multiPath = oldSystemPath + APP_DOCUMENT_DIR_SETTING;
        icsAppPathDtoList.addAll(this.getOldIcsLiteMultiPath(multiPath));
        return icsAppPathDtoList;
    }

    private List<OldAppPathDto> getHdxOldAppPaths(String oldSystemPath) {
        OldAppPathDto hdxAppPathDto = new OldAppPathDto();
        ArrayList<OldAppPathDto> hdxAppPathDtoList = new ArrayList<OldAppPathDto>();
        String defaultPath = oldSystemPath + "libraries";
        boolean isExists = DocumentSettingServiceHandler.getInstance().isExistsLibPath(defaultPath);
        if (this.checkOldAppPath(defaultPath) && !isExists) {
            hdxAppPathDto.setOldAppPath(defaultPath);
            hdxAppPathDtoList.add(hdxAppPathDto);
        }
        String multiPath = oldSystemPath + HEDEXLITE_MULTI_LIB_DIR;
        hdxAppPathDtoList.addAll(this.getOldHeDexLiteMultiPath(multiPath));
        return hdxAppPathDtoList;
    }

    private OldAppMsgDto getOldAppMsg() {
        OldAppMsgDto oldAppMsgDto = new OldAppMsgDto();
        VersionSettingDto icsOldAppMsg = DocumentSettingServiceHandler.getInstance().queryLastAppInfo("system.lastIcsAppPath");
        if (StringUtils.isNotBlank((CharSequence)icsOldAppMsg.getLastAppPath())) {
            oldAppMsgDto.setOldAppType("lastIcsAppPath");
            oldAppMsgDto.setOldAppPath(icsOldAppMsg.getLastAppPath());
            return oldAppMsgDto;
        }
        VersionSettingDto hdxOldAppMsg = DocumentSettingServiceHandler.getInstance().queryLastAppInfo("system.lastHdxAppPath");
        if (StringUtils.isNotBlank((CharSequence)hdxOldAppMsg.getLastAppPath())) {
            oldAppMsgDto.setOldAppType("lastHdxAppPath");
            oldAppMsgDto.setOldAppPath(hdxOldAppMsg.getLastAppPath());
            return oldAppMsgDto;
        }
        return oldAppMsgDto;
    }

    private void saveOldAppSystemPath(String lastAppPath, String lastAppType) {
        VersionSettingDto icsOldAppPathDo = new VersionSettingDto();
        icsOldAppPathDo.setLastAppType(lastAppType);
        icsOldAppPathDo.setLastAppPath(lastAppPath);
        DocumentSettingServiceHandler.getInstance().saveLastAppInfo(icsOldAppPathDo);
    }

    private boolean checkOldAppPath(String oldPath) {
        File files = FileUtils.getFile((String[])new String[]{oldPath});
        boolean isValid = false;
        if (!IcsFileUtils.isDirectory((File)files)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "The file cannot be read from the oldAppPath.");
            return false;
        }
        File[] listFiles = files.listFiles();
        if (listFiles == null || listFiles.length == 0) {
            return false;
        }
        for (File file : listFiles) {
            if (!IcsFileUtils.isFile((File)file)) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "The file cannot be read");
                continue;
            }
            String fileName = file.getName().toLowerCase(Locale.ENGLISH);
            if (fileName.endsWith(".hdx")) {
                isValid = true;
                break;
            }
            if (!fileName.endsWith(".hwics")) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    private List<OldAppPathDto> getOldIcsLiteMultiPath(String oldPath) {
        ArrayList<OldAppPathDto> oldAppPathDtoList = new ArrayList<OldAppPathDto>();
        List<OldAppPathDto> oldAppPathDtos = OldAppPathUtils.parseSettingDocument(oldPath);
        for (OldAppPathDto oldAppPathDto : oldAppPathDtos) {
            if (!this.checkOldAppPath(oldAppPathDto.getOldAppPath())) continue;
            oldAppPathDtoList.add(oldAppPathDto);
        }
        return oldAppPathDtoList;
    }

    private List<OldAppPathDto> getOldHeDexLiteMultiPath(String oldPath) {
        ArrayList<OldAppPathDto> oldAppPathDtoList = new ArrayList<OldAppPathDto>();
        File file = FileUtils.getFile((String[])new String[]{oldPath});
        LibPathParse libPathParse = new LibPathParse();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Object object = null;
            try {
                SAXParserUtils.parseXml((InputStream)fileInputStream, (DefaultHandler)libPathParse);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fileInputStream != null) {
                    if (object != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get file error");
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "SAXException error");
        }
        List<OldAppPathDto> oldAppPathDtos = libPathParse.getOldAppPathDtoList();
        for (OldAppPathDto oldAppPathDto : oldAppPathDtos) {
            if (!this.checkOldAppPath(oldAppPathDto.getOldAppPath())) continue;
            oldAppPathDtoList.add(oldAppPathDto);
        }
        return oldAppPathDtoList;
    }

    public void setFirstLoading(boolean isFirstLoading) {
        this.isFirstLoading = isFirstLoading;
    }

    private static class HdxManageServiceHandlerHolder {
        private static final OldAppPathManageServiceHandler INSTANCE = new OldAppPathManageServiceHandler();

        private HdxManageServiceHandlerHolder() {
        }
    }
}

