/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.onlinelib.helper;

import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icslite.business.onlinelib.dto.FavoritesDto;
import com.huawei.support.icslite.business.onlinelib.dto.LibInfoDto;
import com.huawei.support.icslite.business.onlinelib.mapper.FavoritesConverter;
import com.huawei.support.icslite.business.onlinelib.mapper.OnlineQueryConverter;
import com.huawei.support.icslite.business.onlinelib.service.OnlineQueryBusiness;
import com.huawei.support.icslite.business.onlinelib.upgradefilter.FavoriteFilterChain;
import com.huawei.support.icslite.business.onlinelib.utils.OnlineQueryUtils;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.localfilter.LocalHdxLibFilter;
import com.huawei.support.icslite.business.upgradelibcommon.libfilter.localfilter.LocalIcsLibFilter;
import com.huawei.support.icslite.business.upgradelibcommon.util.SeriesLibUtils;
import com.huawei.support.icslite.common.utils.LibMsgShowUtils;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.favorites.service.impl.FavoritesServiceHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class FavoritesUpdateHelper {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(FavoritesUpdateHelper.class);
    private static final LocalHdxLibFilter LOCAL_HDX_LIB_FILTER = new LocalHdxLibFilter();
    private static final LocalIcsLibFilter LOCAL_ICS_LIB_FILTER = new LocalIcsLibFilter();

    public static FavoritesUpdateHelper getInstance() {
        return FavoritesUpdateHelperHolder.INSTANCE;
    }

    public List<CompareLibDto> getOnlineCompareLibDtos(List<FavoritesDto> favoritesDtoList) {
        List<String> prodNameList = favoritesDtoList.stream().map(FavoritesDto::getProductName).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        return this.getOnlineLibDtos(prodNameList);
    }

    private void deleteEarlierFavorites(Map<String, List<CompareLibDto>> compareLibDtos, Map<String, String> maxVersionMap) {
        for (Map.Entry<String, String> entry : maxVersionMap.entrySet()) {
            String targetFavoritesId = entry.getKey();
            List deleteFavoritesIds = compareLibDtos.get(entry.getValue()).stream().map(CompareLibDto::getFavoritesId).filter(favoritesId -> !StringUtils.equals((CharSequence)favoritesId, (CharSequence)targetFavoritesId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(deleteFavoritesIds)) continue;
            FavoritesServiceHandler.getInstance().delFavoritesList(deleteFavoritesIds);
        }
    }

    private List<CompareLibDto> getOnlineLibDtos(List<String> prodNameList) {
        ArrayList<CompareLibDto> onlineLibDtos = new ArrayList<CompareLibDto>();
        for (String prodName : prodNameList) {
            List<LibInfoDto> libInfoDtos = this.getLibInfoDtosByProdName(prodName);
            if (CollectionUtils.isEmpty(libInfoDtos)) continue;
            libInfoDtos = libInfoDtos.stream().filter(libInfoDto -> !OnlineQueryUtils.isErrorLibInfoDto(libInfoDto)).collect(Collectors.toList());
            onlineLibDtos.addAll(OnlineQueryConverter.INSTANCE.convertCompareLibDtos(libInfoDtos));
        }
        return onlineLibDtos.stream().distinct().collect(Collectors.toList());
    }

    private List<LibInfoDto> getLibInfoDtosByProdName(String prodName) {
        OnlineQueryBusiness onlineQueryBusiness = (OnlineQueryBusiness)SpringContextUtil.getBean((String)"onlineQueryBusiness");
        Map<String, Object> documents = onlineQueryBusiness.getDocumentsWhenUpgrade(prodName, "", "all", "all");
        if (MapUtils.isEmpty(documents)) {
            return Collections.emptyList();
        }
        String code = (String)StringUtils.defaultIfBlank((CharSequence)documents.get("code").toString(), (CharSequence)"-1");
        if (!StringUtils.equals((CharSequence)code, (CharSequence)"0")) {
            return Collections.emptyList();
        }
        List libInfoDtos = JsonUtils.castList((Object)documents.get("libInfoDtos"), LibInfoDto.class);
        if (CollectionUtils.isEmpty((Collection)libInfoDtos)) {
            return Collections.emptyList();
        }
        return libInfoDtos;
    }

    public void handlerUpgradeMap(List<CompareLibDto> onlineLibDtos, List<CompareLibDto> localLibDtos) {
        Map<String, List<CompareLibDto>> onlineLibMapByType = onlineLibDtos.stream().collect(Collectors.groupingBy(libDto -> libDto.getLibPlatFormType().toUpperCase(Locale.ROOT)));
        Map<String, List<CompareLibDto>> localLibMapByType = localLibDtos.stream().collect(Collectors.groupingBy(libDto -> libDto.getLibPlatFormType().toUpperCase(Locale.ROOT)));
        FavoriteFilterChain onlineLibFilterChain = new FavoriteFilterChain();
        this.handlerIcsUpgradeMap(onlineLibMapByType, localLibMapByType, onlineLibFilterChain);
        this.handlerHdxUpgradeMap(onlineLibMapByType, localLibMapByType, onlineLibFilterChain);
    }

    private void handlerHdxUpgradeMap(Map<String, List<CompareLibDto>> onlineLibMapByType, Map<String, List<CompareLibDto>> localLibMapByType, FavoriteFilterChain onlineLibFilterChain) {
        List<CompareLibDto> hdxLocalCompareLibDtos = localLibMapByType.get("HDX");
        if (CollectionUtils.isEmpty(hdxLocalCompareLibDtos)) {
            return;
        }
        Map<String, List<CompareLibDto>> hdxSerialMap = SeriesLibUtils.serialHdxString(hdxLocalCompareLibDtos, Boolean.TRUE);
        Map<String, List<CompareLibDto>> hdxLocalMaxVersionSerial = LOCAL_HDX_LIB_FILTER.filterLocalHdxLib(hdxSerialMap);
        Map<String, List<CompareLibDto>> hdxOnlineSerialLibs = SeriesLibUtils.serialHdxString(onlineLibMapByType.get("HDX"), Boolean.FALSE);
        if (MapUtils.isEmpty(hdxLocalMaxVersionSerial) || MapUtils.isEmpty(hdxOnlineSerialLibs)) {
            CodeCCUtils.INSTANCE.warnLog(log, "Favorite hdx upgrade localComparelibDtos or onlineCompareLibDtos has empty!");
            return;
        }
        this.commonHandlerUpgradeMap(onlineLibFilterChain, hdxSerialMap, hdxLocalMaxVersionSerial, hdxOnlineSerialLibs);
    }

    private void commonHandlerUpgradeMap(FavoriteFilterChain onlineLibFilterChain, Map<String, List<CompareLibDto>> localSerialMap, Map<String, List<CompareLibDto>> localMaxVersionSerial, Map<String, List<CompareLibDto>> onlineSerialLibs) {
        Map<String, String> serialKeyMap = this.getSerialKeyMap(localMaxVersionSerial);
        if (StringUtils.equals((CharSequence)ConfigServiceHandler.getInstance().get("online.favorites.autoUpgrade"), (CharSequence)"1")) {
            this.deleteEarlierFavorites(localSerialMap, serialKeyMap);
        }
        this.updateFavoriteData(onlineLibFilterChain.handler(localMaxVersionSerial, onlineSerialLibs, true), localSerialMap, serialKeyMap);
    }

    private void handlerIcsUpgradeMap(Map<String, List<CompareLibDto>> onlineLibMapByType, Map<String, List<CompareLibDto>> localLibMapByType, FavoriteFilterChain onlineLibFilterChain) {
        List<CompareLibDto> icsLocalCompareLibDtos = localLibMapByType.get("HWICS");
        if (CollectionUtils.isEmpty(icsLocalCompareLibDtos)) {
            return;
        }
        Map<String, List<CompareLibDto>> icsSerialMap = SeriesLibUtils.serialIcsString(icsLocalCompareLibDtos, Boolean.TRUE);
        Map<String, List<CompareLibDto>> icsLocalMaxVersionSerial = LOCAL_ICS_LIB_FILTER.filterLocalIcsLib(icsSerialMap);
        Map<String, List<CompareLibDto>> icsOnlineSerialLibs = SeriesLibUtils.serialIcsString(onlineLibMapByType.get("HWICS"), Boolean.FALSE);
        if (MapUtils.isEmpty(icsLocalMaxVersionSerial) || MapUtils.isEmpty(icsOnlineSerialLibs)) {
            CodeCCUtils.INSTANCE.warnLog(log, "Favorite ics upgrade localComparelibDtos or onlineCompareLibDtos has empty!");
            return;
        }
        this.commonHandlerUpgradeMap(onlineLibFilterChain, icsSerialMap, icsLocalMaxVersionSerial, icsOnlineSerialLibs);
    }

    private void updateFavoriteData(Map<FavoritesDto, List<FavoritesDto>> upgradeMap, Map<String, List<CompareLibDto>> localSerialMap, Map<String, String> serialKeyMap) {
        CodeCCUtils.INSTANCE.infoLog(log, "Start updateFavoriteData, upgrade map size is {0}", new Object[]{upgradeMap.size()});
        for (Map.Entry<FavoritesDto, List<FavoritesDto>> upgradeDocInfoDtoListEntry : upgradeMap.entrySet()) {
            FavoritesDto localFavoritesDto = upgradeDocInfoDtoListEntry.getKey();
            List<FavoritesDto> onlineFavoritesDtoList = upgradeDocInfoDtoListEntry.getValue();
            if (CollectionUtils.isEmpty(onlineFavoritesDtoList)) {
                CodeCCUtils.INSTANCE.infoLog(log, "Favorites not has upgrade version, productName is {0}", new Object[]{localFavoritesDto.getProductName()});
                continue;
            }
            FavoritesDto onlineFavoritesDto = onlineFavoritesDtoList.get(0);
            String latestV = LibMsgShowUtils.getPageVersionInformation((String)onlineFavoritesDto.getProductV(), (String)((String)StringUtils.defaultIfBlank((CharSequence)onlineFavoritesDto.getLibV(), (CharSequence)"")), (String)LibMsgShowUtils.getFormatIssueDate((String)onlineFavoritesDto.getIssueDate()));
            if (StringUtils.equals((CharSequence)ConfigServiceHandler.getInstance().get("online.favorites.autoUpgrade"), (CharSequence)"1")) {
                onlineFavoritesDto.setFavoritesId(localFavoritesDto.getFavoritesId());
                onlineFavoritesDto.setLatestV(latestV);
                onlineFavoritesDto.setFavoriteV(latestV);
                onlineFavoritesDto.setLatestBrowseUrl(onlineFavoritesDto.getBrowseUrl());
                FavoritesServiceHandler.getInstance().updateLatestFavorite(FavoritesConverter.INSTANCE.domainToDo(onlineFavoritesDto));
                continue;
            }
            String serialKey = serialKeyMap.get(localFavoritesDto.getFavoritesId());
            List<FavoritesDto> localFavorites = FavoritesConverter.INSTANCE.convertFavoritesDtoList(localSerialMap.get(serialKey));
            FavoritesDto updateFavoriteDto = new FavoritesDto();
            updateFavoriteDto.setLatestV(latestV);
            updateFavoriteDto.setLatestBrowseUrl(onlineFavoritesDto.getBrowseUrl());
            localFavorites.forEach(favoritesDto -> {
                updateFavoriteDto.setFavoritesId(favoritesDto.getFavoritesId());
                FavoritesServiceHandler.getInstance().updateLatestFavorite(FavoritesConverter.INSTANCE.domainToDo(updateFavoriteDto));
            });
        }
    }

    private Map<String, String> getSerialKeyMap(Map<String, List<CompareLibDto>> localSerialMap) {
        HashMap<String, String> serialKeyMap = new HashMap<String, String>();
        localSerialMap.forEach((key, value) -> value.forEach(compareLibDto -> serialKeyMap.put(compareLibDto.getFavoritesId(), (String)key)));
        return serialKeyMap;
    }

    private static class FavoritesUpdateHelperHolder {
        private static final FavoritesUpdateHelper INSTANCE = new FavoritesUpdateHelper();

        private FavoritesUpdateHelperHolder() {
        }
    }
}

