/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.onlinelib.helper;

import com.huawei.support.icslite.business.libmanage.dto.LibResponseDto;
import com.huawei.support.icslite.business.onlinelib.dto.LibInfoDto;
import com.huawei.support.icslite.business.onlinelib.dto.ProdInfoDto;
import com.huawei.support.icslite.business.onlinelib.utils.OnlineQueryUtils;
import com.huawei.support.icslite.common.utils.LibMsgShowUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OnlineQueryBusinessHelper {
    private OnlineQueryBusinessHelper() {
    }

    public static OnlineQueryBusinessHelper getInstance() {
        return OnlineQueryBusinessHelperHolder.INSTANCE;
    }

    public void sortDocument(List<ProdInfoDto> prodInfoDtos) {
        prodInfoDtos.sort((prodInfoDtoBegin, prodInfoDtoAfter) -> {
            int result = OnlineQueryBusinessHelper.compareWithParameter(prodInfoDtoAfter.getProductName(), prodInfoDtoBegin.getProductName());
            if (result == 0) {
                result = OnlineQueryBusinessHelper.compareWithParameter(prodInfoDtoAfter.getProductVersion(), prodInfoDtoBegin.getProductVersion());
            }
            return result;
        });
    }

    public void sortLibInfoDtos(ProdInfoDto prodInfoDto) {
        List<LibInfoDto> libInfoDtos = prodInfoDto.getLibInfos();
        if (CollectionUtils.isEmpty(libInfoDtos)) {
            return;
        }
        libInfoDtos.sort((o1, o2) -> {
            String productVersionOne = o1.getProductVersion();
            String productVersionTwo = o2.getProductVersion();
            String libVersionOne = o1.getLibVersion();
            String libVersionTwo = o2.getLibVersion();
            return OnlineQueryBusinessHelper.sortByProductVersionAndLibVersion(productVersionOne, productVersionTwo, libVersionOne, libVersionTwo);
        });
    }

    public List<LibResponseDto> getLocalLibrary(LibInfoDto libInfoDto, List<LibResponseDto> localVerInfos) {
        List<LibResponseDto> resultList = this.filterLocalVersionList(libInfoDto, localVerInfos);
        resultList.sort((o1, o2) -> OnlineQueryBusinessHelper.sortByProductVersionAndLibVersion(o1.getProductV(), o2.getProductV(), o1.getLibV(), o2.getLibV()));
        return resultList;
    }

    private List<LibResponseDto> filterLocalVersionList(LibInfoDto libInfoDto, List<LibResponseDto> libResponseDtoList) {
        String libId = libInfoDto.getLibId();
        String type = libInfoDto.getType();
        String lang = libInfoDto.getLang();
        return libResponseDtoList.stream().filter(libResponseDto -> this.filterLocalVersion((LibResponseDto)libResponseDto, libId, type, lang)).collect(Collectors.toList());
    }

    public boolean filterLocalVersion(LibResponseDto libResponseDto, String libId, String type, String lang) {
        String localType = libResponseDto.getType();
        String localKey = libResponseDto.getLang();
        String onlineKey = lang;
        if (StringUtils.isNotBlank((CharSequence)libId)) {
            localKey = localKey + libResponseDto.getLibId();
            onlineKey = onlineKey + libId;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)localType) || StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"hwics") && StringUtils.equalsIgnoreCase((CharSequence)localType, (CharSequence)"ICS")) {
            return StringUtils.equalsIgnoreCase((CharSequence)onlineKey, (CharSequence)localKey);
        }
        return false;
    }

    public List<ProdInfoDto> fillInOnline(Map<String, ProdInfoDto> prodInfoMap, Map<String, List<LibResponseDto>> localVerInfoMap) {
        ArrayList<ProdInfoDto> prodInfoDtos = new ArrayList<ProdInfoDto>();
        for (String key : prodInfoMap.keySet()) {
            ProdInfoDto prodInfoDto = prodInfoMap.get(key);
            this.sortLibInfoDtos(prodInfoDto);
            LibInfoDto libInfoDto = prodInfoDto.getLibInfos().get(0);
            if (libInfoDto == null) continue;
            List<LibResponseDto> localVerInfos = localVerInfoMap.get(this.getLocalVersionKey(libInfoDto));
            if (CollectionUtils.isNotEmpty(localVerInfos)) {
                LibResponseDto libResponseDto = localVerInfos.get(0);
                if (libResponseDto == null) continue;
                String libVersion = (String)StringUtils.defaultIfBlank((CharSequence)libResponseDto.getLibV(), (CharSequence)"");
                prodInfoDto.setLocalVersion(LibMsgShowUtils.getPageVersionInformation((String)libResponseDto.getProductV(), (String)libVersion, (String)LibMsgShowUtils.getFormatIssueDate((String)libResponseDto.getIssueDate())));
            }
            prodInfoDto.setProductVersion(prodInfoDto.getLibInfos().get(0).getProductVersion());
            this.addHigherSign(prodInfoDto);
            prodInfoDtos.add(prodInfoDto);
        }
        return prodInfoDtos;
    }

    private void addHigherSign(ProdInfoDto prodInfoDto) {
        List<LibInfoDto> libInfoDtos = prodInfoDto.getLibInfos();
        for (LibInfoDto libInfoDto : libInfoDtos) {
            if (StringUtils.equals((CharSequence)libInfoDto.getExistence(), (CharSequence)"1")) break;
            libInfoDto.setHigherVerThanLocalVer("high");
        }
    }

    public String getLocalVersionKey(LibInfoDto libInfoDto) {
        StringJoiner stringJoiner = new StringJoiner("_");
        stringJoiner.add(libInfoDto.getProductName());
        String libId = libInfoDto.getLibId();
        if (StringUtils.isNotBlank((CharSequence)libId)) {
            stringJoiner.add(libId);
        }
        stringJoiner.add(libInfoDto.getLang());
        stringJoiner.add(libInfoDto.getType());
        return stringJoiner.toString();
    }

    private static int sortByProductVersionAndLibVersion(String productVersionOne, String productVersionTwo, String libVersionOne, String libVersionTwo) {
        Collator sortChina = Collator.getInstance(Locale.CHINA);
        int result = sortChina.compare(Optional.ofNullable(productVersionTwo).orElse(""), Optional.ofNullable(productVersionOne).orElse(""));
        if (result == 0) {
            result = OnlineQueryUtils.sortByLibraryVersion(libVersionOne, libVersionTwo);
        }
        return result;
    }

    private static int compareWithParameter(String beforeParameter, String afterParameter) {
        Collator sortChina = Collator.getInstance(Locale.CHINA);
        return sortChina.compare(Optional.ofNullable(beforeParameter).orElse(""), Optional.ofNullable(afterParameter).orElse(""));
    }

    private static class OnlineQueryBusinessHelperHolder {
        private static final OnlineQueryBusinessHelper INSTANCE = new OnlineQueryBusinessHelper();

        private OnlineQueryBusinessHelperHolder() {
        }
    }
}

