/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.onlinelib.serviceimpl;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.exception.CustomSslException;
import com.huawei.support.icslite.business.libmanage.serviceimpl.HdxManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.serviceimpl.IcsManageServiceHandler;
import com.huawei.support.icslite.business.onlinelib.dto.FavoritesDto;
import com.huawei.support.icslite.business.onlinelib.helper.FavoritesUpdateHelper;
import com.huawei.support.icslite.business.onlinelib.mapper.FavoritesConverter;
import com.huawei.support.icslite.business.onlinelib.service.FavoritesBusiness;
import com.huawei.support.icslite.business.onlinelib.utils.FavoritesUtils;
import com.huawei.support.icslite.business.upgradelibcommon.dto.CompareLibDto;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.favorites.dto.FavoritesDo;
import com.huawei.support.icslite.favorites.service.impl.FavoritesServiceHandler;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FavoritesBusinessHandler
implements FavoritesBusiness {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(FavoritesBusinessHandler.class);
    private static final int ZTREE_NODE_INDENT_COL = 2;

    private FavoritesBusinessHandler() {
    }

    public static FavoritesBusinessHandler getInstance() {
        return FavoritesBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public void createTb() {
        FavoritesServiceHandler.getInstance().createTb();
    }

    @Override
    public boolean addFavorites(FavoritesDto favoritesDto) {
        favoritesDto.setCreateTime(System.currentTimeMillis());
        favoritesDto.setFavoritesId(FavoritesUtils.createFavoritesId());
        return FavoritesServiceHandler.getInstance().add(FavoritesConverter.INSTANCE.domainToDo(favoritesDto));
    }

    @Override
    public boolean delFavorites(FavoritesDto favoritesDto) {
        if (favoritesDto == null || StringUtils.isBlank((CharSequence)favoritesDto.getDownloadUrl())) {
            return false;
        }
        FavoritesDto paramFavoritesDto = new FavoritesDto();
        paramFavoritesDto.setDownloadUrl(favoritesDto.getDownloadUrl());
        return FavoritesServiceHandler.getInstance().delFavorites(FavoritesConverter.INSTANCE.domainToDo(paramFavoritesDto));
    }

    @Override
    public int delFavoritesList(List<String> favoritesIds) {
        return FavoritesServiceHandler.getInstance().delFavoritesList(favoritesIds);
    }

    @Override
    public List<String> getProdNameList() {
        List prodNameList = FavoritesServiceHandler.getInstance().getProdNameList();
        prodNameList.sort(Collator.getInstance(Locale.CHINA).reversed());
        return prodNameList;
    }

    @Override
    public boolean hasFavoriteLibs(FavoritesDto favoritesDto) {
        if (favoritesDto == null) {
            return false;
        }
        return FavoritesServiceHandler.getInstance().hasFavoriteLibs(FavoritesConverter.INSTANCE.domainToDo(favoritesDto));
    }

    @Override
    public List<FavoritesDto> getAllFavorites() {
        List<FavoritesDto> favoritesDtoList = FavoritesConverter.INSTANCE.domainToDtoList(FavoritesServiceHandler.getInstance().getAllFavorites());
        List<FavoritesDto> rootFavoriteList = this.createRootFavoriteList();
        if (CollectionUtils.isEmpty(favoritesDtoList)) {
            return rootFavoriteList;
        }
        this.setFavoritesDtoList(favoritesDtoList);
        Map<String, List<FavoritesDto>> favoritesMapByLibType = favoritesDtoList.stream().collect(Collectors.groupingBy(FavoritesDto::getLibType));
        List<FavoritesDto> childrenFavoriteList = this.getFavoritesDtoListByLibTpye(favoritesMapByLibType);
        rootFavoriteList.get(0).setChildren(this.getFoldeFavoriterList(childrenFavoriteList));
        return rootFavoriteList;
    }

    @Override
    public List<FavoritesDto> getFavoritesByProdName(String productName) {
        if (StringUtils.isEmpty((CharSequence)productName)) {
            return this.createRootFavoriteList();
        }
        List<FavoritesDto> favoritesDtoList = FavoritesConverter.INSTANCE.domainToDtoList(FavoritesServiceHandler.getInstance().getFavoritesByProdName(productName));
        List<FavoritesDto> folderFavoritesDtoList = this.createFolederFavoriteList(productName);
        if (CollectionUtils.isEmpty(favoritesDtoList)) {
            return folderFavoritesDtoList;
        }
        this.setFavoritesDtoList(favoritesDtoList);
        Map<String, List<FavoritesDto>> favoritesMapByLibType = favoritesDtoList.stream().collect(Collectors.groupingBy(FavoritesDto::getLibType));
        return this.getFoldeFavoriterList(this.getFavoritesDtoListByLibTpye(favoritesMapByLibType));
    }

    @Override
    public void updateLatestFavorites() {
        List allFavorites = FavoritesServiceHandler.getInstance().getAllFavorites();
        for (FavoritesDo favoritesDo : allFavorites) {
            favoritesDo.setLatestV(favoritesDo.getFavoriteV());
            favoritesDo.setLatestBrowseUrl(favoritesDo.getBrowseUrl());
            FavoritesServiceHandler.getInstance().updateLatestFavorite(favoritesDo);
        }
        List<FavoritesDto> favoritesDtoList = FavoritesConverter.INSTANCE.domainToDtoList(allFavorites);
        if (CollectionUtils.isEmpty(favoritesDtoList)) {
            CodeCCUtils.INSTANCE.infoLog(log, "Update latest favorites done, local favorites dto list has empty!");
            return;
        }
        List<CompareLibDto> onlineLibDtos = null;
        try {
            onlineLibDtos = FavoritesUpdateHelper.getInstance().getOnlineCompareLibDtos(favoritesDtoList);
        }
        catch (CustomSslException e2) {
            CodeCCUtils.INSTANCE.errorLog(log, "updateLatestFavorites has CustomSslException", (Throwable)e2);
            return;
        }
        if (CollectionUtils.isEmpty(onlineLibDtos)) {
            CodeCCUtils.INSTANCE.errorLog(log, "getOnlineCompareLibDtos  onlineLibDtos is null");
            return;
        }
        Map<String, CompareLibDto> downloadUrlMap = onlineLibDtos.stream().collect(Collectors.toMap(CompareLibDto::getDownloadUrl, e -> e));
        List<CompareLibDto> localLibDtos = this.getLocalLibDtos(downloadUrlMap, favoritesDtoList);
        if (CollectionUtils.isEmpty(onlineLibDtos) || CollectionUtils.isEmpty(localLibDtos)) {
            CodeCCUtils.INSTANCE.infoLog(log, "UpdateLatestFavorites not have local/online libs.");
            return;
        }
        FavoritesUpdateHelper.getInstance().handlerUpgradeMap(onlineLibDtos, localLibDtos);
    }

    @Override
    public boolean refreshAutoUpgrade(String autoUpgrade) {
        boolean isSuccess = ConfigServiceHandler.getInstance().set("online.favorites.autoUpgrade", autoUpgrade);
        if (isSuccess) {
            OperationLogUtils.INSTANCE.successOperationLog("icslite-business-service", "UPDATE", "Change favorites auto upgrade success.");
            return true;
        }
        CodeCCUtils.INSTANCE.errorLog(log, "Change favorites auto upgrade failed.");
        OperationLogUtils.INSTANCE.failOperationLog("icslite-business-service", "UPDATE", "Change favorites auto upgrade failed");
        return false;
    }

    @Override
    public String getAutoUpgrade() {
        return ConfigServiceHandler.getInstance().get("online.favorites.autoUpgrade");
    }

    private List<CompareLibDto> getLocalLibDtos(Map<String, CompareLibDto> downloadUrlMap, List<FavoritesDto> favoritesDtoList) {
        return favoritesDtoList.stream().map(favoritesDto -> {
            CompareLibDto compareLibDto = (CompareLibDto)downloadUrlMap.get(favoritesDto.getDownloadUrl());
            compareLibDto.setFavoritesId(favoritesDto.getFavoritesId());
            return compareLibDto;
        }).collect(Collectors.toList());
    }

    private List<FavoritesDto> createRootFavoriteList() {
        ArrayList<FavoritesDto> rootFavoriteList = new ArrayList<FavoritesDto>();
        FavoritesDto favoritesDto = new FavoritesDto();
        favoritesDto.setName("root");
        favoritesDto.setType("1");
        favoritesDto.setOpen(true);
        rootFavoriteList.add(favoritesDto);
        return rootFavoriteList;
    }

    private List<FavoritesDto> createFolederFavoriteList(String productName) {
        ArrayList<FavoritesDto> folderFavoriteList = new ArrayList<FavoritesDto>();
        FavoritesDto favoritesDto = new FavoritesDto();
        favoritesDto.setName(productName);
        favoritesDto.setType("1");
        favoritesDto.setOpen(true);
        folderFavoriteList.add(favoritesDto);
        return folderFavoriteList;
    }

    private void setFavoritesDtoList(List<FavoritesDto> favoritesDtoList) {
        favoritesDtoList.forEach(favoritesDto -> {
            favoritesDto.setType("0");
            favoritesDto.setName(favoritesDto.getLibName());
            favoritesDto.setHasLoad(this.isLocalLoad((FavoritesDto)favoritesDto));
        });
    }

    private List<FavoritesDto> getFavoritesDtoListByLibTpye(Map<String, List<FavoritesDto>> favoritesMapByLibType) {
        List<FavoritesDto> icsFavoriteList;
        ArrayList<FavoritesDto> childrenFavoriteList = new ArrayList<FavoritesDto>();
        List<FavoritesDto> hdxFavoriteList = favoritesMapByLibType.get("HDX");
        if (CollectionUtils.isNotEmpty(hdxFavoriteList)) {
            childrenFavoriteList.addAll(this.getHdxChildrenFavoriteList(hdxFavoriteList));
        }
        if (CollectionUtils.isNotEmpty(icsFavoriteList = favoritesMapByLibType.get("ICS"))) {
            childrenFavoriteList.addAll(this.getIcsChildrenFavoriteList(icsFavoriteList));
        }
        return childrenFavoriteList;
    }

    private List<FavoritesDto> getFoldeFavoriterList(List<FavoritesDto> childrenFavoriteList) {
        Map resultMap = childrenFavoriteList.stream().collect(Collectors.groupingBy(FavoritesDto::getProductName, () -> new TreeMap(Collator.getInstance(Locale.CHINA).reversed()), Collectors.toList()));
        ArrayList<FavoritesDto> folderList = new ArrayList<FavoritesDto>();
        for (String folder : resultMap.keySet()) {
            FavoritesDto favoritesDto = new FavoritesDto();
            favoritesDto.setName(folder);
            favoritesDto.setType("1");
            favoritesDto.setOpen(true);
            favoritesDto.setChildren((List)resultMap.get(folder));
            folderList.add(favoritesDto);
        }
        return folderList;
    }

    private List<FavoritesDto> getHdxChildrenFavoriteList(List<FavoritesDto> hdxFavoritesDtoList) {
        if (CollectionUtils.isEmpty(hdxFavoritesDtoList)) {
            return Collections.emptyList();
        }
        Map<String, List<FavoritesDto>> hdxFavoritesMap = hdxFavoritesDtoList.stream().sorted(Comparator.comparing(FavoritesDto::getLibV, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.groupingBy(favoritesDto -> StringUtils.join(Arrays.asList(favoritesDto.getProductName(), favoritesDto.getProductV(), favoritesDto.getLang(), favoritesDto.getLibId()), (String)"_")));
        return this.getChildrenFavoriteList(hdxFavoritesMap);
    }

    private List<FavoritesDto> getIcsChildrenFavoriteList(List<FavoritesDto> icsFavoritesDtoList) {
        if (CollectionUtils.isEmpty(icsFavoritesDtoList)) {
            return Collections.emptyList();
        }
        Map<String, List<FavoritesDto>> icsFavoritesEmptyLibIdMap = icsFavoritesDtoList.stream().filter(favoritesDto -> StringUtils.isEmpty((CharSequence)favoritesDto.getLibId())).sorted(Comparator.comparing(FavoritesDto::getProductV, Comparator.nullsLast(Comparator.reverseOrder())).thenComparing(FavoritesDto::getLibV, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.groupingBy(favoritesDto -> StringUtils.join(Arrays.asList(favoritesDto.getProductName(), favoritesDto.getLibName(), favoritesDto.getLang()), (String)"_")));
        ArrayList<FavoritesDto> icsChildrenFavoriteList = new ArrayList<FavoritesDto>(this.getChildrenFavoriteList(icsFavoritesEmptyLibIdMap));
        Map<String, List<FavoritesDto>> icsFavoritesMap = icsFavoritesDtoList.stream().filter(favoritesDto -> StringUtils.isNotEmpty((CharSequence)favoritesDto.getLibId())).sorted(Comparator.comparing(FavoritesDto::getProductV, Comparator.nullsLast(Comparator.reverseOrder())).thenComparing(FavoritesDto::getLibV, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.groupingBy(favoritesDto -> StringUtils.join(Arrays.asList(favoritesDto.getProductName(), favoritesDto.getLibId(), favoritesDto.getLang()), (String)"_")));
        icsChildrenFavoriteList.addAll(this.getChildrenFavoriteList(icsFavoritesMap));
        return icsChildrenFavoriteList;
    }

    private List<FavoritesDto> getChildrenFavoriteList(Map<String, List<FavoritesDto>> favoritesMap) {
        ArrayList<FavoritesDto> childrenFavoriteList = new ArrayList<FavoritesDto>();
        for (Map.Entry<String, List<FavoritesDto>> entry : favoritesMap.entrySet()) {
            List<FavoritesDto> values = entry.getValue();
            FavoritesDto favoritesDto = values.get(0);
            if (values.size() == 1) {
                childrenFavoriteList.add(favoritesDto);
            }
            if (values.size() <= 1) continue;
            values.remove(0);
            values.forEach(item -> item.setIndentCol(2));
            favoritesDto.setChildren(values);
            favoritesDto.setIndentCol(2);
            childrenFavoriteList.add(favoritesDto);
        }
        return childrenFavoriteList;
    }

    private boolean isLocalLoad(FavoritesDto favoritesDto) {
        boolean isLoad;
        if (StringUtils.equals((CharSequence)favoritesDto.getLibType(), (CharSequence)"HDX")) {
            HdxContentDo hdxContentDo = new HdxContentDo();
            hdxContentDo.setLibId(favoritesDto.getLibId());
            hdxContentDo.setLibV(favoritesDto.getLibV());
            hdxContentDo.setLang(favoritesDto.getLang());
            isLoad = HdxManageServiceHandler.getInstance().findHdx(hdxContentDo);
        } else {
            IcsContentDo icsContentDo = new IcsContentDo();
            icsContentDo.setProjectid(favoritesDto.getProjectId());
            icsContentDo.setLibV(favoritesDto.getLibV());
            icsContentDo.setLang(favoritesDto.getLang());
            icsContentDo.setIssueDate(favoritesDto.getIssueDate());
            isLoad = IcsManageServiceHandler.getInstance().findIcs(icsContentDo);
        }
        return isLoad;
    }

    private static class FavoritesBusinessHandlerHolder {
        private static final FavoritesBusinessHandler INSTANCE = new FavoritesBusinessHandler();

        private FavoritesBusinessHandlerHolder() {
        }
    }
}

