/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.onlinelib.serviceimpl;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.exception.CustomSslException;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.support.icslite.business.common.dto.NetworkInfoDto;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkConnServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.common.util.NetWorkUtils;
import com.huawei.support.icslite.business.libmanage.dto.LibResponseDto;
import com.huawei.support.icslite.business.libmanage.serviceimpl.HdxManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.serviceimpl.IcsManageServiceHandler;
import com.huawei.support.icslite.business.onlinelib.dao.OnlineQueryBusinessDaoHandler;
import com.huawei.support.icslite.business.onlinelib.dto.LibInfoDto;
import com.huawei.support.icslite.business.onlinelib.dto.ProdInfoDto;
import com.huawei.support.icslite.business.onlinelib.helper.OnlineQueryBusinessHelper;
import com.huawei.support.icslite.business.onlinelib.service.OnlineQueryBusiness;
import com.huawei.support.icslite.business.onlinelib.utils.OnlineQueryUtils;
import com.huawei.support.icslite.common.resources.utils.LiteCommonUtils;
import com.huawei.support.icslite.common.utils.LibMsgShowUtils;
import com.huawei.wsf.core.HWEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.errors.EncodingException;

public class OnlineQueryBusinessHandler
implements OnlineQueryBusiness {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(OnlineQueryBusinessHandler.class);
    private static final String NETWORK_DATA_JSON = "dataJson";
    private static final String ONLINE_DOCUMENTS_NETWORK_URL_SUFFIX = "?prodname=%s&prodver=%s&lang=%s&domaintype=%s";
    private static final String ONLINE_SUGGESTS_NETWORK_URL_SUFFIX = "?prodname=%s&prodver=%s&lang=all&domaintype=all";
    private static final String ONLINE_PRODNAME_URL = "?lang=all&domaintype=all";
    private static final String FORWARD_SLASH = "/";

    private OnlineQueryBusinessHandler() {
    }

    public static OnlineQueryBusinessHandler getInstance() {
        return OnlineQueryBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public void init() {
        String mainUrl = NetworkServiceHandler.getInstance().getMainUrl("ProdNamesData");
        if (StringUtils.isBlank((CharSequence)mainUrl)) {
            return;
        }
        Map<String, String> networkMap = null;
        try {
            networkMap = NetworkServiceHandler.getInstance().getNetworkData(mainUrl + ONLINE_PRODNAME_URL, "onlineQueryBusiness");
        }
        catch (CustomSslException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "getProdNames has CustomSslException", (Throwable)e);
        }
        if (MapUtils.isEmpty(networkMap)) {
            return;
        }
        List<String> prodNames = NetWorkUtils.getList(networkMap.get(NETWORK_DATA_JSON), String.class);
        OnlineQueryBusinessDaoHandler.getInstance().addPool("prodNames", prodNames);
    }

    @Override
    public List<String> getProdNames(String queryKey) {
        Object allProdNames = OnlineQueryBusinessDaoHandler.getInstance().getPool("prodNames");
        if (CollectionUtils.isEmpty((Collection)allProdNames)) {
            this.init();
        }
        if (CollectionUtils.isEmpty((Collection)(allProdNames = OnlineQueryBusinessDaoHandler.getInstance().getPool("prodNames")))) {
            return Collections.emptyList();
        }
        List<String> prodNames = OnlineQueryUtils.getProdNameLocalSuggest(StringUtils.trim((String)queryKey), (List<String>)allProdNames);
        prodNames.add(queryKey);
        return prodNames;
    }

    @Override
    public List<String> getProdVersions(String productName, String productVer) {
        if (NetworkConnServiceHandler.getInstance().isClosed()) {
            return Collections.emptyList();
        }
        String mainUrl = NetworkServiceHandler.getInstance().getMainUrl("ProdVersData");
        if (StringUtils.isBlank((CharSequence)mainUrl)) {
            return Collections.emptyList();
        }
        String url = "";
        try {
            url = mainUrl + String.format(Locale.ENGLISH, ONLINE_SUGGESTS_NETWORK_URL_SUFFIX, HWEncoder.encodeForURL((String)productName.trim()), HWEncoder.encodeForURL((String)StringUtils.trim((String)productVer)));
        }
        catch (EncodingException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "getProdVersions is EncodingException", (Throwable)e);
        }
        Map<String, String> networkMap = NetworkServiceHandler.getInstance().getNetworkData(url, "onlineQueryBusiness");
        return NetWorkUtils.getList(networkMap.get(NETWORK_DATA_JSON), String.class);
    }

    @Override
    public Map<String, Object> getDocumentsWhenUpgrade(String productName, String productVer, String lang, String domainType) {
        return this.getLibInfosMapByKey(productName, productVer, lang, domainType);
    }

    @Override
    public Map<String, Object> getDocuments(String productName, String productVer, String lang, String domainType) {
        Map<String, Object> libInfosMap = this.getLibInfosMapByKey(StringUtils.trim((String)productName), StringUtils.trim((String)productVer), OnlineQueryUtils.getLang(lang), OnlineQueryUtils.getDoMainType(domainType));
        if (MapUtils.isEmpty(libInfosMap)) {
            return libInfosMap;
        }
        List libInfoDtos = JsonUtils.castList((Object)libInfosMap.get("libInfoDtos"), LibInfoDto.class);
        List<ProdInfoDto> prodInfoDtos = this.processLibMeta(libInfoDtos);
        OnlineQueryBusinessHelper.getInstance().sortDocument(prodInfoDtos);
        HashMap<String, Object> prodInfosMap = new HashMap<String, Object>();
        prodInfosMap.put("code", libInfosMap.get("code"));
        prodInfosMap.put("total", prodInfoDtos.size());
        prodInfosMap.put("prodInfoDtos", prodInfoDtos);
        return prodInfosMap;
    }

    private Map<String, Object> getLibInfosMapByKey(String productName, String productVer, String lang, String domainType) {
        String mainUrl = NetworkServiceHandler.getInstance().getMainUrl("DocInfosData");
        if (StringUtils.isBlank((CharSequence)mainUrl)) {
            return Collections.emptyMap();
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(productName);
        params.add(productVer);
        params.add(lang);
        params.add(domainType);
        Map<String, String> networkMap = NetworkServiceHandler.getInstance().getNetworkData(mainUrl + ONLINE_DOCUMENTS_NETWORK_URL_SUFFIX, params, "onlineQueryBusiness");
        String libInfosJson = networkMap.get(NETWORK_DATA_JSON);
        List<LibInfoDto> libInfoDtos = NetWorkUtils.getJsonList(libInfosJson, LibInfoDto.class);
        libInfoDtos.forEach(this::processLibInfoDto);
        String code = networkMap.get("code");
        HashMap<String, Object> libInfosMap = new HashMap<String, Object>();
        libInfosMap.put("code", code);
        libInfosMap.put("libInfoDtos", libInfoDtos);
        return libInfosMap;
    }

    private void processLibInfoDto(LibInfoDto libInfoDto) {
        String filePath = libInfoDto.getFilePath();
        if (!StringUtils.startsWith((CharSequence)filePath, (CharSequence)FORWARD_SLASH)) {
            libInfoDto.setFilePath(FORWARD_SLASH + filePath);
        }
        long packageSize = Long.parseLong((String)StringUtils.defaultIfBlank((CharSequence)libInfoDto.getSize(), (CharSequence)"0"));
        libInfoDto.setSize(LiteCommonUtils.fileUnitExchange((long)packageSize));
        List<NetworkInfoDto> networkInfoList = libInfoDto.getNetworkInfoList();
        if (CollectionUtils.isNotEmpty(networkInfoList)) {
            this.processNetworkInfoList(networkInfoList);
        }
    }

    private List<ProdInfoDto> processLibMeta(List<LibInfoDto> libInfoDtos) {
        HashMap<String, ProdInfoDto> prodInfoMap = new HashMap<String, ProdInfoDto>();
        HashMap<String, List<LibResponseDto>> localVerInfoMap = new HashMap<String, List<LibResponseDto>>();
        int index = 0;
        for (LibInfoDto libInfoDto : libInfoDtos) {
            ProdInfoDto prodInfoDto;
            this.processOneLibInfo(libInfoDto);
            if (!localVerInfoMap.containsKey(libInfoDto.getProductName())) {
                localVerInfoMap.put(OnlineQueryBusinessHelper.getInstance().getLocalVersionKey(libInfoDto), OnlineQueryBusinessHelper.getInstance().getLocalLibrary(libInfoDto, this.getLocalVerInfos(libInfoDto)));
            }
            String prodKey = this.getProductKey(libInfoDto);
            List<NetworkInfoDto> networkInfoList = libInfoDto.getNetworkInfoList();
            if (CollectionUtils.isNotEmpty(networkInfoList)) {
                prodInfoDto = this.getOneProdInfo(libInfoDto);
                prodInfoMap.put(prodKey + ++index, prodInfoDto);
                continue;
            }
            if (prodInfoMap.containsKey(prodKey)) {
                prodInfoDto = (ProdInfoDto)prodInfoMap.get(prodKey);
                List<LibInfoDto> libInfoDtoList = prodInfoDto.getLibInfos();
                libInfoDtoList.add(libInfoDto);
                continue;
            }
            prodInfoDto = this.getOneProdInfo(libInfoDto);
            prodInfoMap.put(prodKey, prodInfoDto);
        }
        return OnlineQueryBusinessHelper.getInstance().fillInOnline(prodInfoMap, localVerInfoMap);
    }

    private List<LibResponseDto> getLocalVerInfos(LibInfoDto libInfoDto) {
        ArrayList<LibResponseDto> localVerInfos = new ArrayList<LibResponseDto>(HdxManageServiceHandler.getInstance().getAll(libInfoDto.getProductName(), ""));
        localVerInfos.addAll(IcsManageServiceHandler.getInstance().getAll(libInfoDto.getProductName(), ""));
        return localVerInfos;
    }

    private void processNetworkInfoList(List<NetworkInfoDto> networkInfoList) {
        for (NetworkInfoDto networkInfoDto : networkInfoList) {
            List<LibResponseDto> localVerInfos = new ArrayList<LibResponseDto>(IcsManageServiceHandler.getInstance().getAll(networkInfoDto.getProductName(), networkInfoDto.getProductVersion()));
            localVerInfos = localVerInfos.stream().filter(libResponseDto -> OnlineQueryBusinessHelper.getInstance().filterLocalVersion((LibResponseDto)libResponseDto, networkInfoDto.getLibId(), "hwics", networkInfoDto.getLang())).collect(Collectors.toList());
            localVerInfos.sort((o1, o2) -> OnlineQueryUtils.sortByLibraryVersion(o1.getLibV(), o2.getLibV()));
            OnlineQueryUtils.processOneNetworkInfoList(networkInfoDto, localVerInfos);
            networkInfoDto.setExistence(this.isLocalExist(networkInfoDto) ? "1" : "0");
        }
    }

    private boolean isLocalExist(LibInfoDto libInfoDto) {
        boolean isExist = false;
        if (StringUtils.equals((CharSequence)libInfoDto.getType(), (CharSequence)"hdx")) {
            HdxContentDo hdxContentDo = new HdxContentDo();
            hdxContentDo.setLibId(libInfoDto.getLibId());
            hdxContentDo.setLibV(libInfoDto.getLibVersion());
            hdxContentDo.setLang(libInfoDto.getLang());
            isExist = HdxManageServiceHandler.getInstance().findHdx(hdxContentDo);
        }
        if (StringUtils.equals((CharSequence)libInfoDto.getType(), (CharSequence)"hwics")) {
            IcsContentDo icsContentDo = new IcsContentDo();
            icsContentDo.setProjectid(libInfoDto.getProjectId());
            icsContentDo.setLibV(libInfoDto.getLibVersion());
            icsContentDo.setLang(libInfoDto.getLang());
            icsContentDo.setIssueDate(libInfoDto.getIssueDate());
            isExist = IcsManageServiceHandler.getInstance().findIcs(icsContentDo);
        }
        return isExist;
    }

    private boolean isLocalExist(NetworkInfoDto networkInfoDto) {
        IcsContentDo icsContentDo = new IcsContentDo();
        icsContentDo.setProjectid(networkInfoDto.getProjectid());
        icsContentDo.setLibV(networkInfoDto.getLibVersion());
        icsContentDo.setLang(networkInfoDto.getLang());
        icsContentDo.setIssueDate(networkInfoDto.getIssueDate());
        return IcsManageServiceHandler.getInstance().findIcs(icsContentDo);
    }

    private ProdInfoDto getOneProdInfo(LibInfoDto libInfoDto) {
        ArrayList<LibInfoDto> libInfoDtoList = new ArrayList<LibInfoDto>();
        libInfoDtoList.add(libInfoDto);
        ProdInfoDto prodInfoDto = new ProdInfoDto();
        prodInfoDto.setProductName(libInfoDto.getProductName());
        prodInfoDto.setLang(libInfoDto.getLang());
        prodInfoDto.setLibInfos(libInfoDtoList);
        return prodInfoDto;
    }

    private void processOneLibInfo(LibInfoDto libInfoDto) {
        String libVersion = (String)StringUtils.defaultIfBlank((CharSequence)libInfoDto.getLibVersion(), (CharSequence)"");
        libInfoDto.setOnlineVersion(LibMsgShowUtils.getPageVersionInformation((String)libInfoDto.getProductVersion(), (String)libVersion, (String)LibMsgShowUtils.getFormatIssueDate((String)libInfoDto.getIssueDate())));
        String existence = this.isLocalExist(libInfoDto) ? "1" : "0";
        libInfoDto.setExistence(existence);
    }

    private String getProductKey(LibInfoDto libInfoDto) {
        StringJoiner stringJoiner = new StringJoiner("_");
        String type = libInfoDto.getType();
        stringJoiner.add(libInfoDto.getProductName());
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"hwics")) {
            stringJoiner.add(StringUtils.defaultIfBlank((CharSequence)libInfoDto.getLibId(), (CharSequence)libInfoDto.getLibName()));
            stringJoiner.add(libInfoDto.getLang());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"hdx")) {
            stringJoiner.add(libInfoDto.getProductVersion());
            stringJoiner.add(libInfoDto.getLang());
            if (StringUtils.isNotBlank((CharSequence)libInfoDto.getLibId())) {
                stringJoiner.add(libInfoDto.getLibId());
            }
        }
        stringJoiner.add(type);
        return stringJoiner.toString();
    }

    private static class OnlineQueryBusinessHandlerHolder {
        private static final OnlineQueryBusinessHandler INSTANCE = new OnlineQueryBusinessHandler();

        private OnlineQueryBusinessHandlerHolder() {
        }
    }
}

