/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.onlinelib.utils;

import com.huawei.support.icslite.business.common.dto.NetworkInfoDto;
import com.huawei.support.icslite.business.libmanage.dto.LibResponseDto;
import com.huawei.support.icslite.business.onlinelib.dto.LibInfoDto;
import com.huawei.support.icslite.common.resources.utils.LiteCommonUtils;
import com.huawei.support.icslite.common.utils.LibMsgShowUtils;
import com.huawei.wsf.core.HWEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OnlineQueryUtils {
    private OnlineQueryUtils() {
    }

    private static Optional<ProdNamePositionInfo> getMaxCommonSubStrLen(String prodNameInput, String srcProdName) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{prodNameInput, srcProdName})) {
            return Optional.empty();
        }
        String prodNameToUpper = prodNameInput.toUpperCase(Locale.ENGLISH);
        String srcProdNameToUpper = srcProdName.toUpperCase(Locale.ENGLISH);
        int max = 0;
        int index = 0;
        int prodNameLen = prodNameToUpper.length();
        int srcProdNameLen = srcProdNameToUpper.length();
        int[] dp = new int[prodNameLen + 1];
        dp[0] = 0;
        for (int i = 0; i < srcProdNameLen; ++i) {
            for (int j = prodNameLen; j >= 1; --j) {
                dp[j] = srcProdNameToUpper.charAt(i) == prodNameToUpper.charAt(j - 1) ? dp[j - 1] + 1 : 0;
                if (dp[j] <= max) continue;
                max = dp[j];
                index = i - max + 1;
            }
        }
        if (max == 0) {
            return Optional.empty();
        }
        return Optional.of(new ProdNamePositionInfo(srcProdName, index, max));
    }

    private static boolean isDuplicate(List<ProdNamePositionInfo> prodNamePositionInfos, ProdNamePositionInfo prodNamePositionInfo) {
        return prodNamePositionInfos.stream().anyMatch(prodNameInfo -> StringUtils.equals((CharSequence)prodNameInfo.getProductName(), (CharSequence)prodNamePositionInfo.getProductName()));
    }

    public static List<String> getProdNameLocalSuggest(String strProdNameInput, List<String> productNames) {
        ArrayList<ProdNamePositionInfo> prodNamePositionInfos = new ArrayList<ProdNamePositionInfo>();
        for (String prodName : productNames) {
            Optional<ProdNamePositionInfo> prodNamePositionInfoOpt = OnlineQueryUtils.getMaxCommonSubStrLen(strProdNameInput, prodName);
            if (!prodNamePositionInfoOpt.isPresent()) continue;
            ProdNamePositionInfo prodNamePositionInfo2 = prodNamePositionInfoOpt.get();
            if (CollectionUtils.isEmpty(prodNamePositionInfos)) {
                prodNamePositionInfos.add(prodNamePositionInfo2);
                continue;
            }
            ProdNamePositionInfo historyRecord = (ProdNamePositionInfo)prodNamePositionInfos.get(0);
            if (prodNamePositionInfo2.getMaxLength() < historyRecord.getMaxLength()) continue;
            if (prodNamePositionInfo2.getMaxLength() > historyRecord.getMaxLength()) {
                prodNamePositionInfos.clear();
            }
            if (OnlineQueryUtils.isDuplicate(prodNamePositionInfos, prodNamePositionInfo2)) continue;
            prodNamePositionInfos.add(prodNamePositionInfo2);
        }
        Collections.sort(prodNamePositionInfos);
        ArrayList<String> productNameList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(prodNamePositionInfos)) {
            prodNamePositionInfos.forEach(prodNamePositionInfo -> productNameList.add(prodNamePositionInfo.getProductName()));
        }
        return productNameList;
    }

    public static int sortByLibraryVersion(String libVersionOne, String libVersionTwo) {
        String libVersionOneTemp = libVersionOne;
        String libVersionTwoTemp = libVersionTwo;
        if (StringUtils.isBlank((CharSequence)libVersionOne)) {
            libVersionOneTemp = "Draft A";
        }
        if (StringUtils.isBlank((CharSequence)libVersionTwo)) {
            libVersionTwoTemp = "Draft A";
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)libVersionTwoTemp, (CharSequence)"Draft") && !StringUtils.startsWithIgnoreCase((CharSequence)libVersionOneTemp, (CharSequence)"Draft")) {
            return -1;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)libVersionOneTemp, (CharSequence)"Draft") && !StringUtils.startsWithIgnoreCase((CharSequence)libVersionTwoTemp, (CharSequence)"Draft")) {
            return 1;
        }
        return libVersionTwoTemp.compareToIgnoreCase(libVersionOneTemp);
    }

    public static void processOneNetworkInfoList(NetworkInfoDto networkInfoDto, List<LibResponseDto> localVerInfos) {
        String libName;
        String libVersion = networkInfoDto.getLibVersion();
        if (StringUtils.isBlank((CharSequence)libVersion)) {
            libVersion = "";
        }
        networkInfoDto.setLibName(HWEncoder.encodeForHTML((String)(StringUtils.isBlank((CharSequence)(libName = networkInfoDto.getLibName())) ? "" : libName)));
        networkInfoDto.setSize(LiteCommonUtils.fileUnitExchange((long)Long.parseLong(StringUtils.isBlank((CharSequence)networkInfoDto.getSize()) ? "0" : networkInfoDto.getSize())));
        networkInfoDto.setOnlineVersion(HWEncoder.encodeForHTML((String)LibMsgShowUtils.getPageVersionInformation((String)networkInfoDto.getProductVersion(), (String)libVersion, (String)LibMsgShowUtils.getFormatIssueDate((String)networkInfoDto.getIssueDate()))));
        if (CollectionUtils.isNotEmpty(localVerInfos)) {
            LibResponseDto libResponseDto = localVerInfos.get(0);
            String localLibVersion = libResponseDto.getLibV();
            if (StringUtils.isBlank((CharSequence)localLibVersion)) {
                localLibVersion = "";
            }
            networkInfoDto.setLocalVersion(HWEncoder.encodeForHTML((String)LibMsgShowUtils.getPageVersionInformation((String)libResponseDto.getProductV(), (String)localLibVersion, (String)LibMsgShowUtils.getFormatIssueDate((String)libResponseDto.getIssueDate()))));
        }
    }

    public static String getLang(String lang) {
        if (StringUtils.equalsAny((CharSequence)lang, (CharSequence[])new CharSequence[]{"zh", "en"})) {
            return lang;
        }
        return "all";
    }

    public static String getDoMainType(String domainType) {
        if (StringUtils.equalsAny((CharSequence)domainType, (CharSequence[])new CharSequence[]{"supporte", "support"})) {
            return domainType;
        }
        return "all";
    }

    public static boolean isErrorLibInfoDto(LibInfoDto libInfoDto) {
        String type = libInfoDto.getType();
        if (StringUtils.isBlank((CharSequence)type)) {
            return true;
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"HDX") && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{libInfoDto.getLibId(), libInfoDto.getLibType()})) {
            return true;
        }
        return StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{libInfoDto.getProductName(), libInfoDto.getProductVersion(), libInfoDto.getIssueDate()});
    }

    static class ProdNamePositionInfo
    implements Comparable<ProdNamePositionInfo> {
        String productName;
        int startIndex;
        int maxLength;

        ProdNamePositionInfo(String productName, int startIndex, int maxLength) {
            this.productName = productName;
            this.startIndex = startIndex;
            this.maxLength = maxLength;
        }

        public String getProductName() {
            return this.productName;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        @Override
        public int compareTo(ProdNamePositionInfo prodNamePositionInfo) {
            return Integer.compare(this.getStartIndex(), prodNamePositionInfo.getStartIndex());
        }

        public int hashCode() {
            return Integer.hashCode(this.startIndex);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ProdNamePositionInfo)) {
                return false;
            }
            ProdNamePositionInfo other = (ProdNamePositionInfo)obj;
            return this.startIndex == other.startIndex;
        }
    }
}

