/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.preferences.helper;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.preferences.dao.DocumentSettingDaoHandler;
import com.huawei.support.icslite.business.preferences.dto.DocumentSettingDto;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DocumentSettingHelper {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DocumentSettingHelper.class);

    private DocumentSettingHelper() {
    }

    public static DocumentSettingHelper getInstance() {
        return DocumentSettingHelperHolder.INSTANCE;
    }

    public String validateSinglePath(String libPath) {
        if (StringUtils.isBlank((CharSequence)libPath)) {
            CodeCCUtils.INSTANCE.errorLog(log, "Other libPath is blank.");
            return "-3";
        }
        String libPathTrim = libPath.trim();
        if (libPathTrim.length() > 150) {
            CodeCCUtils.INSTANCE.errorLog(log, "The new library path exceeds the limit.");
            return "-3";
        }
        if (!this.checkPath(libPathTrim)) {
            CodeCCUtils.INSTANCE.errorLog(log, "Invalid libPath.");
            return "-3";
        }
        if (!CommonConstants.PATH_PATTERN.matcher(libPathTrim).find()) {
            return "-3";
        }
        if (!FileUtils.getFile((String[])new String[]{libPathTrim}).exists()) {
            return "-3";
        }
        if (this.icsLiteMultiPathIsExit(libPathTrim)) {
            return "-2";
        }
        return "";
    }

    public boolean icsLiteMultiPathIsExit(String libPath) {
        List<String> multiPaths = this.getIcsLiteMultiPath();
        multiPaths.add(this.getDefaultLibPath());
        return multiPaths.stream().anyMatch(multiPath -> StringUtils.equalsIgnoreCase((CharSequence)multiPath, (CharSequence)libPath));
    }

    private boolean checkPath(String libPath) {
        return !libPath.contains("\\ ");
    }

    public List<String> getIcsLiteMultiPath() {
        List<DocumentSettingDto> documentSettingDtos = DocumentSettingDaoHandler.INSTANCE.querySettings();
        if (CollectionUtils.isEmpty(documentSettingDtos)) {
            return new ArrayList<String>();
        }
        return documentSettingDtos.stream().map(DocumentSettingDto::getLibPath).collect(Collectors.toList());
    }

    public String getDefaultLibPath() {
        String canonicalPath;
        String defaultLibraryPath = ConfigServiceHandler.getInstance().get("custom.defaultLibraryPath");
        if (StringUtils.isBlank((CharSequence)defaultLibraryPath) && (StringUtils.equals((CharSequence)(defaultLibraryPath = ConfigServiceHandler.getInstance().get("system.defaultLibraryPath")), (CharSequence)"0") || StringUtils.isBlank((CharSequence)defaultLibraryPath))) {
            defaultLibraryPath = this.getLiteLibPath();
        }
        if (!this.checkDefaultLibPath(defaultLibraryPath)) {
            return this.getLiteLibPath();
        }
        try {
            canonicalPath = FileUtils.getFile((String[])new String[]{defaultLibraryPath}).getCanonicalPath();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Default document path normalization failed.");
            return this.getLiteLibPath();
        }
        return canonicalPath;
    }

    private String getLiteLibPath() {
        return IcsCommonServiceHandler.getInstance().getAppRootDir() + CommonConstants.DEFAULT_LIB_DIR;
    }

    private boolean checkDefaultLibPath(String litePathProperty) {
        if (litePathProperty.length() > 150) {
            return false;
        }
        if (!CommonConstants.PATH_PATTERN.matcher(litePathProperty).find()) {
            return false;
        }
        return IcsCommonServiceHandler.getInstance().isExistDisk(litePathProperty);
    }

    public Map<String, String> settingDefaultLibPathAndCheck(String canonicalPath) {
        LinkedHashMap<String, String> idAndPathMap = new LinkedHashMap<String, String>();
        if (this.icsLiteMultiPathIsExit(canonicalPath)) {
            idAndPathMap.put("errorCode", "-2");
            return idAndPathMap;
        }
        File libPathFolder = FileUtils.getFile((String[])new String[]{canonicalPath});
        if (!libPathFolder.exists() && !libPathFolder.mkdirs()) {
            CodeCCUtils.INSTANCE.errorLog(log, "Failed to create the default document folder.");
            idAndPathMap.put("errorCode", "-3");
            return idAndPathMap;
        }
        String oldDefaultLibPath = this.getDefaultLibPath();
        ConfigServiceHandler.getInstance().set("custom.defaultLibraryPath", canonicalPath);
        if (this.icsLiteMultiPathIsExit(oldDefaultLibPath)) {
            idAndPathMap.put("errorCode", "-2");
            return idAndPathMap;
        }
        String oldPathUuid = this.saveSetting(oldDefaultLibPath);
        idAndPathMap.put("id", oldPathUuid);
        idAndPathMap.put("libPath", oldDefaultLibPath);
        OperationLogUtils.INSTANCE.successOperationLog("icslite-common", "SAVE", "Succeeded in saving the new default library path.");
        return idAndPathMap;
    }

    public String saveSetting(String libPath) {
        DocumentSettingDto docSettingDto = new DocumentSettingDto();
        String id = UUID.randomUUID().toString();
        docSettingDto.setId(id);
        docSettingDto.setLibPath(libPath);
        DocumentSettingDaoHandler.INSTANCE.saveSetting(docSettingDto);
        OperationLogUtils.INSTANCE.successOperationLog("icslite-common", "SAVE", "Save other settings successful.");
        CodeCCUtils.INSTANCE.infoLog(log, "Add other document path :[{0}].", new Object[]{libPath});
        return id;
    }

    private static class DocumentSettingHelperHolder {
        private static final DocumentSettingHelper INSTANCE = new DocumentSettingHelper();

        private DocumentSettingHelperHolder() {
        }
    }
}

