/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.preferences.parser;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.xml.dom.XmlDom4jUtils;
import com.huawei.support.icslite.business.preferences.dto.DocumentSettingDto;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class DocumentSettingParser {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(DocumentSettingParser.class);
    private static final String TAG_LIBINFO = "libinfo";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_LIBPATH = "libpath";
    private static final String SETTINGS_FILE_ROOT = "document";
    private static final String DOCUMENT_SETTING_FILE_PATH = IcsCommonServiceHandler.getInstance().getAppRootDir() + CommonConstants.APP_DOCUMENT_DIR_SETTING;

    private DocumentSettingParser() {
    }

    public static List<DocumentSettingDto> parseSettingDocument() {
        Document document = XmlDom4jUtils.getDocument((String)DOCUMENT_SETTING_FILE_PATH);
        if (document == null) {
            return Collections.emptyList();
        }
        Element rootElement = document.getRootElement();
        List elements = rootElement.elements();
        ArrayList<DocumentSettingDto> list = new ArrayList<DocumentSettingDto>();
        for (Element element : elements) {
            QName tagName = element.getQName();
            if (tagName == null || !StringUtils.equals((CharSequence)tagName.getName(), (CharSequence)TAG_LIBINFO)) continue;
            DocumentSettingDto icsSettingDto = new DocumentSettingDto();
            List attributes = element.attributes();
            for (Attribute attribute : attributes) {
                QName qName = attribute.getQName();
                if (qName == null) continue;
                String attrName = qName.getName();
                String attrValue = attribute.getValue();
                if (StringUtils.equals((CharSequence)attrName, (CharSequence)ATTRIBUTE_ID)) {
                    icsSettingDto.setId(attrValue);
                }
                if (!StringUtils.equals((CharSequence)attrName, (CharSequence)ATTRIBUTE_LIBPATH)) continue;
                icsSettingDto.setLibPath(attrValue);
            }
            list.add(icsSettingDto);
        }
        return list;
    }

    public static synchronized void addSettingDocument(DocumentSettingDto documentSettingDto) {
        Document document;
        if (StringUtils.isBlank((CharSequence)documentSettingDto.getLibPath())) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Other libPath is blank.");
            return;
        }
        File file = FileUtils.getFile((String[])new String[]{DOCUMENT_SETTING_FILE_PATH});
        if (!file.exists()) {
            DocumentSettingParser.createSettingXml(DOCUMENT_SETTING_FILE_PATH);
        }
        if ((document = XmlDom4jUtils.getDocument((String)DOCUMENT_SETTING_FILE_PATH)) == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get DocumentSetting error.");
            return;
        }
        Element rootElement = document.getRootElement();
        Element element = rootElement.addElement(TAG_LIBINFO);
        element.addAttribute(ATTRIBUTE_LIBPATH, documentSettingDto.getLibPath());
        element.addAttribute(ATTRIBUTE_ID, documentSettingDto.getId());
        XmlDom4jUtils.writeXml((Document)document, (String)DOCUMENT_SETTING_FILE_PATH);
    }

    private static void createSettingXml(String filePath) {
        Document document = DocumentHelper.createDocument();
        document.addElement(SETTINGS_FILE_ROOT);
        XmlDom4jUtils.writeXml((Document)document, (String)filePath);
    }

    public static synchronized boolean deleteSettingDocument(String id) {
        Document document = XmlDom4jUtils.getDocument((String)DOCUMENT_SETTING_FILE_PATH);
        if (document == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get DocumentSetting error.");
            return false;
        }
        Element rootElement = document.getRootElement();
        List elements = rootElement.elements();
        if (CollectionUtils.isEmpty((Collection)elements)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Element of DocumentSetting is blank.");
            return false;
        }
        boolean isDeleteSuccess = false;
        for (Element element : elements) {
            Attribute attribute = element.attribute(ATTRIBUTE_ID);
            if (attribute == null || !id.equals(attribute.getValue())) continue;
            String deletePath = element.attribute(ATTRIBUTE_LIBPATH).getValue();
            element.getParent().remove(element);
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Delete the document path: [{0}].", new Object[]{deletePath});
            isDeleteSuccess = true;
        }
        if (isDeleteSuccess) {
            XmlDom4jUtils.writeXml((Document)document, (String)DOCUMENT_SETTING_FILE_PATH);
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Write the newest data to DocumentSetting.");
        }
        return isDeleteSuccess;
    }
}

