/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.preferences.serviceimpl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.CustomSslException;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icscbb.util.zipfile.ZipFileUtils;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkConnServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.preferences.constant.CrlUpgradeConstants;
import com.huawei.support.icslite.business.preferences.dto.CrlConfigDo;
import com.huawei.support.icslite.business.preferences.dto.CrlInfoDto;
import com.huawei.support.icslite.business.preferences.dto.mapper.CrlConverter;
import com.huawei.support.icslite.business.preferences.service.CrlUpdateService;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.wsf.core.HWEncoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class CrlUpdateServiceHandler
implements CrlUpdateService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(CrlUpdateServiceHandler.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private CrlUpdateServiceHandler() {
    }

    public static CrlUpdateServiceHandler getInstance() {
        return CrlUpdateServiceHandlerHolder.INSTANCE;
    }

    @Override
    public boolean updateCrlAuto(String isAuto) {
        boolean isSuccess = ConfigServiceHandler.getInstance().set("crl.autoUpgrade", isAuto);
        if (isSuccess) {
            OperationLogUtils.INSTANCE.successOperationLog("icslite-business-service", "UPDATE", "change crl auto update success.");
        } else {
            CodeCCUtils.INSTANCE.errorLog(LOG, "change crl auto update failed.");
            OperationLogUtils.INSTANCE.failOperationLog("icslite-business-service", "UPDATE", "change crl auto update failed");
        }
        return isSuccess;
    }

    @Override
    public CrlInfoDto getCrlConfigInfo() {
        CrlInfoDto crlInfoDto = CrlConverter.INSTANCE.domainDto(this.getCrlConfigInfo(true));
        crlInfoDto.setAutoUpgrade(HWEncoder.encodeForHTML((String)crlInfoDto.getAutoUpgrade()));
        crlInfoDto.setDownloadUrl(HWEncoder.encodeForHTML((String)crlInfoDto.getDownloadUrl()));
        crlInfoDto.setPath(HWEncoder.encodeForHTML((String)crlInfoDto.getPath()));
        crlInfoDto.setLastModifyDate(HWEncoder.encodeForHTML((String)crlInfoDto.getLastModifyDate()));
        return crlInfoDto;
    }

    public CrlConfigDo getCrlConfigInfo(boolean isContainRoot) {
        CrlConfigDo crlConfigDo = new CrlConfigDo();
        crlConfigDo.setDownloadUrl(ConfigServiceHandler.getInstance().get("crl.download.Url"));
        crlConfigDo.setVersion(ConfigServiceHandler.getInstance().get("crl.version"));
        crlConfigDo.setPath(isContainRoot ? CrlUpgradeConstants.USER_CRL_FILE : CrlUpgradeConstants.CRL_NOTROOT_PATH);
        crlConfigDo.setLastModifyDate(ConfigServiceHandler.getInstance().get("crl.lastModifyDate"));
        crlConfigDo.setAutoUpgrade(ConfigServiceHandler.getInstance().get("crl.autoUpgrade"));
        crlConfigDo.setUpdateStatus(ConfigServiceHandler.getInstance().get("crl.updateStatus"));
        return crlConfigDo;
    }

    @Override
    public void initCrlConfig() {
        LocalDate localDate;
        long modifiedTime;
        File defaultFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.DEFAULT_CRL_FILE});
        if (!defaultFile.exists()) {
            return;
        }
        String version = UrlDataServiceHandler.getInstance().getUrlEntry(null, "crlVersion", false);
        if (StringUtils.isNotBlank((CharSequence)version) && !defaultFile.setLastModified(modifiedTime = (localDate = LocalDate.parse(version, DATE_FORMATTER)).atStartOfDay().toInstant(ZoneOffset.of("+8")).toEpochMilli())) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "update default crl updateTime fail.");
        }
        File useFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.SYS_CRL_FILE});
        File userFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.USER_CRL_FILE});
        this.initCrlFile(defaultFile, useFile, CrlUpgradeConstants.SYS_CRL_STORE_PATH);
        this.initCrlFile(defaultFile, userFile, CrlUpgradeConstants.USER_CRL_STORE_PATH);
        ConfigServiceHandler.getInstance().set("crl.download.Url", UrlDataServiceHandler.getInstance().getUrlFromConfig("crlUrl.v2"));
    }

    @Override
    public String getCrlAbsolutePath() {
        CrlConfigDo crlConfigDo = this.getCrlConfigInfo(false);
        if ("1".equals(crlConfigDo.getUpdateStatus())) {
            return this.synSuccessUpdate();
        }
        return this.synFailSecondUpdate(crlConfigDo);
    }

    @Override
    public void scheduleCrlUpdate() {
        CrlConfigDo crlConfigDo = this.getCrlConfigInfo(false);
        if (StringUtils.equals((CharSequence)"0", (CharSequence)crlConfigDo.getAutoUpgrade())) {
            return;
        }
        if (NetworkConnServiceHandler.getInstance().isClosed()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "network not open when schedule update crl.");
            return;
        }
        try {
            HttpClientDto httpClientDto = NetworkServiceHandler.getInstance().getHttpClientForHuawei();
            this.updateCrlFile(httpClientDto, crlConfigDo);
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "get httpClientDto failed when schedule update crl.", (Throwable)e);
        }
        catch (CustomSslException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "scheduleCrlUpdate has CustomSslException", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCrlFile(HttpClientDto httpClientDto, CrlConfigDo crlConfigDo) {
        String crlUrl = UrlDataServiceHandler.getInstance().getDomainByScene("DOWNLOAD.NGINX") + UrlDataServiceHandler.getInstance().getUrlEntry(httpClientDto, "crlUrl.v2", true);
        String crlVersion = UrlDataServiceHandler.getInstance().getUrlEntry(httpClientDto, "crlVersion", true);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{crlUrl, crlVersion})) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "online crl url or version is null.");
            return;
        }
        if (StringUtils.equals((CharSequence)crlVersion, (CharSequence)crlConfigDo.getVersion())) {
            if ("1".equals(crlConfigDo.getUpdateStatus())) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "crl is lastest, not require update.");
                return;
            }
            crlConfigDo.setDownloadUrl(crlUrl);
            File autoFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.AUTO_DOWNLOAD_FILE});
            if (autoFile.exists()) {
                this.synFailSecondUpdate(crlConfigDo);
                return;
            }
        }
        this.clearOldCrlOrZip();
        if (!this.downloadFile(httpClientDto, crlUrl, CrlUpgradeConstants.AUTO_DOWNLOAD_PATH, "libsign.zip")) {
            this.autoUpdateFail(crlUrl, crlVersion);
            CodeCCUtils.INSTANCE.errorLog(LOG, "download newest crl file failed.");
            return;
        }
        try {
            boolean isUnzip = this.unZipCrl(CrlUpgradeConstants.AUTO_DOWNLOAD_ZIP, CrlUpgradeConstants.CRL_UNZIP_PATH);
            if (!isUnzip) {
                this.autoUpdateFail(crlUrl, crlVersion);
                CodeCCUtils.INSTANCE.errorLog(LOG, "unzip crl zip failed.");
                return;
            }
            this.autoUpdate(crlUrl, crlVersion);
        }
        finally {
            this.clearOldCrlOrZip();
        }
    }

    private void initCrlFile(File defaultFile, File file, String filePath) {
        if (file.exists()) {
            return;
        }
        try {
            File dirFile = FileUtils.getFile((String[])new String[]{filePath});
            if (dirFile.exists()) {
                FileUtils.copyFileToDirectory((File)defaultFile, (File)dirFile);
                return;
            }
            if (!dirFile.mkdirs()) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "user crl dir create failed.");
                return;
            }
            FileUtils.copyFileToDirectory((File)defaultFile, (File)dirFile);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "user crl copy error.", (Throwable)e);
        }
    }

    public String synSuccessUpdate() {
        try {
            File userFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.USER_CRL_FILE});
            if (userFile.exists()) {
                File sysFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.SYS_CRL_FILE});
                if (!sysFile.exists()) {
                    File dirPath = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.SYS_CRL_STORE_PATH});
                    FileUtils.copyFileToDirectory((File)userFile, (File)dirPath);
                    CodeCCUtils.INSTANCE.infoLog(LOG, "copy user crl to sys crl success.");
                    return CrlUpgradeConstants.SYS_CRL_FILE;
                }
                if (userFile.lastModified() > sysFile.lastModified()) {
                    FileUtils.copyFile((File)userFile, (File)sysFile);
                    CodeCCUtils.INSTANCE.infoLog(LOG, "user crl to sys crl update success.");
                }
                return CrlUpgradeConstants.SYS_CRL_FILE;
            }
            File defaultFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.DEFAULT_CRL_FILE});
            if (!defaultFile.exists()) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "default crl file not exists error.");
                return "";
            }
            File userDir = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.USER_CRL_STORE_PATH});
            FileUtils.copyFileToDirectory((File)defaultFile, (File)userDir);
            File sysFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.SYS_CRL_FILE});
            if (sysFile.exists()) {
                return CrlUpgradeConstants.SYS_CRL_FILE;
            }
            File sysDir = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.SYS_CRL_STORE_PATH});
            FileUtils.copyFileToDirectory((File)defaultFile, (File)sysDir);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "synchronize sys crl error.", (Throwable)e);
        }
        return CrlUpgradeConstants.SYS_CRL_FILE;
    }

    public String synFailSecondUpdate(CrlConfigDo crlConfigDo) {
        try {
            File autoFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.AUTO_DOWNLOAD_FILE});
            File userCrlFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.USER_CRL_FILE});
            File sysCrlFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.SYS_CRL_FILE});
            if (autoFile.exists()) {
                if (userCrlFile.exists()) {
                    userCrlFile = userCrlFile.lastModified() > autoFile.lastModified() ? userCrlFile : autoFile;
                }
                FileUtils.copyFile((File)userCrlFile, (File)sysCrlFile);
                this.clearOldCrlOrZip();
                crlConfigDo.setUpdateStatus("1");
                crlConfigDo.setLastModifyDate(this.getNowDateStr());
                if (this.updateProperties(crlConfigDo)) {
                    CodeCCUtils.INSTANCE.infoLog(LOG, "second update crl success.");
                }
            } else if (userCrlFile.lastModified() > sysCrlFile.lastModified()) {
                FileUtils.copyFile((File)userCrlFile, (File)sysCrlFile);
                CodeCCUtils.INSTANCE.infoLog(LOG, "user handle update crl success.");
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "re-synchronize sys crl error.", (Throwable)e);
        }
        return CrlUpgradeConstants.SYS_CRL_FILE;
    }

    public void autoUpdateFail(String crlUrl, String crlVersion) {
        ConfigServiceHandler.getInstance().set("crl.download.Url", crlUrl);
        ConfigServiceHandler.getInstance().set("crl.version", crlVersion);
        ConfigServiceHandler.getInstance().set("crl.updateStatus", "0");
    }

    public void autoUpdateSuccess(String crlUrl, String crlVersion) {
        ConfigServiceHandler.getInstance().set("crl.download.Url", crlUrl);
        ConfigServiceHandler.getInstance().set("crl.version", crlVersion);
        ConfigServiceHandler.getInstance().set("crl.updateStatus", "1");
        ConfigServiceHandler.getInstance().set("crl.lastModifyDate", this.getNowDateStr());
    }

    public String getNowDateStr() {
        LocalDateTime localDateTime = LocalDateTime.now();
        return localDateTime.format(DATE_TIME_FORMATTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoUpdate(String crlUrl, String crlVersion) {
        File unzipFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.AUTO_DOWNLOAD_FILE});
        File sysDir = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.SYS_CRL_STORE_PATH});
        if (!unzipFile.exists()) {
            this.autoUpdateFail(crlUrl, crlVersion);
            return;
        }
        try {
            FileUtils.copyFileToDirectory((File)unzipFile, (File)sysDir);
            CodeCCUtils.INSTANCE.infoLog(LOG, "autoUpdate success.");
            this.autoUpdateSuccess(crlUrl, crlVersion);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "copy download crl to sys dir error.");
        }
        finally {
            try {
                IcsFileUtils.deleteFile((File)unzipFile);
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "delete download crl error.");
            }
        }
    }

    public void clearOldCrlOrZip() {
        File zipDir = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.AUTO_DOWNLOAD_PATH});
        File crlFile = FileUtils.getFile((String[])new String[]{CrlUpgradeConstants.AUTO_DOWNLOAD_FILE});
        try {
            if (zipDir.exists()) {
                IcsFileUtils.deleteFile((File)zipDir);
            }
            if (crlFile.exists()) {
                IcsFileUtils.deleteFile((File)crlFile);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "delete old crl file or zip failed.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean downloadFile(HttpClientDto httpClientDto, String downloadUrl, String fileDir, String fileName) {
        HttpClientDto build = httpClientDto.newBuilder().url(downloadUrl).build();
        try (InputStream inputStream = NetWorkUtil.getInputStream((HttpClientDto)build);){
            if (inputStream == null) {
                boolean bl = false;
                return bl;
            }
            boolean isSuccess = NetWorkUtil.writeFile((String)fileDir, (String)fileName, (InputStream)inputStream);
            if (isSuccess) return true;
            CodeCCUtils.INSTANCE.errorLog(LOG, "auto download crl file error");
            boolean bl = false;
            return bl;
        }
        catch (DownloadException | IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Get InputStream error.", e);
            return false;
        }
    }

    private boolean unZipCrl(String zipFilePath, String unzipDir) {
        File zipFile = FileUtils.getFile((String[])new String[]{zipFilePath});
        if (!zipFile.exists()) {
            return false;
        }
        return ZipFileUtils.unZip((String)zipFilePath, (String)unzipDir);
    }

    public boolean updateProperties(CrlConfigDo crlConfigDo) {
        ConfigServiceHandler.getInstance().set("crl.download.Url", crlConfigDo.getDownloadUrl());
        ConfigServiceHandler.getInstance().set("crl.version", crlConfigDo.getVersion());
        ConfigServiceHandler.getInstance().set("crl.download.savepath", crlConfigDo.getPath());
        ConfigServiceHandler.getInstance().set("crl.lastModifyDate", crlConfigDo.getLastModifyDate());
        ConfigServiceHandler.getInstance().set("crl.autoUpgrade", crlConfigDo.getAutoUpgrade());
        ConfigServiceHandler.getInstance().set("crl.updateStatus", crlConfigDo.getUpdateStatus());
        return true;
    }

    private static class CrlUpdateServiceHandlerHolder {
        private static final CrlUpdateServiceHandler INSTANCE = new CrlUpdateServiceHandler();

        private CrlUpdateServiceHandlerHolder() {
        }
    }
}

