/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.preferences.serviceimpl;

import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.business.libmanage.service.LibManageService;
import com.huawei.support.icslite.business.preferences.constant.PreferenceConstants;
import com.huawei.support.icslite.business.preferences.dao.DocumentSettingDaoHandler;
import com.huawei.support.icslite.business.preferences.dto.DocumentSettingDto;
import com.huawei.support.icslite.business.preferences.dto.DocumentSettingResponseDto;
import com.huawei.support.icslite.business.preferences.dto.VersionSettingDto;
import com.huawei.support.icslite.business.preferences.dto.mapper.DocumentSettingResponseConverter;
import com.huawei.support.icslite.business.preferences.helper.DocumentSettingHelper;
import com.huawei.support.icslite.business.preferences.service.DocumentSettingService;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.wsf.core.HWEncoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DocumentSettingServiceHandler
implements DocumentSettingService,
PreferenceConstants {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DocumentSettingServiceHandler.class);
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(DocumentSettingServiceHandler.class);
    private static final String APP_PATH_TYPE_ICS = "lastIcsAppPath";
    private static final int DEFAULT_COUNT = 1;
    private static final int MAX_COUNT = 10;
    private static final int CORE_POOL_SIZE = 1;
    private static final int KEEP_ALIVE_SECONDS = 600;
    private static final int MAX_POOL_SIZE = 30;
    private static final int QUEUE_CAPACITY = 60;

    private DocumentSettingServiceHandler() {
    }

    public static DocumentSettingServiceHandler getInstance() {
        return DocumentSettingServiceHandlerHolder.INSTANCE;
    }

    private static void getMessageOfSubProcess(InputStream inputStream, StringBuilder stringBuilder) {
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolFactory.getThreadPool((String)"ProcessMessageRunnable", (int)1, (int)600, (int)30, (int)60);
        threadPoolExecutor.execute(() -> DocumentSettingServiceHandler.messageRunnable(inputStream, stringBuilder));
    }

    private static void messageRunnable(InputStream inputStream, StringBuilder stringBuilder) {
        try (InputStreamReader reader = new InputStreamReader(inputStream, "GBK");
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Stream init error.", (Throwable)e);
        }
    }

    @Override
    public List<DocumentSettingDto> querySettings() {
        List<DocumentSettingDto> documentSettingDtos = DocumentSettingDaoHandler.INSTANCE.querySettings();
        if (CollectionUtils.isEmpty(documentSettingDtos)) {
            return documentSettingDtos;
        }
        for (DocumentSettingDto settingDto : documentSettingDtos) {
            settingDto.setLibPath(HWEncoder.encodeForHTMLAttribute((String)settingDto.getLibPath()));
        }
        return documentSettingDtos;
    }

    @Override
    public String validatePath(String libPath) {
        if (this.checkPathCount()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Out of max other libPath.");
            return "-1";
        }
        return DocumentSettingHelper.getInstance().validateSinglePath(libPath);
    }

    @Override
    public VersionSettingDto queryLastAppInfo(String key) {
        VersionSettingDto versionSettingDto = new VersionSettingDto();
        String oldAppLibraryTips = ConfigServiceHandler.getInstance().get("system.oldApp.LibraryTips");
        if (StringUtils.isNotBlank((CharSequence)oldAppLibraryTips)) {
            versionSettingDto.setOldAppLibraryTips(oldAppLibraryTips);
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return versionSettingDto;
        }
        String lastAppPath = ConfigServiceHandler.getInstance().get(key);
        if (StringUtils.isNotBlank((CharSequence)lastAppPath)) {
            versionSettingDto.setLastAppPath(lastAppPath);
        }
        return versionSettingDto;
    }

    @Override
    public void saveLastAppInfo(VersionSettingDto versionSettingDto) {
        String oldAppLibraryTips;
        String lastAppType = versionSettingDto.getLastAppType();
        if (StringUtils.isNotBlank((CharSequence)lastAppType)) {
            String lastAppPath = (String)StringUtils.defaultIfBlank((CharSequence)versionSettingDto.getLastAppPath(), (CharSequence)"");
            if (StringUtils.equals((CharSequence)APP_PATH_TYPE_ICS, (CharSequence)lastAppType)) {
                ConfigServiceHandler.getInstance().set("system.lastIcsAppPath", lastAppPath);
                ConfigServiceHandler.getInstance().remove("system.lastHdxAppPath");
            } else {
                ConfigServiceHandler.getInstance().set("system.lastHdxAppPath", lastAppPath);
                ConfigServiceHandler.getInstance().remove("system.lastIcsAppPath");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(oldAppLibraryTips = versionSettingDto.getOldAppLibraryTips()))) {
            ConfigServiceHandler.getInstance().set("system.oldApp.LibraryTips", oldAppLibraryTips);
        }
    }

    @Override
    public boolean isExistsLibPath(String canonicalPath) {
        return DocumentSettingHelper.getInstance().icsLiteMultiPathIsExit(canonicalPath);
    }

    @Override
    public List<String> getIcsLiteMultiPath() {
        return DocumentSettingHelper.getInstance().getIcsLiteMultiPath();
    }

    @Override
    public String saveSetting(String libPath) {
        return DocumentSettingHelper.getInstance().saveSetting(libPath);
    }

    private boolean checkPathCount() {
        return this.getIcsLiteMultiPath().size() + 1 > 10;
    }

    @Override
    public String getIcsLiteDefaultSettingPath() {
        return this.getDefaultLibPath();
    }

    @Override
    public boolean deleteSetting(String id) {
        if (DocumentSettingDaoHandler.INSTANCE.deleteSetting(id)) {
            OperationLogUtils.INSTANCE.successOperationLog("icslite-common", "DELETE", "Delete other settings successful.");
            this.libReInit();
            return true;
        }
        OperationLogUtils.INSTANCE.failOperationLog("icslite-common", "DELETE", "Delete other settings failed.");
        return false;
    }

    private void libReInit() {
        LibManageService libManageService = (LibManageService)SpringContextUtil.getBean((String)"libManageService");
        libManageService.reInit();
    }

    @Override
    public String getDefaultLibPath() {
        return DocumentSettingHelper.getInstance().getDefaultLibPath();
    }

    @Override
    public String confirmSettingPath(String settingPath) {
        String libPathId = this.saveSetting(settingPath);
        this.libReInit();
        return libPathId;
    }

    @Override
    public List<String> confirmDefaultPath(List<String> paths) {
        return paths.stream().filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(this::verifyCanonicalPath).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).filter(canonicalPath -> StringUtils.isBlank((CharSequence)DocumentSettingHelper.getInstance().validateSinglePath((String)canonicalPath))).collect(Collectors.toList());
    }

    @Override
    public String verifyCanonicalPath(String libPath) {
        String canonicalPath = "";
        if (!CommonConstants.PATH_PATTERN.matcher(libPath).find()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to verify the initial path.");
            return canonicalPath;
        }
        File file = FileUtils.getFile((String[])new String[]{libPath});
        if (!file.exists()) {
            return canonicalPath;
        }
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to obtain the standard path.");
            return canonicalPath;
        }
        return canonicalPath;
    }

    @Override
    public void oldAppLibraryTips(String tips) {
        VersionSettingDto versionSettingDto = new VersionSettingDto();
        versionSettingDto.setOldAppLibraryTips(tips);
        this.saveLastAppInfo(versionSettingDto);
    }

    @Override
    public String chooseDirectory() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "Startup.exe");
        commands.add("FileDirSelect:");
        StringBuilder stringBuilder = new StringBuilder();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(commands);
            Process process = processBuilder.start();
            DocumentSettingServiceHandler.getMessageOfSubProcess(process.getInputStream(), stringBuilder);
            StringBuilder errStringBuilder = new StringBuilder();
            DocumentSettingServiceHandler.getMessageOfSubProcess(process.getErrorStream(), errStringBuilder);
            int retCode = process.waitFor();
            if (retCode != 0) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "The process of choose directory exception end. Err msg: {0}", new Object[]{errStringBuilder.toString()});
            }
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Choose Directory error.", (Throwable)e);
        }
        return stringBuilder.toString();
    }

    @Override
    public Map<String, String> settingDefaultLibPath(String canonicalPath) {
        LinkedHashMap<String, String> oldLibPathMap = new LinkedHashMap<String, String>();
        if (StringUtils.equals((CharSequence)canonicalPath, (CharSequence)this.getDefaultLibPath())) {
            oldLibPathMap.put("errorCode", "0");
            return oldLibPathMap;
        }
        if (this.checkPathCount()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Out of max other libPath.");
            oldLibPathMap.put("errorCode", "-1");
            return oldLibPathMap;
        }
        oldLibPathMap.putAll(DocumentSettingHelper.getInstance().settingDefaultLibPathAndCheck(canonicalPath));
        this.libReInit();
        return oldLibPathMap;
    }

    @Override
    public List<DocumentSettingResponseDto> getOtherLibPath() {
        return DocumentSettingResponseConverter.INSTANCE.domainDtos(this.querySettings());
    }

    @Override
    public DocumentSettingResponseDto getDefaultLibPathResponseDto() {
        DocumentSettingResponseDto documentSettingResponseDto = new DocumentSettingResponseDto();
        String defaultLibPath = this.getDefaultLibPath();
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "ICS Lite default document path is :[{0}].", new Object[]{defaultLibPath});
        documentSettingResponseDto.setLibPath(HWEncoder.encodeForHTML((String)defaultLibPath));
        return documentSettingResponseDto;
    }

    private static class DocumentSettingServiceHandlerHolder {
        private static final DocumentSettingServiceHandler INSTANCE = new DocumentSettingServiceHandler();

        private DocumentSettingServiceHandlerHolder() {
        }
    }
}

