/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.preferences.serviceimpl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.preferences.dto.DownloadSettingDto;
import com.huawei.support.icslite.business.preferences.service.DownloadSettingService;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.File;
import java.util.Date;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadSettingServiceHandler
implements DownloadSettingService {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadSettingServiceHandler.class);
    private static final int KB = 1024;
    private static final Timer TIMER = new Timer("downloadRateTimer");
    private int speedRateSetting = 0;
    private int speedRateSecondLeft = 0;
    private volatile boolean isStart = false;
    private ReentrantLock downloadRateLock = new ReentrantLock();
    private Condition downloadRateCondition = this.downloadRateLock.newCondition();
    private TimerTask timerTask = null;

    private DownloadSettingServiceHandler() {
        if (StringUtils.equals((CharSequence)ConfigServiceHandler.getInstance().get("download.control.speed.type"), (CharSequence)"1")) {
            this.openDownloadRate(Integer.parseInt(ConfigServiceHandler.getInstance().get("download.control.speed")));
        }
    }

    public static DownloadSettingServiceHandler getInstance() {
        return DownloadSettingServiceHandlerHolder.INSTANCE;
    }

    @Override
    public DownloadSettingDto getDlConfig() {
        String downloadPath = ConfigServiceHandler.getInstance().get("download.file.savepath");
        downloadPath = (String)StringUtils.defaultIfBlank((CharSequence)downloadPath, (CharSequence)this.getDefaultDlDir());
        String concurrencyNum = ConfigServiceHandler.getInstance().get("download.max.concurrency.number");
        String downloadSpeed = ConfigServiceHandler.getInstance().getOrSetDefault("download.control.speed", "");
        String downloadSpeedType = ConfigServiceHandler.getInstance().getOrSetDefault("download.control.speed.type", "0");
        return new DownloadSettingDto(downloadPath, concurrencyNum, downloadSpeed, downloadSpeedType);
    }

    public String getDefaultDlDir() {
        String defaultPath = IcsCommonServiceHandler.getInstance().getComponentFilePath("userdata", "temp" + File.separator + "download");
        File file = FileUtils.getFile((String[])new String[]{defaultPath});
        if (file.exists() || file.mkdirs()) {
            return defaultPath;
        }
        CodeCCUtils.INSTANCE.errorLog(log, "Create default download dir fail.");
        return "";
    }

    @Override
    public long getConfigRate() {
        if (StringUtils.equals((CharSequence)ConfigServiceHandler.getInstance().get("download.control.speed.type"), (CharSequence)"1")) {
            return Long.parseLong(ConfigServiceHandler.getInstance().get("download.control.speed")) * 1024L;
        }
        return 0L;
    }

    @Override
    public void openDownloadRate(int inputRate) {
        OperationLogUtils.INSTANCE.successOperationLog("icslite-common", "SAVE", "The download config save dl speed is change.");
        this.downloadRateLock.lock();
        try {
            this.cancelTimerTask();
            TIMER.purge();
            this.isStart = true;
            this.speedRateSetting = inputRate * 1024;
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    DownloadSettingServiceHandler.this.downloadRateLock.lock();
                    try {
                        DownloadSettingServiceHandler.this.speedRateSecondLeft = DownloadSettingServiceHandler.this.speedRateSetting;
                        DownloadSettingServiceHandler.this.downloadRateCondition.signalAll();
                    }
                    finally {
                        DownloadSettingServiceHandler.this.downloadRateLock.unlock();
                    }
                }
            };
            TIMER.schedule(this.timerTask, new Date(), 1000L);
            CodeCCUtils.INSTANCE.infoLog(log, "Open download rate task is success,settings rate is {0}", new Object[]{this.speedRateSetting});
        }
        finally {
            this.downloadRateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLeftBufferSize(int bufferSize) {
        this.downloadRateLock.lock();
        int bufSize = bufferSize;
        try {
            while (this.speedRateSecondLeft == 0) {
                this.downloadRateCondition.await();
            }
            if (bufSize > this.speedRateSecondLeft) {
                bufSize = this.speedRateSecondLeft;
            }
            this.speedRateSecondLeft -= bufSize;
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.warnLog(log, "GetLeftBufferSize await has interruptedException");
        }
        finally {
            this.downloadRateLock.unlock();
        }
        return bufSize;
    }

    @Override
    public void closeDownloadRate() {
        this.downloadRateLock.lock();
        try {
            this.isStart = false;
            this.cancelTimerTask();
            this.speedRateSecondLeft = Integer.MAX_VALUE;
            this.downloadRateCondition.signalAll();
        }
        finally {
            this.downloadRateLock.unlock();
        }
    }

    private void cancelTimerTask() {
        if (Objects.nonNull(this.timerTask)) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    @Override
    public boolean isOpenDownloadRate() {
        return this.isStart;
    }

    private static class DownloadSettingServiceHandlerHolder {
        private static final DownloadSettingServiceHandler INSTANCE = new DownloadSettingServiceHandler();

        private DownloadSettingServiceHandlerHolder() {
        }
    }
}

