/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.preferences.serviceimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icslite.business.common.dto.UrlDataDto;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.preferences.dto.MessageDataDto;
import com.huawei.support.icslite.business.preferences.service.MessageService;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.wsf.core.HWEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class MessageServiceHandler
implements MessageService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(MessageServiceHandler.class);
    private static final int MAX_RESULT = 10;
    private static final int RESULT = -1;
    private static final String MESSAGE_TITLE_KEY = "Title";
    private static final String MESSAGE_CONTENT_KEY = "Content";
    private static final String MESSAGE_PUBLISH_TIME_KEY = "PublishTime";
    private static final String MESSAGE_SPLICING = ":00";
    private HttpClientDto httpClient;

    private MessageServiceHandler() {
    }

    public static MessageServiceHandler getInstance() {
        return MessageServiceHandlerHolder.INSTANCE;
    }

    @Override
    public List<Map<String, String>> getMessage(HttpClientDto httpClientDto, String url) {
        List<Map<String, String>> listObjectSec;
        String context = this.getContext(httpClientDto, url);
        try {
            listObjectSec = this.parseMessage(context);
        }
        catch (JSONException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Software message parse failed.");
            return null;
        }
        if (CollectionUtils.isEmpty(listObjectSec)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The software message is empty.");
            return null;
        }
        List<Map<String, String>> newList = new ArrayList<Map<String, String>>();
        this.setMessageData(listObjectSec, newList);
        if (CollectionUtils.isNotEmpty(newList) && newList.size() >= 10) {
            newList = newList.subList(0, 10);
        }
        return newList;
    }

    private List<Map<String, String>> parseMessage(String context) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            JSONArray messageJsonArray = JSON.parseArray((String)context);
            if (messageJsonArray == null) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "The parsing content of the message data is empty.");
                return Lists.newArrayList();
            }
            if (messageJsonArray.size() <= 0) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "The message data parsing list is empty.");
                return Lists.newArrayList();
            }
            for (Object messageObject : messageJsonArray) {
                if (!(messageObject instanceof JSONObject)) continue;
                JSONObject messageJsonObject = (JSONObject)messageObject;
                HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
                objectObjectHashMap.put(MESSAGE_TITLE_KEY, (String)messageJsonObject.get((Object)MESSAGE_TITLE_KEY));
                objectObjectHashMap.put(MESSAGE_CONTENT_KEY, (String)messageJsonObject.get((Object)MESSAGE_CONTENT_KEY));
                objectObjectHashMap.put(MESSAGE_PUBLISH_TIME_KEY, (String)messageJsonObject.get((Object)MESSAGE_PUBLISH_TIME_KEY));
                result.add(objectObjectHashMap);
            }
            return result;
        }
        catch (JSONException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Software message parse failed.");
            return Lists.newArrayList();
        }
    }

    private void setMessageData(List<Map<String, String>> listObjectSec, List<Map<String, String>> newList) {
        for (Map<String, String> mapList : listObjectSec) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : mapList.entrySet()) {
                if (StringUtils.equals((CharSequence)entry.getKey(), (CharSequence)MESSAGE_TITLE_KEY) || StringUtils.equals((CharSequence)entry.getKey(), (CharSequence)MESSAGE_CONTENT_KEY)) {
                    map.put(entry.getKey(), this.enCode(entry.getValue()));
                    continue;
                }
                map.put(entry.getKey(), entry.getValue());
            }
            newList.add(map);
        }
        Collections.sort(newList, (o1, o2) -> {
            Date dt2;
            Date dt1 = this.getDate((String)o1.get(MESSAGE_PUBLISH_TIME_KEY));
            if (dt1.before(dt2 = this.getDate((String)o2.get(MESSAGE_PUBLISH_TIME_KEY)))) {
                return 1;
            }
            return -1;
        });
    }

    private Date getDate(String publishTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        try {
            date = format.parse(publishTime.concat(MESSAGE_SPLICING));
        }
        catch (ParseException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Time format parse error", (Throwable)e);
        }
        return date;
    }

    private String getContext(HttpClientDto httpClientDto, String url) {
        String context = "";
        if (StringUtils.isBlank((CharSequence)url)) {
            return context;
        }
        HttpClientDto build = httpClientDto.newBuilder().url(url).build();
        try {
            context = NetWorkUtil.get((HttpClientDto)build);
        }
        catch (DownloadException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "response is failed.", (Throwable)e);
        }
        return context;
    }

    private String enCode(String value) {
        return HWEncoder.encodeForHTML((String)value);
    }

    @Override
    public List<MessageDataDto> getMessageData() {
        try {
            this.httpClient = NetworkServiceHandler.getInstance().getHttpClientForHuawei();
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "failed to get the httpClient.", (Throwable)e);
            return Collections.emptyList();
        }
        UrlDataDto urlDataDto = StringUtils.equals((CharSequence)"en", (CharSequence)ConfigServiceHandler.getInstance().get("system.lang")) ? UrlDataServiceHandler.getInstance().getUrl(this.httpClient, "ClientInfoList_en", true) : UrlDataServiceHandler.getInstance().getUrl(this.httpClient, "ClientInfoList_zh", true);
        if (urlDataDto == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The main address of the software message is empty.");
            return Collections.emptyList();
        }
        List<Map<String, String>> messageList = this.getMessage(this.httpClient, urlDataDto.getMainUrl());
        if (CollectionUtils.isEmpty(messageList)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The software message list is empty.");
            return Collections.emptyList();
        }
        ArrayList<MessageDataDto> list = new ArrayList<MessageDataDto>();
        for (Map<String, String> objectMap : messageList) {
            if (MapUtils.isEmpty(objectMap)) continue;
            String publishTime = String.valueOf(objectMap.get(MESSAGE_PUBLISH_TIME_KEY));
            String title = String.valueOf(objectMap.get(MESSAGE_TITLE_KEY));
            String content = String.valueOf(objectMap.get(MESSAGE_CONTENT_KEY));
            MessageDataDto messageDataDto = new MessageDataDto();
            messageDataDto.setPublishTime(publishTime);
            messageDataDto.setTitle(title);
            messageDataDto.setContent(content);
            list.add(messageDataDto);
        }
        return list;
    }

    private static class MessageServiceHandlerHolder {
        private static final MessageServiceHandler INSTANCE = new MessageServiceHandler();

        private MessageServiceHandlerHolder() {
        }
    }
}

