/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.preferences.serviceimpl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.common.dto.AboutDataDto;
import com.huawei.support.icslite.business.common.dto.ModelDataDto;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.preferences.dto.DownloadSettingDto;
import com.huawei.support.icslite.business.preferences.service.PreferencesService;
import com.huawei.support.icslite.business.preferences.serviceimpl.DownloadSettingServiceHandler;
import com.huawei.support.icslite.common.constant.RegistryConstants;
import com.huawei.support.icslite.common.resources.software.dto.SoftwareDto;
import com.huawei.support.icslite.common.resources.utils.CmdCharacterUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.common.utils.WinRegistryUtil;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class PreferencesServiceHandler
implements PreferencesService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(PreferencesServiceHandler.class);
    private static final String DEFAULT_HOME_PAGE = "findsoftware";
    private boolean shouldIeRemind = true;

    private PreferencesServiceHandler() {
    }

    public static PreferencesServiceHandler getInstance() {
        return PreferencesBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public AboutDataDto getAboutData() {
        AboutDataDto aboutDataDto = new AboutDataDto();
        SoftwareDto softwareInfo = IcsCommonServiceHandler.getInstance().getSoftwareInfo();
        if (softwareInfo != null) {
            aboutDataDto.setSoftVersion(softwareInfo.getSoftVersion());
            aboutDataDto.setPublishTime(softwareInfo.getPublishTime());
        }
        return aboutDataDto;
    }

    @Override
    public boolean saveBasicSettingUrl(String httpIpInfo) {
        return ConfigServiceHandler.getInstance().set("system.open.httpIpInfo", httpIpInfo);
    }

    @Override
    public String getBasicSettingUrl() {
        return ConfigServiceHandler.getInstance().get("system.open.httpIpInfo");
    }

    @Override
    public ModelDataDto getModelData() {
        ModelDataDto modelDataDto = new ModelDataDto();
        modelDataDto.setLanguage(ConfigServiceHandler.getInstance().get("system.lang"));
        modelDataDto.setResourcePath(ConfigServiceHandler.getInstance().get("system.resourcePath"));
        return modelDataDto;
    }

    @Override
    public String saveDownloadDir(String downloadDir) throws IOException {
        if (StringUtils.isBlank((CharSequence)downloadDir)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Save DlConfig fail, downloadDir is null.");
            return "";
        }
        String downloadDirVal = StringUtils.isBlank((CharSequence)downloadDir) ? DownloadSettingServiceHandler.getInstance().getDefaultDlDir() : FileUtils.getFile((String[])new String[]{downloadDir}).getCanonicalPath();
        File file = FileUtils.getFile((String[])new String[]{downloadDirVal});
        if (!file.exists()) {
            throw new IOException("File dir is not exist.");
        }
        ConfigServiceHandler.getInstance().set("download.file.savepath", downloadDirVal);
        OperationLogUtils.INSTANCE.successOperationLog("icslite-common", "DOWNLOAD-DIR-CHANGED", "The download config property downloadDir is changed.");
        return downloadDirVal;
    }

    @Override
    public void saveDownloadNum(String downloadNum) {
        if (StringUtils.isBlank((CharSequence)downloadNum)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Save DlConfig fail, downloadNum is null.");
            return;
        }
        ConfigServiceHandler.getInstance().set("download.max.concurrency.number", downloadNum);
        OperationLogUtils.INSTANCE.successOperationLog("icslite-common", "DOWNLOAD-DIR-CHANGED", "The download config property downloadNum is changed.");
    }

    @Override
    public DownloadSettingDto getDownloadConfig() {
        return DownloadSettingServiceHandler.getInstance().getDlConfig();
    }

    @Override
    public String getIsAutoRun() {
        String autoRunStatus = WinRegistryUtil.queryWinRegistryValueContent((String)RegistryConstants.LITE_REGISTY_PATH, (String)"IsAllowedAutoRun", (String)"REG_SZ");
        if (StringUtils.isNotBlank((CharSequence)autoRunStatus)) {
            return autoRunStatus;
        }
        WinRegistryUtil.modifyWinRegistry((String)RegistryConstants.LITE_REGISTY_PATH, (String)"IsAllowedAutoRun", (String)"REG_SZ", (String)"0");
        return "0";
    }

    @Override
    public boolean setIsAutoRun(String isAutoRun) {
        WinRegistryUtil.deleteWinRegistry((String)RegistryConstants.LITE_REGISTY_PATH, (String)"IsAllowedAutoRun");
        if (!WinRegistryUtil.modifyWinRegistry((String)RegistryConstants.LITE_REGISTY_PATH, (String)"IsAllowedAutoRun", (String)"REG_SZ", (String)isAutoRun)) {
            return false;
        }
        boolean isSuccess = WinRegistryUtil.deleteWinRegistry((String)RegistryConstants.REGISTY_WINDOWS_RUN_PATH, (String)"IcsLite");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)isAutoRun)) {
            String autoRunPath = CmdCharacterUtils.getAutoRunPath();
            isSuccess = WinRegistryUtil.modifyWinRegistry((String)RegistryConstants.REGISTY_WINDOWS_RUN_PATH, (String)"IcsLite", (String)"REG_SZ", (String)autoRunPath);
        }
        OperationLogUtils.INSTANCE.successOperationLog("AutoRun", "UPDATE", "set AutoRun status.");
        return isSuccess;
    }

    @Override
    public String getAutoLoginSwitchStatus() {
        return ConfigServiceHandler.getInstance().getOrSetDefault("auth.cs.auto.login.switch.status", "0");
    }

    @Override
    public boolean hasUpdatedAutoLoginSwitchStatus(String isAutoLogin) {
        return this.updateAutoLoginConfig("Switch Status", "auth.cs.auto.login.switch.status", isAutoLogin);
    }

    @Override
    public boolean hasUpdatedAutoLoginRemindStatus(String isRemind) {
        return this.updateAutoLoginConfig("Dialog Remind Status", "auth.cs.auto.login.dialog.remind", isRemind);
    }

    private boolean updateAutoLoginConfig(String configDesc, String configKey, String configValue) {
        boolean isSuccess = ConfigServiceHandler.getInstance().set(configKey, configValue);
        if (isSuccess) {
            OperationLogUtils.INSTANCE.successOperationLog("AUTHORIZATION", "UPDATE", "set AutoLogIn {0} : {1}.", new Object[]{configDesc, configValue});
        } else {
            OperationLogUtils.INSTANCE.failOperationLog("AUTHORIZATION", "UPDATE", "set AutoLogIn {0} : {1}.", new Object[]{configDesc, configValue});
        }
        return isSuccess;
    }

    @Override
    public boolean isAutoLoginRemind() {
        return StringUtils.equals((CharSequence)ConfigServiceHandler.getInstance().getOrSetDefault("auth.cs.auto.login.dialog.remind", "0"), (CharSequence)"0");
    }

    @Override
    public void saveMaxRetryNum(String retryNum) {
        if (StringUtils.isBlank((CharSequence)retryNum)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "SaveMaxRetryNum fail, retryNum is null.");
            return;
        }
        ConfigServiceHandler.getInstance().set("download.max.retry.times", retryNum);
        OperationLogUtils.INSTANCE.successOperationLog("icslite-common", "DOWNLOAD-DIR-CHANGED", "The download config property failMaxRetryNum is changed.");
    }

    @Override
    public List<Map<String, String>> getSelectedServerDomain() {
        HashMap<String, String> resultHashMap = new HashMap<String, String>();
        resultHashMap.put("selectedServerDomain", UrlDataServiceHandler.getInstance().getUrlEntry(null, "available.domains", true));
        resultHashMap.put("currentServerDomain", "*" + ConfigServiceHandler.getInstance().get("server.domain.suffix"));
        return Arrays.asList(resultHashMap);
    }

    @Override
    public boolean saveSelectedServerDomain(String selectedDomain) {
        return ConfigServiceHandler.getInstance().set("server.domain.suffix", selectedDomain.substring(1));
    }

    @Override
    public boolean needIeNotSupportRemind() {
        return this.shouldIeRemind;
    }

    @Override
    public void setIeRemindToFalse() {
        this.shouldIeRemind = false;
    }

    @Override
    public String getDefaultHomePage() {
        String configValue = ConfigServiceHandler.getInstance().get("default.home.page");
        return (String)StringUtils.defaultIfBlank((CharSequence)configValue, (CharSequence)DEFAULT_HOME_PAGE);
    }

    @Override
    public boolean saveHomePage(String homePageSelect) {
        OperationLogUtils.INSTANCE.successOperationLog("icslite-common", "UPDATE", "The home page is changed. {0}", new Object[]{homePageSelect});
        return ConfigServiceHandler.getInstance().set("default.home.page", homePageSelect);
    }

    @Override
    public boolean isFirstHomePage() {
        if (StringUtils.isBlank((CharSequence)ConfigServiceHandler.getInstance().get("default.home.page"))) {
            ConfigServiceHandler.getInstance().set("default.home.page", DEFAULT_HOME_PAGE);
            return true;
        }
        return false;
    }

    private static class PreferencesBusinessHandlerHolder {
        private static final PreferencesServiceHandler INSTANCE = new PreferencesServiceHandler();

        private PreferencesBusinessHandlerHolder() {
        }
    }
}

