/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.preferences.serviceimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icslite.business.preferences.service.StatementService;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import org.apache.commons.lang3.StringUtils;

public class StatementServiceHandler
implements StatementService {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(StatementServiceHandler.class);
    private static final String COPYRIGHT_DATA_KEY = "copyRightContent";

    private StatementServiceHandler() {
    }

    public static StatementServiceHandler getInstance() {
        return StatementServiceHandlerHolder.INSTANCS;
    }

    @Override
    public String getCopyRightContent() {
        return this.getContentString(CommonConstants.LOCAL_COPYRIGHT_TXT, COPYRIGHT_DATA_KEY);
    }

    private String getContentString(String relativePath, String contentDataKey) {
        String resultData = "";
        JSONObject resultDataJson = this.getJsonData(IcsCommonServiceHandler.getInstance().getAppRootDir() + relativePath);
        if (resultDataJson != null) {
            resultData = resultDataJson.getString(contentDataKey);
        }
        return resultData;
    }

    private JSONObject getJsonData(String fileName) {
        JSONObject jsonData = null;
        if (StringUtils.isBlank((CharSequence)fileName)) {
            CodeCCUtils.INSTANCE.errorLog(log, "StatementServiceHandler getJsonData : fileName is blank");
            return jsonData;
        }
        String jsonContent = IcsFileUtils.readFileContent((String)fileName, null);
        try {
            jsonData = JSON.parseObject((String)jsonContent);
        }
        catch (JSONException e) {
            if (StringUtils.endsWith((CharSequence)fileName, (CharSequence)"copyRight.json")) {
                CodeCCUtils.INSTANCE.errorLog(log, "Parse local copyRight.json file failed. ");
            }
            CodeCCUtils.INSTANCE.errorLog(log, "Parse local other file failed. ");
        }
        return jsonData;
    }

    private static final class StatementServiceHandlerHolder {
        private static final StatementServiceHandler INSTANCS = new StatementServiceHandler();

        private StatementServiceHandlerHolder() {
        }
    }
}

