/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.print.serviceimpl;

import com.huawei.support.icscbb.convert.constant.ProgressConstants;
import com.huawei.support.icscbb.convert.dto.HtmlConvertDto;
import com.huawei.support.icscbb.convert.helper.ConvertPathHelper;
import com.huawei.support.icscbb.convert.util.ProgressPropertyUtils;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.hwics.common.icspid.service.impl.IcsPidPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.sys.SystemCommandUtils;
import com.huawei.support.icslite.business.docexport.convert.IcsTopicDoConverter;
import com.huawei.support.icslite.business.docexport.convert.NaviContentDoConverter;
import com.huawei.support.icslite.business.docexport.dto.ExportBaseDto;
import com.huawei.support.icslite.business.docexport.dto.ExportDocDto;
import com.huawei.support.icslite.business.docexport.dto.ExportNodeDto;
import com.huawei.support.icslite.business.docexport.dto.ExportPortalDto;
import com.huawei.support.icslite.business.docexport.helper.ExportConvertHelper;
import com.huawei.support.icslite.business.docexport.util.HdxNaviUtils;
import com.huawei.support.icslite.business.docexport.util.IcsNaviUtils;
import com.huawei.support.icslite.business.print.constant.PrintPageConstants;
import com.huawei.support.icslite.business.print.dto.PrintResultDto;
import com.huawei.support.icslite.business.print.helper.PrintServiceHelper;
import com.huawei.support.icslite.business.print.process.PrintPreSubProcess;
import com.huawei.support.icslite.business.print.service.PrintService;
import com.huawei.support.icslite.business.print.task.PrintTask;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class PrintServiceHandler
extends PrintServiceHelper
implements PrintService {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(PrintServiceHandler.class);
    private static final int DIVIDE_SCALE = 5;
    private static final int TOPIC_FINISHED_MAX_PROGRESS = 90;
    private volatile boolean isCompleted;
    private volatile boolean isCancel;

    private PrintServiceHandler() {
    }

    public static PrintServiceHandler getInstance() {
        return PrintServiceHandlerHolder.INSTANCE;
    }

    @Override
    public boolean hasPrintTask() {
        return this.isThreadsFull();
    }

    @Override
    public PrintResultDto printPage(ExportDocDto printDocDto, String documentType) {
        Optional<PrintResultDto> validateResult = this.printPageValidate(documentType);
        if (validateResult.isPresent()) {
            return validateResult.get();
        }
        List<ExportNodeDto> nodeList = this.getPrintNodeDtoList(printDocDto, documentType);
        return this.addPrintTask(printDocDto, nodeList, documentType, (String)StringUtils.defaultIfBlank((CharSequence)printDocDto.getPidId(), (CharSequence)""));
    }

    private List<ExportNodeDto> getPrintNodeDtoList(ExportDocDto printDocDto, String documentType) {
        if (StringUtils.equals((CharSequence)documentType, (CharSequence)"ICS")) {
            return IcsTopicDoConverter.INSTANCE.topicDoListToExportList(IcsNaviUtils.getNaviListByPositions(printDocDto.getDocId(), printDocDto.getReDocId(), printDocDto.getPidId(), printDocDto.getNaviIds()));
        }
        return NaviContentDoConverter.INSTANCE.naviDoListToExportList(HdxNaviUtils.getNaviListByPositions(printDocDto.getDocId(), printDocDto.getNaviIds()));
    }

    private Optional<PrintResultDto> printPageValidate(String documentType) {
        if (this.isThreadsFull()) {
            return Optional.of(new PrintResultDto().setHasTask(true));
        }
        this.isCompleted = false;
        this.isCancel = false;
        String fileSuffix = FilenameUtils.getExtension((String)PrintPageConstants.PRINT_PAGE_PATH);
        if (!StringUtils.equalsAny((CharSequence)documentType, (CharSequence[])new CharSequence[]{"ICS", "HDX"}) || !StringUtils.equals((CharSequence)fileSuffix, (CharSequence)"html")) {
            return Optional.of(new PrintResultDto().setNormalPrint(false));
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Object> getPrintProgress() {
        String finishNum;
        String progressFileName = PrintPageConstants.PRINT_DIR + ProgressConstants.CONVERT_PROGRESS_FILE_NAME;
        File propertyFile = FileUtils.getFile((String[])new String[]{progressFileName});
        Map<String, Object> resultMap = this.validatePropertyFile(propertyFile, progressFileName);
        if (MapUtils.isNotEmpty(resultMap)) {
            return resultMap;
        }
        String totalNum = this.getConvertInfo(progressFileName, "totalNum");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{totalNum, finishNum = this.getConvertInfo(progressFileName, "finishNum")}) || StringUtils.equals((CharSequence)totalNum, (CharSequence)"0")) {
            resultMap.put("processContinue", true);
            return resultMap;
        }
        String progress = this.computeProgress(Integer.parseInt(totalNum), Integer.parseInt(finishNum));
        if (StringUtils.equals((CharSequence)progress, (CharSequence)"100")) {
            FileUtils.deleteQuietly((File)propertyFile);
        }
        resultMap.put("currentProgress", progress);
        return resultMap;
    }

    private void exitProcess() {
        SystemCommandUtils.exec((List)IcsCommonServiceHandler.getInstance().getExitCommand("icslite_print.exe"), new HashMap());
    }

    private synchronized Map<String, Object> validatePropertyFile(File propertyFile, String progressFileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (this.isCompleted) {
            resultMap.put("currentProgress", "100");
            CodeCCUtils.INSTANCE.infoLog(log, "Refresh progress and print completed.");
            return resultMap;
        }
        if (this.isCancel) {
            resultMap.put("cancelPrint", true);
            CodeCCUtils.INSTANCE.infoLog(log, "Refresh progress and print canceled.");
            this.fullyDelConvert();
            return resultMap;
        }
        if (!propertyFile.exists()) {
            CodeCCUtils.INSTANCE.errorLog(log, "Get progress but progress file not exists.");
            resultMap.put("successFlag", false);
            this.fullyDelConvert();
            this.exitProcess();
            return resultMap;
        }
        if (StringUtils.equals((CharSequence)this.getConvertInfo(progressFileName, "successFlag"), (CharSequence)"1")) {
            resultMap.put("currentProgress", "100");
            CodeCCUtils.INSTANCE.infoLog(log, "Get print progress and task completed.");
            this.isCompleted = true;
            return resultMap;
        }
        if (StringUtils.equals((CharSequence)this.getConvertInfo(progressFileName, "successFlag"), (CharSequence)"0")) {
            CodeCCUtils.INSTANCE.errorLog(log, "Get progress but process fail.");
            resultMap.put("successFlag", false);
            this.fullyDelConvert();
            this.exitProcess();
        }
        if (StringUtils.equals((CharSequence)this.getConvertInfo(progressFileName, "successFlag"), (CharSequence)"2")) {
            resultMap.put("partSave", true);
            CodeCCUtils.INSTANCE.infoLog(log, "Get print progress and the document is part saved.");
        }
        return resultMap;
    }

    private String getConvertInfo(String progressFileName, String convertKey) {
        return ProgressPropertyUtils.getConvertProgressByProperty((String)progressFileName, (String)convertKey);
    }

    @Override
    public void cancelPrint() {
        this.eventBus.post((Object)"cancelPrint");
        this.fullyDelConvert();
    }

    @Override
    public PrintResultDto portalPrintPage(ExportPortalDto printPortalDto) {
        Optional<PrintResultDto> validateResult = this.printPageValidate("ICS");
        if (validateResult.isPresent()) {
            return validateResult.get();
        }
        List<ExportNodeDto> nodeList = this.getPortalPrintNodeList(printPortalDto);
        return this.addPrintTask(printPortalDto, nodeList, "ICS", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preProcessHtml() {
        List cmdList = SystemCommandUtils.getProcessArgs(PrintPreSubProcess.class, (String)PrintPageConstants.PRINT_PROCESS_RUNNING_FILE_PATH, this.getExportProcessJvmOpts(), new ArrayList(), (List)EXCLUDE_JAR_LIST);
        ProcessBuilder builder = new ProcessBuilder(cmdList);
        Process process = null;
        int processStatus = 0;
        try {
            process = builder.start();
            processStatus = SystemCommandUtils.waitFor((Process)process, (long)this.getProcessTimeOut(), (TimeUnit)TimeUnit.MINUTES);
        }
        catch (IOException | InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "[Print]PrintSubProcess process error", (Throwable)e);
            processStatus = 1;
        }
        finally {
            if (processStatus != 0) {
                CodeCCUtils.INSTANCE.errorLog(log, "[Print]Print pre process error.");
            }
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    private List<ExportNodeDto> getPortalPrintNodeList(ExportPortalDto printPortalDto) {
        List<IcsTopicDo> icsTopicDoList = printPortalDto.getPidDtoList().stream().map(pidSaveDto -> IcsNaviUtils.getNaviListByPortalPid(printPortalDto.getDocId(), pidSaveDto.getPidDocId(), pidSaveDto.getPidId())).flatMap(Collection::stream).collect(Collectors.toList());
        return IcsTopicDoConverter.INSTANCE.topicDoListToExportList(icsTopicDoList);
    }

    private void fullyDelConvert() {
        FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{PrintPageConstants.PRINT_DIR}));
    }

    private boolean getTotalTempDir(int docNum) {
        if (!PrintServiceHelper.initConvertTempDir()) {
            return false;
        }
        String progressFileName = ConvertPathHelper.getProgressFileName((String)PrintPageConstants.PRINT_DIR);
        FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{progressFileName}));
        return ProgressPropertyUtils.initConvertProgressProperty((String)progressFileName, (String)(docNum + ""));
    }

    private String computeProgress(int totalNum, int finishNum) {
        if (finishNum >= totalNum) {
            return "90";
        }
        double progressDouble = new BigDecimal(finishNum).divide(new BigDecimal(totalNum), 5, RoundingMode.UP).multiply(new BigDecimal(90)).doubleValue();
        return String.format("%.2f", progressDouble);
    }

    private PrintResultDto addPrintTask(ExportBaseDto baseDto, List<ExportNodeDto> nodeList, String documentType, String pidId) {
        this.fullyDelConvert();
        if (CollectionUtils.isEmpty(nodeList) || !this.getTotalTempDir(nodeList.size())) {
            return new PrintResultDto().setNormalPrint(false);
        }
        return new PrintResultDto().setNormalPrint(this.isAddPrintTaskSuccess(baseDto.getDocId(), nodeList, documentType, pidId));
    }

    private boolean isAddPrintTaskSuccess(String docId, List<ExportNodeDto> nodeList, String documentType, String pidId) {
        IcsPidDo icsPidDo;
        PrintTask printTask = new PrintTask();
        HtmlConvertDto htmlConvertDto = ExportConvertHelper.exportParamsToConvertDto(PrintPageConstants.PRINT_DIR, docId, documentType, nodeList, PrintPageConstants.PRINT_PAGE_PATH);
        if (htmlConvertDto == null) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)pidId) && (icsPidDo = IcsPidPoolServiceHandler.getInstance().getOne(docId, pidId)) != null) {
            htmlConvertDto.setFileName(icsPidDo.getPidName());
        }
        printTask.setHtmlConvertDto(htmlConvertDto);
        printTask.setEventBus(this.eventBus);
        this.eventBus.register((Object)printTask);
        this.execute(printTask);
        return true;
    }

    private static class PrintServiceHandlerHolder {
        private static final PrintServiceHandler INSTANCE = new PrintServiceHandler();

        private PrintServiceHandlerHolder() {
        }
    }
}

