/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.print.task;

import com.alibaba.fastjson.JSON;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.huawei.support.icscbb.convert.constant.ProgressConstants;
import com.huawei.support.icscbb.convert.dto.HtmlConvertDto;
import com.huawei.support.icscbb.convert.util.ProgressPropertyUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.sys.SystemCommandUtils;
import com.huawei.support.icslite.business.docexport.helper.ExportProcessHelper;
import com.huawei.support.icslite.business.index.process.helper.ProcessHelper;
import com.huawei.support.icslite.business.print.constant.PrintPageConstants;
import com.huawei.support.icslite.business.print.process.PrintSubProcess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class PrintTask
extends ExportProcessHelper
implements Runnable {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(PrintTask.class);
    private HtmlConvertDto htmlConvertDto;
    private AsyncEventBus eventBus;
    private Process process;
    private String tempProgressFileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.htmlConvertDto == null) {
            CodeCCUtils.INSTANCE.errorLog(log, "PrintTask begin but htmlConvertDto is null.");
            return;
        }
        this.tempProgressFileName = this.htmlConvertDto.getTempDirectory() + ProgressConstants.CONVERT_PROGRESS_FILE_NAME;
        CodeCCUtils.INSTANCE.infoLog(log, "PrintTask start create print process.");
        int processStatus = 0;
        List cmdList = SystemCommandUtils.getProcessArgs(PrintSubProcess.class, (String)PrintPageConstants.PRINT_PROCESS_RUNNING_FILE_PATH, this.getExportProcessJvmOpts(), new ArrayList(), (List)EXCLUDE_JAR_LIST);
        ProcessBuilder builder = new ProcessBuilder(cmdList);
        try {
            this.process = builder.start();
            ProcessHelper.writeArg(this.process, JSON.toJSONString((Object)this.htmlConvertDto));
            processStatus = SystemCommandUtils.waitFor((Process)this.process, (long)this.getProcessTimeOut(), (TimeUnit)TimeUnit.MINUTES);
        }
        catch (IOException | InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "[Print]PrintSubProcess process error", (Throwable)e);
            processStatus = 1;
        }
        finally {
            this.eventBus.unregister((Object)this);
            if (processStatus == 0) {
                this.process.destroyForcibly();
                CodeCCUtils.INSTANCE.infoLog(log, "Print process normal end.");
                this.setPrintTaskFlag();
            } else {
                CodeCCUtils.INSTANCE.errorLog(log, "Print process abnormal end.");
                this.process.destroyForcibly();
                ProgressPropertyUtils.updateConvertProgressProperty((String)this.tempProgressFileName, (String)"successFlag", (String)"0");
            }
        }
        CodeCCUtils.INSTANCE.infoLog(log, "[Print]End print process, the target file is:{0}", new Object[]{this.htmlConvertDto.getSaveFileName()});
    }

    @Subscribe
    public void cancelPrintProcessEvent(String cancelMsg) {
        if (StringUtils.equals((CharSequence)cancelMsg, (CharSequence)"cancelPrint")) {
            this.exitConvertProcess();
        }
    }

    public void exitConvertProcess() {
        CodeCCUtils.INSTANCE.infoLog(log, "[convert]exit convert process.");
        if (this.process != null && this.process.isAlive()) {
            this.process.destroyForcibly();
        }
    }

    private void setPrintTaskFlag() {
        File saveFile = FileUtils.getFile((String[])new String[]{this.htmlConvertDto.getSaveFileName()});
        if (!saveFile.exists() || saveFile.length() == 0L) {
            ProgressPropertyUtils.updateConvertProgressProperty((String)this.tempProgressFileName, (String)"successFlag", (String)"0");
            CodeCCUtils.INSTANCE.errorLog(log, "Print process save file fail.");
            return;
        }
        String convertFlag = ProgressPropertyUtils.getConvertProgressByProperty((String)this.tempProgressFileName, (String)"successFlag");
        if (!StringUtils.equalsAny((CharSequence)convertFlag, (CharSequence[])new CharSequence[]{"1", "0"})) {
            ProgressPropertyUtils.updateConvertProgressProperty((String)this.tempProgressFileName, (String)"successFlag", (String)"2");
        }
    }

    public void setHtmlConvertDto(HtmlConvertDto htmlConvertDto) {
        this.htmlConvertDto = htmlConvertDto;
    }

    public void setEventBus(AsyncEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public void setTempProgressFileName(String tempProgressFileName) {
        this.tempProgressFileName = tempProgressFileName;
    }

    public HtmlConvertDto getHtmlConvertDto() {
        return this.htmlConvertDto;
    }

    public AsyncEventBus getEventBus() {
        return this.eventBus;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getTempProgressFileName() {
        return this.tempProgressFileName;
    }

    static {
        try {
            if (!FileUtils.getFile((String[])new String[]{PrintPageConstants.PRINT_PROCESS_RUNNING_FILE_PATH}).exists()) {
                IcsFileUtils.copyFile((String)PrintPageConstants.JAVAX_RUNNING_FILE_PATH, (String)PrintPageConstants.PRINT_PROCESS_RUNNING_FILE_PATH);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Create print progress running file error.", (Throwable)e);
        }
    }
}

