/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.init;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.business.authorization.serviceimpl.CertificateBusinessHandler;
import com.huawei.support.icslite.business.customsort.service.impl.CustomSortBusinessHandler;
import com.huawei.support.icslite.business.docnote.service.impl.DocNoteBusinessHandler;
import com.huawei.support.icslite.business.downloadmanage.service.impl.DownloadManageServiceHandler;
import com.huawei.support.icslite.business.hdx.navi.service.impl.HdxNaviBusinessHandler;
import com.huawei.support.icslite.business.ics.navi.service.impl.IcsNaviBusinessHandler;
import com.huawei.support.icslite.business.index.serviceimpl.HdxIndexBusinessHandler;
import com.huawei.support.icslite.business.index.serviceimpl.IcsIndexBusinessHandler;
import com.huawei.support.icslite.business.libmanage.serviceimpl.LibManageServiceHandler;
import com.huawei.support.icslite.business.offlinedownload.service.impl.OfflineDownloadSingleServiceHandler;
import com.huawei.support.icslite.business.onlinelib.serviceimpl.FavoritesBusinessHandler;
import com.huawei.support.icslite.business.preferences.serviceimpl.PreferencesServiceHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.KmcMigrationBroker;
import com.huawei.support.icslite.business.softwaremanage.service.impl.SoftwareManageDirBusinessHandler;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.download.service.impl.SoftwareManageFileServiceHandler;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public enum DerbyTableInit {
    INSTANCE;

    private static final CommonLogger LOG;
    private static final String DERBY_PROPERTIES_FILE_NAME = "derby.properties";
    private static final String CURRENT_DB_VERSION = "current.db.version";
    private static final Object SYNC_OBJ;
    private static final String DERBY_CONFIG_FILE;

    public void initDbTable() {
        CodeCCUtils.INSTANCE.infoLog(LOG, "icslitedb table start to create.");
        String curDbVersion = this.getDbInitFlag(CURRENT_DB_VERSION);
        String softVersion = PreferencesServiceHandler.getInstance().getAboutData().getSoftVersion();
        if (StringUtils.equals((CharSequence)curDbVersion, (CharSequence)softVersion)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "icslitedb is latest.");
            return;
        }
        LibManageServiceHandler.getInstance().createTb();
        CustomSortBusinessHandler.getInstance().createTb();
        DocNoteBusinessHandler.getInstance().createTb();
        FavoritesBusinessHandler.getInstance().createTb();
        HdxIndexBusinessHandler.getInstance().createIndexTb();
        IcsIndexBusinessHandler.getInstance().createIndexTb();
        IcsNaviBusinessHandler.getInstance().createNaviTb();
        HdxNaviBusinessHandler.getInstance().createTb();
        DownloadManageServiceHandler.getInstance().createTb();
        OfflineDownloadSingleServiceHandler.getInstance().createTb();
        CertificateBusinessHandler.getInstance().createTb();
        SoftwareManageFileServiceHandler.getInstance().createTb();
        SoftwareManageDirBusinessHandler.getInstance().createTb();
        KmcMigrationBroker.getInstance().execute();
        String hisIndexV = ConfigServiceHandler.getInstance().get("system.his.version");
        IcsIndexBusinessHandler.getInstance().upgradeIndex(hisIndexV);
        HdxIndexBusinessHandler.getInstance().upgradeIndex(hisIndexV);
        this.setDbInitFlag(CURRENT_DB_VERSION, softVersion, true);
        CodeCCUtils.INSTANCE.infoLog(LOG, "icslitedb table end to create.");
    }

    public void pretreatment() {
        File file = FileUtils.getFile((String[])new String[]{IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "icslitedb"});
        if (file == null || !file.exists()) {
            this.setDbInitFlag(CURRENT_DB_VERSION, "", false);
        }
    }

    private String getDbInitFlag(String fieldName) {
        Properties derbyProperties = PropertiesUtils.getPropertiesByFile((File)this.getDbConfigFile());
        if (derbyProperties == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getDbInitFlag load failed.");
            return "";
        }
        return derbyProperties.getProperty(fieldName);
    }

    private void setDbInitFlag(String fieldName, String value, boolean isAsyn) {
        if (isAsyn) {
            ThreadPoolExecutor commonThreadPool = ThreadPoolFactory.getThreadPool((String)"common", (int)2, (int)300, (int)10, (int)100);
            commonThreadPool.execute(() -> this.configPropertyProcess(fieldName, value));
        } else {
            this.configPropertyProcess(fieldName, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configPropertyProcess(String fieldName, String value) {
        Object object = SYNC_OBJ;
        synchronized (object) {
            File file = this.getDbConfigFile();
            if (!file.exists()) {
                return;
            }
            Properties derbyProperties = PropertiesUtils.getPropertiesByFile((File)this.getDbConfigFile());
            if (derbyProperties == null) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "derbyProperties load failed.");
                return;
            }
            derbyProperties.setProperty(fieldName, StringUtils.isBlank((CharSequence)value) ? "" : value);
            PropertiesUtils.storeProperties((Properties)derbyProperties, (String)DERBY_CONFIG_FILE);
        }
    }

    private File getDbConfigFile() {
        File file = FileUtils.getFile((String[])new String[]{DERBY_CONFIG_FILE});
        if (file.exists()) {
            return file;
        }
        try {
            if (!file.createNewFile()) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "create DerbyPropertiesFile fail.");
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create DerbyPropertiesFile fail.", (Throwable)e);
        }
        return file;
    }

    static {
        LOG = CommonLoggerFactory.getLogger(DerbyTableInit.class);
        SYNC_OBJ = new Object();
        DERBY_CONFIG_FILE = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + DERBY_PROPERTIES_FILE_NAME;
    }
}

