/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.init;

import com.huawei.support.ics.common.adapter.encryption.service.kmc.exception.KmcPropertiesException;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.business.common.serviceimpl.KmcPathInitConfigHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.customsort.service.impl.CustomSortBusinessHandler;
import com.huawei.support.icslite.business.doubleclicklib.util.DoubleClickRegUtils;
import com.huawei.support.icslite.business.downloadmanage.service.impl.DownloadManageServiceHandler;
import com.huawei.support.icslite.business.hdx.navi.service.impl.HdxNaviBusinessHandler;
import com.huawei.support.icslite.business.ics.navi.service.impl.IcsNaviBusinessHandler;
import com.huawei.support.icslite.business.index.serviceimpl.HdxIndexBusinessHandler;
import com.huawei.support.icslite.business.index.serviceimpl.IcsIndexBusinessHandler;
import com.huawei.support.icslite.business.libmanage.serviceimpl.LibManageServiceHandler;
import com.huawei.support.icslite.business.offlinedownload.service.impl.OfflineDownloadSingleServiceHandler;
import com.huawei.support.icslite.business.onlinelib.serviceimpl.OnlineQueryBusinessHandler;
import com.huawei.support.icslite.business.preferences.serviceimpl.CrlUpdateServiceHandler;
import com.huawei.support.icslite.business.resources.init.DerbyTableInit;
import com.huawei.support.icslite.business.schedule.util.ScheduleUtils;
import com.huawei.support.icslite.business.upgrade.serviceimpl.UpgradeBusinessHandler;
import com.huawei.support.icslite.business.upgradelib.service.impl.UpgradeLibBusinessHandler;
import com.huawei.support.icslite.business.verifylib.service.impl.VerifyServiceHandler;
import com.huawei.support.icslite.business.websocket.utils.WebsocketRegistryUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.init.ConfigInitHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.db.dbconfig.DataBaseHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.util.concurrent.ThreadPoolExecutor;

public enum ResourceInit {
    INSTANCE;

    private static final CommonLogger log;

    public void init() throws KmcPropertiesException {
        CodeCCUtils.INSTANCE.infoLog(log, "ICS Lite init,the software directory is :[{0}].", new Object[]{IcsCommonServiceHandler.getInstance().getAppRootDir()});
        this.synchronousInit();
        ThreadPoolExecutor commonThreadPool = ThreadPoolFactory.getThreadPool((String)"common", (int)2, (int)300, (int)10, (int)100);
        commonThreadPool.execute(this::asynchronousInit);
    }

    private void synchronousInit() throws KmcPropertiesException {
        ConfigInitHandler.getInstance().init();
        I18nResources.INSTANCE.initResourceBundle(ConfigServiceHandler.getInstance().get("system.lang"));
        KmcPathInitConfigHandler.getInstance().checkKmcInitStatus();
        DerbyTableInit.INSTANCE.pretreatment();
        DataBaseHandler.getInstance().initDb();
        DerbyTableInit.INSTANCE.initDbTable();
        ScheduleUtils.init();
    }

    private void asynchronousInit() {
        UrlDataServiceHandler.getInstance().init();
        CustomSortBusinessHandler.getInstance().createRootDo();
        LibManageServiceHandler.getInstance().init();
        HdxNaviBusinessHandler.getInstance().startQueue();
        IcsNaviBusinessHandler.getInstance().startQueue();
        CrlUpdateServiceHandler.getInstance().initCrlConfig();
        OnlineQueryBusinessHandler.getInstance().init();
        OfflineDownloadSingleServiceHandler.getInstance().init();
        VerifyServiceHandler.getInstance().init();
        DownloadManageServiceHandler.getInstance().init();
        UpgradeBusinessHandler.getInstance().init();
        HdxNaviBusinessHandler.getInstance().verifyNaviFile();
        IcsNaviBusinessHandler.getInstance().deleteRedundancyFile();
        HdxNaviBusinessHandler.getInstance().continueInitNavi();
        IcsNaviBusinessHandler.getInstance().continueInitNavi();
        IcsIndexBusinessHandler.getInstance().verifyIndex();
        HdxIndexBusinessHandler.getInstance().verify();
        UpgradeLibBusinessHandler.getInstance().initLoadedDocIds();
        DoubleClickRegUtils.setDoubleClickReg();
        WebsocketRegistryUtils.writeUrlProtocolRegData();
    }

    static {
        log = CommonLoggerFactory.getLogger(ResourceInit.class);
    }
}

