/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.resources.kmcmigration.KmcMigrationService;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.db.dbconfig.DataBaseHandler;
import com.huawei.support.icslite.db.dbconfig.DbConnectionUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.jdbc.support.JdbcUtils;

public abstract class DbMigrationHandlerTemplate
extends KmcMigrationService {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DbMigrationHandlerTemplate.class);
    protected static final int DB_PER_PAGE_NUMBER = 100;
    protected static final String OLD_DB_USER_NAME = DataBaseHandler.getInstance().getUserName();
    protected static final String OLD_DB_USER_PASSWORD = DataBaseHandler.getInstance().getPassword();
    protected static final String OLD_DB_BOOT_PASSWORD = DataBaseHandler.getInstance().getBootPassword();
    protected static final String OLD_DB_PATH = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "backup" + File.separator;
    protected int oldDataSize;
    protected PreparedStatement stmt;
    protected int id = 0;
    protected Connection connection = DbConnectionUtil.buildConnection((String)OLD_DB_USER_NAME, (String)OLD_DB_USER_PASSWORD, (String)OLD_DB_BOOT_PASSWORD, (String)OLD_DB_PATH);

    protected abstract void deleteNew();

    protected abstract boolean saveOldData(ResultSet var1);

    @Override
    public final void doMigration() {
        if (this.connection == null) {
            CodeCCUtils.INSTANCE.errorLog(log, "Old database connection is null.");
            return;
        }
        this.readOldData();
        this.deleteData();
        this.migrationOldData();
    }

    protected void deleteData() {
        if (this.oldDataSize <= 0 || this.stmt == null) {
            return;
        }
        this.deleteNew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean migrationOldData() {
        if (this.oldDataSize <= 0 || this.stmt == null) {
            return false;
        }
        int minIndex = 0;
        ResultSet rs = null;
        try {
            while (this.oldDataSize - minIndex > 0) {
                int startIndex = minIndex;
                if (this.id > 0) {
                    startIndex = this.id;
                }
                this.stmt.setInt(1, startIndex);
                this.stmt.setInt(2, 100);
                try {
                    rs = this.stmt.executeQuery();
                    this.saveOldData(rs);
                }
                finally {
                    JdbcUtils.closeResultSet((ResultSet)rs);
                }
                minIndex += 100;
            }
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrateOldData error.");
            boolean bl = false;
            return bl;
        }
        finally {
            JdbcUtils.closeStatement((Statement)this.stmt);
            JdbcUtils.closeConnection((Connection)this.connection);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readOldDataSize(String tableName, PreparedStatement statement) {
        int totalRow = 0;
        try (ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                totalRow = rs.getInt("totalRow");
            }
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Select {0} table data size error.", new Object[]{tableName});
        }
        finally {
            JdbcUtils.closeStatement((Statement)statement);
        }
        return totalRow;
    }
}

