/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.business.resources.kmcmigration.KmcMigrationService;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationCustomDirHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationDownloadHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationHdxContentHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationHdxContentOldHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationHdxIndexHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationHdxNaviStatuHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationIcsContentHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationIcsContentLastOldHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationIcsContentOldHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationIcsDocNavHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationIcsMetaNameHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationIcsMetaValueHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationIcsPidHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationIcsVerRelationGroupHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationIcsVerRelationProductHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationIndexHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationNaviPidStatusHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationNaviTopicHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationNaviTopicMetaHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationNaviTopicRelationHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationOfflineDownloadHandler;
import com.huawei.support.icslite.business.resources.kmcmigration.MigrationProxyHandler;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class KmcMigrationBroker {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(KmcMigrationBroker.class);
    private static final String THREAD_POOL_NAME = "kmcmigration";
    private static final int CORE_SIZE = 2;
    private static final int KEEP_ALIVE_SECONDS = 300;
    private static final int MAX_POOL_SIZE = 5;
    private static final int QUEUE_CAPACITY = 25;
    private List<KmcMigrationService> migrationHandlers = new ArrayList<KmcMigrationService>();
    private ThreadPoolExecutor migrationThreadPoolExecutor = ThreadPoolFactory.getThreadPool((String)"kmcmigration", (int)2, (int)300, (int)5, (int)25);

    private KmcMigrationBroker() {
    }

    private void init() {
        this.addMigrationHandler(new MigrationProxyHandler());
        this.addMigrationHandler(new MigrationCustomDirHandler());
        this.addMigrationHandler(new MigrationDownloadHandler());
        this.addMigrationHandler(new MigrationOfflineDownloadHandler());
        this.addMigrationHandler(new MigrationHdxContentHandler());
        this.addMigrationHandler(new MigrationHdxContentOldHandler());
        this.addMigrationHandler(new MigrationHdxIndexHandler());
        this.addMigrationHandler(new MigrationHdxNaviStatuHandler());
        this.addMigrationHandler(new MigrationIcsContentHandler());
        this.addMigrationHandler(new MigrationIcsContentLastOldHandler());
        this.addMigrationHandler(new MigrationIcsContentOldHandler());
        this.addMigrationHandler(new MigrationIcsDocNavHandler());
        this.addMigrationHandler(new MigrationIcsMetaNameHandler());
        this.addMigrationHandler(new MigrationIcsMetaValueHandler());
        this.addMigrationHandler(new MigrationIcsPidHandler());
        this.addMigrationHandler(new MigrationIcsVerRelationGroupHandler());
        this.addMigrationHandler(new MigrationIcsVerRelationProductHandler());
        this.addMigrationHandler(new MigrationIndexHandler());
        this.addMigrationHandler(new MigrationNaviTopicRelationHandler());
        this.addMigrationHandler(new MigrationNaviPidStatusHandler());
        this.addMigrationHandler(new MigrationNaviTopicHandler());
        this.addMigrationHandler(new MigrationNaviTopicMetaHandler());
    }

    private void addMigrationHandler(KmcMigrationService migrationHandler) {
        this.migrationHandlers.add(migrationHandler);
    }

    public static KmcMigrationBroker getInstance() {
        return MigrationEncryptDataChainHandlerHolder.INSTANCE;
    }

    public boolean execute() {
        String backupPath = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "backup";
        if (StringUtils.equals((CharSequence)"true", (CharSequence)ConfigServiceHandler.getInstance().getFromFile("system.old.encryptData.migrated")) || !FileUtils.getFile((String[])new String[]{backupPath}).exists()) {
            ConfigServiceHandler.getInstance().set("system.old.encryptData.migrated", "true");
            CodeCCUtils.INSTANCE.infoLog(log, "Old encryptData has migrated or old database not exist.");
            return true;
        }
        CodeCCUtils.INSTANCE.infoLog(log, "Migration old encryptData start.");
        this.init();
        this.handleMigrationTask();
        boolean isSuccess = ConfigServiceHandler.getInstance().set("system.old.encryptData.migrated", "true");
        CodeCCUtils.INSTANCE.infoLog(log, "Migration old encryptData end.");
        return isSuccess;
    }

    private void handleMigrationTask() {
        CountDownLatch downLatch = new CountDownLatch(this.migrationHandlers.size());
        long start = System.currentTimeMillis();
        this.migrationHandlers.forEach(migrationHandler -> this.migrationThreadPoolExecutor.execute(() -> {
            try {
                migrationHandler.doMigration();
            }
            catch (Exception e) {
                CodeCCUtils.INSTANCE.errorLog(log, "Migration data error.");
            }
            finally {
                downLatch.countDown();
            }
        }));
        try {
            downLatch.await();
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "DownLatch await error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationHandlers domigration time spent " + (System.currentTimeMillis() - start) + " ms");
    }

    private static class MigrationEncryptDataChainHandlerHolder {
        private static final KmcMigrationBroker INSTANCE = new KmcMigrationBroker();

        private MigrationEncryptDataChainHandlerHolder() {
        }
    }
}

