/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.resources.kmcmigration;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.customsort.convert.CustomSortConverter;
import com.huawei.support.icslite.business.resources.kmcmigration.DbMigrationHandlerTemplate;
import com.huawei.support.icslite.customsort.dto.CustomSortDo;
import com.huawei.support.icslite.customsort.dto.OldDbCustomSortDo;
import com.huawei.support.icslite.customsort.service.impl.CustomSortServiceHandler;
import com.huawei.support.icslite.db.dbconfig.DbMigrateResultSetHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class MigrationCustomDirHandler
extends DbMigrationHandlerTemplate {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(MigrationCustomDirHandler.class);
    private static final String QUERY_OLD_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM TB_CUSTOMSORT";
    private static final String QUERY_OLD_DATA_SQL = "select * from TB_CUSTOMSORT OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";
    private static final String QUERY_DATA_SIZE_SQL = "SELECT COUNT(1) AS totalRow FROM TB_CUSTOMDIR";
    private static final String QUERY_DATA_SQL = "select * from TB_CUSTOMDIR OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";

    @Override
    protected void readOldData() {
        Throwable throwable;
        PreparedStatement statement;
        try {
            statement = this.connection.prepareStatement(QUERY_DATA_SIZE_SQL);
            throwable = null;
            try {
                int dataCount = this.readOldDataSize("TB_CUSTOMDIR", statement);
                if (dataCount > 0) {
                    this.stmt = this.connection.prepareStatement(QUERY_DATA_SQL);
                    this.oldDataSize = dataCount;
                    CodeCCUtils.INSTANCE.infoLog(log, "MigrationCustomDirHandler TB_CUSTOMDIR readOldData. datasize = " + this.oldDataSize);
                    return;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationCustomDirHandler readOldData error.");
        }
        try {
            statement = this.connection.prepareStatement(QUERY_OLD_DATA_SIZE_SQL);
            throwable = null;
            try {
                this.oldDataSize = this.readOldDataSize("TB_CUSTOMSORT", statement);
                this.stmt = this.connection.prepareStatement(QUERY_OLD_DATA_SQL);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "MigrationCustomDirHandler readOldDataSize error.");
        }
        CodeCCUtils.INSTANCE.infoLog(log, "MigrationCustomDirHandler TB_CUSTOMSORT readOldData. datasize = " + this.oldDataSize);
    }

    @Override
    protected void deleteNew() {
        CustomSortServiceHandler.getInstance().delAll();
    }

    @Override
    protected boolean saveOldData(ResultSet rs) {
        DbMigrateResultSetHandler res = new DbMigrateResultSetHandler(rs, OldDbCustomSortDo.class);
        List<CustomSortDo> resultList = CustomSortConverter.INSTANCE.domainOldCustomDos(res.getBeanList());
        if (!CustomSortServiceHandler.getInstance().addBatch(resultList)) {
            CodeCCUtils.INSTANCE.errorLog(log, "Custom dir migration data exist failed.");
            return false;
        }
        return true;
    }
}

